/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.parser.Parser;

@NonNullByDefault
public abstract class AbstractJacksonYAMLParser<T>
implements Parser<T> {
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    static {
        YAML_MAPPER.findAndRegisterModules();
    }

    @Override
    public void serialize(Set<T> dataObjects, OutputStreamWriter writer) throws Exception {
        for (T dataObject : dataObjects) {
            YAML_MAPPER.writeValue((Writer)writer, dataObject);
        }
    }
}

