/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class HardStringWizardPanel
extends JPanel
implements ListSelectionListener {
    private static final int COLUMN_INDEX_CHECK = 0;
    private static final int COLUMN_INDEX_HARDSTRING = 1;
    private static final int COLUMN_INDEX_KEY = 2;
    private static final int COLUMN_INDEX_VALUE = 3;
    private static final int COLUMN_INDEX_CUSTOM = 4;
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final AbstractTableModel tableModel = new HardCodedStringTableModel();
    private JLabel hardStringLabel;
    private JTable hardStringTable;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JEditorPane preview;
    private JScrollPane scrollPane;
    private JComboBox sourceCombo;
    private JLabel sourceLabel;

    private HardStringWizardPanel() {
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)"internation.FoundStrings");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private void setComboModel(Map<DataObject, SourceData> sourceMap) {
        ArrayList<DataObject> nonEmptySources = new ArrayList<DataObject>();
        String mimeType = null;
        for (Map.Entry<DataObject, SourceData> entry : sourceMap.entrySet()) {
            if (entry.getValue().getStringMap().isEmpty()) continue;
            nonEmptySources.add(entry.getKey());
            mimeType = entry.getKey().getPrimaryFile().getMIMEType();
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(nonEmptySources.toArray()));
        if (mimeType != null) {
            this.preview.setContentType(mimeType);
        }
        if (!nonEmptySources.isEmpty()) {
            this.sourceComboActionPerformed(null);
        }
    }

    private void postInitComponents() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.hardStringLabel.setLabelFor(this.hardStringTable);
    }

    public Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<DataObject, SourceData> sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.setComboModel(sourceMap);
    }

    private Map<HardCodedString, I18nString> getStringMap() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        return sourceData == null ? null : sourceData.getStringMap();
    }

    private Set<HardCodedString> getRemovedStrings() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        if (sourceData == null) {
            return null;
        }
        if (sourceData.getRemovedStrings() == null) {
            HashSet<HardCodedString> removed = new HashSet<HardCodedString>();
            Map<HardCodedString, I18nString> stringMap = sourceData.getStringMap();
            for (Map.Entry<HardCodedString, I18nString> entry : stringMap.entrySet()) {
                if (!entry.getValue().getKey().equals("")) continue;
                removed.add(entry.getKey());
            }
            sourceData.setRemovedStrings(removed);
        }
        return sourceData.getRemovedStrings();
    }

    private void initTable() {
        this.hardStringTable.setDefaultRenderer(HardCodedString.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                I18nSupport.I18nFinder finder;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                HardCodedString hcString = (HardCodedString)value;
                label.setText(hcString != null ? hcString.getText() : "");
                SourceData data = HardStringWizardPanel.this.sourceMap.get(HardStringWizardPanel.this.sourceCombo.getSelectedItem());
                I18nSupport support = data.getSupport();
                if (support != null && (finder = support.getFinder()) instanceof JavaI18nFinder && label != null && hcString != null) {
                    HardCodedString newHCstring = ((JavaI18nFinder)finder).modifyHCStringText(hcString);
                    label.setText(newHCstring != null ? newHCstring.getText() : hcString.getText());
                }
                return label;
            }
        });
        this.hardStringTable.setDefaultRenderer(I18nString.class, new DefaultTableCellRenderer(){
            private final JButton dotButton = new JButton("...");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                I18nString i18nString = (I18nString)value;
                int modelColumn = HardStringWizardPanel.this.hardStringTable.convertColumnIndexToModel(column);
                if (modelColumn == 4) {
                    return this.dotButton;
                }
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (i18nString != null) {
                    label.setText(modelColumn == 2 ? i18nString.getKey() : i18nString.getValue());
                } else {
                    label.setText("");
                }
                return label;
            }
        });
        this.hardStringTable.setDefaultEditor(I18nString.class, new DefaultCellEditor(new JTextField()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                I18nString i18nString = (I18nString)value;
                int modelColumn = HardStringWizardPanel.this.hardStringTable.convertColumnIndexToModel(column);
                value = modelColumn == 2 ? (i18nString == null ? "" : i18nString.getKey()) : (modelColumn == 3 ? (i18nString == null ? "" : i18nString.getValue()) : "");
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        });
        Component cellSample = new DefaultTableCellRenderer().getTableCellRendererComponent(this.hardStringTable, "N/A", false, false, 0, 0);
        int cellHeight = cellSample.getPreferredSize().height;
        int rowHeight = cellHeight + this.hardStringTable.getRowMargin();
        this.hardStringTable.setRowHeight(Math.max(16, rowHeight));
        this.hardStringTable.getColumnModel().getColumn(4).setCellEditor(new CustomizeCellEditor());
        this.hardStringTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.hardStringTable.getColumnModel().getColumn(4).setMaxWidth(30);
        this.hardStringTable.getSelectionModel().addListSelectionListener(this);
    }

    private void initAccessibility() {
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HardStringWizardPanel.class, (String)"ACSD_sourceCombo"));
        this.hardStringTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HardStringWizardPanel.class, (String)"ACSD_hardStringTable"));
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.hardStringLabel = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.scrollPane = new JScrollPane();
        this.hardStringTable = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.preview = new JEditorPane();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HardStringWizardPanel.this.sourceComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.hardStringLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_FoundStrings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.hardStringLabel, gridBagConstraints);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.hardStringTable.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.hardStringTable);
        this.jSplitPane1.setLeftComponent(this.scrollPane);
        this.preview.setEditable(false);
        this.jScrollPane1.setViewportView(this.preview);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        if (this.sourceMap.get(this.sourceCombo.getSelectedItem()).getStringMap().isEmpty()) {
            JLabel label = new JLabel(NbBundle.getBundle(HardStringWizardPanel.class).getString("TXT_NoHardstringsSource"));
            label.setHorizontalAlignment(0);
            this.scrollPane.setViewportView(label);
        } else {
            this.scrollPane.setViewportView(this.hardStringTable);
            this.tableModel.fireTableDataChanged();
        }
        SourceData data = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        StyledDocument doc = data.getSupport().getDocument();
        this.preview.setDocument(doc);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o;
        int ix = this.hardStringTable.getSelectedRow();
        if (ix >= 0 && (o = this.hardStringTable.getModel().getValueAt(ix, 1)) instanceof HardCodedString) {
            HardCodedString hard = (HardCodedString)o;
            Position start = hard.getStartPosition();
            Position end = hard.getEndPosition();
            this.preview.setSelectionStart(start.getOffset());
            this.preview.setSelectionEnd(end.getOffset());
        }
    }

    private class HardCodedStringTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            Map<HardCodedString, I18nString> stringMap = HardStringWizardPanel.this.getStringMap();
            return stringMap == null ? 0 : stringMap.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map<HardCodedString, I18nString> stringMap = HardStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return null;
            }
            if (columnIndex == 0) {
                if (HardStringWizardPanel.this.getRemovedStrings().contains(stringMap.keySet().toArray()[rowIndex])) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (columnIndex == 1) {
                return stringMap.keySet().toArray()[rowIndex];
            }
            return stringMap.values().toArray()[rowIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Map<HardCodedString, I18nString> stringMap = HardStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return;
            }
            switch (columnIndex) {
                case 1: {
                    return;
                }
                case 4: {
                    I18nString otherValue = (I18nString)this.getValueAt(rowIndex, 2);
                    if (!((I18nString)value).getKey().equals("")) {
                        this.setValueAt(Boolean.TRUE, rowIndex, 0);
                        break;
                    }
                    this.setValueAt(Boolean.FALSE, rowIndex, 0);
                    break;
                }
                case 0: {
                    if (!(value instanceof Boolean)) break;
                    if (((Boolean)value).booleanValue() && ((I18nString)this.getValueAt(rowIndex, 2)).getKey().equals("")) {
                        String message = NbBundle.getMessage(HardStringWizardPanel.class, (String)"MSG_CANNOT_INSERT_EMPTY_KEYS");
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        break;
                    }
                    Set<HardCodedString> hcStrings = stringMap.keySet();
                    HardCodedString[] hcStringsArr = hcStrings.toArray(new HardCodedString[0]);
                    HardCodedString hardString = hcStringsArr[rowIndex];
                    Set<HardCodedString> removedStrings = HardStringWizardPanel.this.getRemovedStrings();
                    if (((Boolean)value).booleanValue()) {
                        removedStrings.remove(hardString);
                        break;
                    }
                    removedStrings.add(hardString);
                    break;
                }
                case 2: {
                    I18nString i18nString = (I18nString)stringMap.values().toArray()[rowIndex];
                    i18nString.setKey(value.toString());
                    if (!value.toString().equals("")) {
                        this.setValueAt(Boolean.TRUE, rowIndex, 0);
                        break;
                    }
                    this.setValueAt(Boolean.FALSE, rowIndex, 0);
                    break;
                }
                case 3: {
                    I18nString i18nString = (I18nString)stringMap.values().toArray()[rowIndex];
                    i18nString.setValue(value.toString());
                    if (i18nString.getKey().equals("")) break;
                    this.setValueAt(Boolean.TRUE, rowIndex, 0);
                    break;
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return HardCodedString.class;
            }
            return I18nString.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_HardString");
            }
            if (column == 2) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Key");
            }
            if (column == 3) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Value");
            }
            return " ";
        }
    }

    public static class CustomizeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private I18nString i18nString;
        private JButton editorComponent = new JButton("...");

        public CustomizeCellEditor() {
            this.editorComponent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PropertyPanel panel = i18nString.getSupport().getPropertyPanel();
                    I18nString clone = (I18nString)i18nString.clone();
                    panel.setI18nString(i18nString);
                    String title = Util.getString("PROP_cust_dialog_name");
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, title);
                    dd.setModal(true);
                    dd.setOptionType(-1);
                    Object[] options = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
                    dd.setOptions(options);
                    dd.setHelpCtx(new HelpCtx("i18n.pe.i18nString"));
                    dd.setButtonListener((ActionListener)this);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                    dialog.setVisible(true);
                    if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
                        i18nString.become(clone);
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.i18nString = (I18nString)value;
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.i18nString;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.stopCellEditing();
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements WizardDescriptor.FinishablePanel<I18nWizardDescriptor.Settings>,
    WizardDescriptor.AsynchronousValidatingPanel<I18nWizardDescriptor.Settings> {
        private static final String CARD_GUI = "gui";
        private static final String CARD_MSG = "msg";
        private static final String CARD_REPLACING = "replacing";
        private JLabel emptyLabel;
        private transient HardStringWizardPanel hardStringPanel;
        private volatile boolean hasFoundStrings;
        private volatile ProgressWizardPanel progressPanel;

        @Override
        protected Component createComponent() {
            JPanel panel = new JPanel(new CardLayout());
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(HardStringWizardPanel.class).getString("ACS_HardStringWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", 3);
            panel.setName(NbBundle.getBundle(HardStringWizardPanel.class).getString("TXT_ModifyStrings"));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            return panel;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        public boolean isFinishPanel() {
            return true;
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            this.hasFoundStrings = Panel.foundStrings(this.getMap());
            JPanel panel = (JPanel)this.getComponent();
            if (this.hasFoundStrings) {
                panel.add((Component)this.getUI(), CARD_GUI);
                ((CardLayout)panel.getLayout()).show(panel, CARD_GUI);
            } else {
                panel.add((Component)this.getMessageComp(), CARD_MSG);
                ((CardLayout)panel.getLayout()).show(panel, CARD_MSG);
            }
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void prepareValidation() {
            assert (EventQueue.isDispatchThread());
            if (this.hasFoundStrings) {
                if (this.progressPanel == null) {
                    this.progressPanel = new ProgressWizardPanel(true);
                }
                this.progressPanel.setMainText(NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Internationalizing"));
                this.progressPanel.setMainProgress(0);
                Container container = (Container)this.getComponent();
                container.add((Component)this.progressPanel, CARD_REPLACING);
                ((CardLayout)container.getLayout()).show(container, CARD_REPLACING);
            }
        }

        public void validate() throws WizardValidationException {
            assert (!EventQueue.isDispatchThread());
            if (this.hasFoundStrings) {
                Map<DataObject, SourceData> sourceMap = this.getUI().getSourceMap();
                int outerCounter = 0;
                for (Map.Entry<DataObject, SourceData> srcMapEntry : sourceMap.entrySet()) {
                    ++outerCounter;
                    DataObject source = srcMapEntry.getKey();
                    SourceData sourceData = srcMapEntry.getValue();
                    I18nSupport support = sourceData.getSupport();
                    Map<HardCodedString, I18nString> stringMap = sourceData.getStringMap();
                    Set<HardCodedString> removed = sourceData.getRemovedStrings();
                    ClassPath cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                    this.progressPanel.setSubText(NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Source") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                    int innerCounter = 0;
                    for (Map.Entry<HardCodedString, I18nString> entry : stringMap.entrySet()) {
                        ++innerCounter;
                        HardCodedString hcString = entry.getKey();
                        I18nString i18nString = entry.getValue();
                        if (removed != null && removed.contains(hcString)) continue;
                        support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
                        support.getReplacer().replace(hcString, i18nString);
                        this.progressPanel.setSubProgress((int)((float)innerCounter / (float)stringMap.size() * 100.0f));
                    }
                    if (support.hasAdditionalCustomizer()) {
                        support.performAdditionalChanges();
                    }
                    this.progressPanel.setMainProgress((int)((float)outerCounter / (float)sourceMap.size() * 100.0f));
                }
            }
        }

        private static boolean foundStrings(Map<DataObject, SourceData> sourceMap) {
            for (Map.Entry<DataObject, SourceData> entry : sourceMap.entrySet()) {
                if (entry.getValue().getStringMap().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.wizard");
        }

        private synchronized HardStringWizardPanel getUI() {
            if (this.hardStringPanel == null) {
                this.hardStringPanel = new HardStringWizardPanel();
            }
            return this.hardStringPanel;
        }

        private JComponent getMessageComp() {
            if (this.emptyLabel == null) {
                this.emptyLabel = new JLabel(NbBundle.getMessage(this.getClass(), (String)"TXT_NoHardstrings"));
                this.emptyLabel.setHorizontalAlignment(0);
                this.emptyLabel.setVerticalAlignment(0);
            }
            return this.emptyLabel;
        }
    }
}

