/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.TunnelRouteSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListIPSecConnectionTunnelRoutesRequest
extends BmcRequest<Void> {
    private String ipscId;
    private String tunnelId;
    private Integer limit;
    private String page;
    private TunnelRouteSummary.Advertiser advertiser;

    public String getIpscId() {
        return this.ipscId;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public TunnelRouteSummary.Advertiser getAdvertiser() {
        return this.advertiser;
    }

    public Builder toBuilder() {
        return new Builder().ipscId(this.ipscId).tunnelId(this.tunnelId).limit(this.limit).page(this.page).advertiser(this.advertiser);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ipscId=").append(String.valueOf(this.ipscId));
        sb.append(",tunnelId=").append(String.valueOf(this.tunnelId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",advertiser=").append(String.valueOf((Object)this.advertiser));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIPSecConnectionTunnelRoutesRequest)) {
            return false;
        }
        ListIPSecConnectionTunnelRoutesRequest other = (ListIPSecConnectionTunnelRoutesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ipscId, other.ipscId) && Objects.equals(this.tunnelId, other.tunnelId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.advertiser, (Object)other.advertiser);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipscId == null ? 43 : this.ipscId.hashCode());
        result = result * 59 + (this.tunnelId == null ? 43 : this.tunnelId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.advertiser == null ? 43 : this.advertiser.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIPSecConnectionTunnelRoutesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ipscId = null;
        private String tunnelId = null;
        private Integer limit = null;
        private String page = null;
        private TunnelRouteSummary.Advertiser advertiser = null;

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder advertiser(TunnelRouteSummary.Advertiser advertiser) {
            this.advertiser = advertiser;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIPSecConnectionTunnelRoutesRequest o) {
            this.ipscId(o.getIpscId());
            this.tunnelId(o.getTunnelId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.advertiser(o.getAdvertiser());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIPSecConnectionTunnelRoutesRequest build() {
            ListIPSecConnectionTunnelRoutesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIPSecConnectionTunnelRoutesRequest buildWithoutInvocationCallback() {
            ListIPSecConnectionTunnelRoutesRequest request = new ListIPSecConnectionTunnelRoutesRequest();
            request.ipscId = this.ipscId;
            request.tunnelId = this.tunnelId;
            request.limit = this.limit;
            request.page = this.page;
            request.advertiser = this.advertiser;
            return request;
        }
    }
}

