/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.NbPreferences;

class HostInfoCache
implements ConnectionListener {
    private static final HostInfoCache INSTANCE = new HostInfoCache();
    private static final String KEY_USERID = "userId";
    private static final String KEY_GRPID = "groupId";
    private static final String KEY_GROUPS = "allGroups";
    private final Preferences preferences = NbPreferences.forModule(HostInfoCache.class);

    public static HostInfoCache getInstance() {
        return INSTANCE;
    }

    static void initializeIfNeeded() {
        HostInfoCache.getInstance();
    }

    private HostInfoCache() {
        ConnectionManager.getInstance().addConnectionListener(this);
    }

    @Override
    public void connected(ExecutionEnvironment env) {
        if (HostInfoUtils.isHostInfoAvailable(env)) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
                this.preferences.putInt(this.getKey(KEY_USERID, env), hostInfo.getUserId());
                this.preferences.putInt(this.getKey(KEY_GRPID, env), hostInfo.getGroupId());
                this.preferences.put(this.getKey(KEY_GROUPS, env), this.toString(hostInfo.getAllGroupIDs()));
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            catch (ConnectionManager.CancellationException cancellationException) {}
        } else {
            Logger.getInstance().log(Level.WARNING, "HostInfo should be available for {0} at this point", new Object[]{env});
        }
    }

    private String toString(int[] array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(array[i]);
            }
        }
        return sb.toString();
    }

    private int[] fromString(String text) {
        if (text != null) {
            String[] split = text.trim().split(",");
            int[] tmp = new int[split.length];
            int cnt = 0;
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() <= 0 || !Character.isDigit(split[i].charAt(0))) continue;
                try {
                    tmp[cnt++] = Integer.parseInt(split[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
            if (cnt == tmp.length) {
                return tmp;
            }
            int[] result = new int[cnt];
            System.arraycopy(tmp, 0, result, 0, cnt);
            return result;
        }
        return new int[0];
    }

    @Override
    public void disconnected(ExecutionEnvironment env) {
    }

    private String getKey(String key, ExecutionEnvironment env) {
        return ExecutionEnvironmentFactory.toUniqueID(env) + "_" + key;
    }

    public int getUserId(ExecutionEnvironment env) {
        return this.preferences.getInt(this.getKey(KEY_USERID, env), -1);
    }

    public int getGroupId(ExecutionEnvironment env) {
        return this.preferences.getInt(this.getKey(KEY_GRPID, env), -1);
    }

    public int[] getAllGroupIDs(ExecutionEnvironment env) {
        return this.fromString(this.preferences.get(this.getKey(KEY_GROUPS, env), ""));
    }
}

