/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.composer.files.ComposerJson;
import org.netbeans.modules.php.composer.util.ComposerUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.util.RequestProcessor;

public final class ComposerLibrariesUsageLogger
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ComposerLibrariesUsageLogger.class);
    private final Project project;
    private ComposerJson composerJson;

    private ComposerLibrariesUsageLogger(Project project) {
        assert (project != null);
        this.project = project;
    }

    void startListening() {
        this.getComposerJson().addPropertyChangeListener(this);
    }

    void stopListening() {
        this.getComposerJson().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("REQUIRE".equals(propertyName) || "REQUIRE_DEV".equals(propertyName)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ComposerLibrariesUsageLogger.this.logLibraries();
                }
            });
        }
    }

    void logLibraries() {
        ComposerJson.ComposerDependencies dependencies = this.getComposerJson().getDependencies();
        this.logLibraries("REGULAR", dependencies.dependencies);
        this.logLibraries("DEVELOPMENT", dependencies.devDependencies);
    }

    private void logLibraries(String type, Map<String, String> dependencies) {
        for (Map.Entry<String, String> dependency : dependencies.entrySet()) {
            ComposerUtils.logUsageComposerLibrary(type, dependency.getKey(), dependency.getValue());
        }
    }

    private synchronized ComposerJson getComposerJson() {
        assert (Thread.holdsLock(this));
        if (this.composerJson == null) {
            PhpModule phpModule = PhpModule.Factory.lookupPhpModule((Project)this.project);
            assert (phpModule != null) : "PHP module must be found in " + this.project.getClass().getName();
            this.composerJson = new ComposerJson(ComposerUtils.getComposerWorkDir(phpModule));
        }
        return this.composerJson;
    }

    public static ComposerLibrariesUsageLogger usageLogger(Project project) {
        return new ComposerLibrariesUsageLogger(project);
    }

    public static ProjectOpenedHook projectOpenedHook(Project project) {
        return new ComposerProjectOpenedHook(project);
    }

    private static final class ComposerProjectOpenedHook
    extends ProjectOpenedHook {
        private final Project project;

        public ComposerProjectOpenedHook(Project project) {
            assert (project != null);
            this.project = project;
        }

        protected void projectOpened() {
            this.getUsageLogger().startListening();
        }

        protected void projectClosed() {
            this.getUsageLogger().stopListening();
        }

        private ComposerLibrariesUsageLogger getUsageLogger() {
            ComposerLibrariesUsageLogger usageLogger = (ComposerLibrariesUsageLogger)this.project.getLookup().lookup(ComposerLibrariesUsageLogger.class);
            assert (usageLogger != null) : "Usage logger must be found in lookup of: " + this.project.getClass().getName();
            return usageLogger;
        }
    }
}

