/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.spi.lsp.StructureProvider;

public class JavaStructureProvider
implements StructureProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaStructureProvider.class.getName());
    private static final ElementUtilities.ElementAcceptor ALL_ACCEPTOR = new ElementUtilities.ElementAcceptor(){

        public boolean accept(Element e, TypeMirror type) {
            return true;
        }
    };

    public List<StructureElement> getStructure(Document doc) {
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js != null) {
            ArrayList<StructureElement> result = new ArrayList<StructureElement>();
            try {
                js.runUserActionTask(cc -> {
                    TreePath tp;
                    Element el;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    Trees trees = cc.getTrees();
                    CompilationUnitTree cu = cc.getCompilationUnit();
                    if (cu.getPackage() != null && (el = trees.getElement(tp = trees.getPath(cu, cu.getPackage()))) != null && el.getKind() == ElementKind.PACKAGE) {
                        StructureProvider.Builder builder = StructureProvider.newBuilder((String)el.getSimpleName().toString(), (StructureElement.Kind)ElementHeaders.javaKind2Structure((Element)el));
                        int start = (int)cc.getTrees().getSourcePositions().getStartPosition(cu, cu.getPackage());
                        int end = (int)cc.getTrees().getSourcePositions().getEndPosition(cu, cu.getPackage());
                        builder.expandedStartOffset(start).selectionStartOffset(start);
                        builder.expandedEndOffset(end).selectionEndOffset(end);
                        result.add(builder.build());
                    }
                    for (Element tel : cc.getTopLevelElements()) {
                        StructureElement jse = JavaStructureProvider.element2StructureElement((CompilationInfo)cc, tel);
                        if (jse == null) continue;
                        result.add(jse);
                    }
                }, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private static StructureElement element2StructureElement(CompilationInfo info, Element el) {
        return ElementHeaders.toStructureElement((CompilationInfo)info, (Element)el, (ElementUtilities.ElementAcceptor)ALL_ACCEPTOR);
    }
}

