/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteCustomerSecretKeyRequest
extends BmcRequest<Void> {
    private String userId;
    private String customerSecretKeyId;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getCustomerSecretKeyId() {
        return this.customerSecretKeyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).customerSecretKeyId(this.customerSecretKeyId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",customerSecretKeyId=").append(String.valueOf(this.customerSecretKeyId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteCustomerSecretKeyRequest)) {
            return false;
        }
        DeleteCustomerSecretKeyRequest other = (DeleteCustomerSecretKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.customerSecretKeyId, other.customerSecretKeyId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.customerSecretKeyId == null ? 43 : this.customerSecretKeyId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteCustomerSecretKeyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String customerSecretKeyId = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder customerSecretKeyId(String customerSecretKeyId) {
            this.customerSecretKeyId = customerSecretKeyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteCustomerSecretKeyRequest o) {
            this.userId(o.getUserId());
            this.customerSecretKeyId(o.getCustomerSecretKeyId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteCustomerSecretKeyRequest build() {
            DeleteCustomerSecretKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteCustomerSecretKeyRequest buildWithoutInvocationCallback() {
            DeleteCustomerSecretKeyRequest request = new DeleteCustomerSecretKeyRequest();
            request.userId = this.userId;
            request.customerSecretKeyId = this.customerSecretKeyId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

