/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.ui.customizer.SpringCustomizerPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CustomizerCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    public ProjectCustomizer.Category createCategory(Lookup context) {
        Project project = CustomizerCategoryProvider.getProject(context);
        ConfigFileManager manager = CustomizerCategoryProvider.getConfigFileManager(project);
        if (manager.getConfigFiles().size() <= 0 && !CustomizerCategoryProvider.hasSpringOnClassPath(project)) {
            return null;
        }
        String categoryName = NbBundle.getMessage(CustomizerCategoryProvider.class, (String)"LBL_SpringFramework");
        return ProjectCustomizer.Category.create((String)"SpringFramework", (String)categoryName, null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        Project project = CustomizerCategoryProvider.getProject(context);
        ConfigFileManager manager = CustomizerCategoryProvider.getConfigFileManager(project);
        SpringCustomizerPanel panel = new SpringCustomizerPanel(project, manager.getConfigFiles(), manager.getConfigFileGroups());
        CategoryListener listener = new CategoryListener(manager, panel);
        category.setOkButtonListener((ActionListener)listener);
        category.setStoreListener((ActionListener)listener);
        return panel;
    }

    private static Project getProject(Lookup context) {
        Project project = (Project)context.lookup(Project.class);
        if (project == null) {
            throw new IllegalStateException("The lookup " + context + " does not contain a Project");
        }
        return project;
    }

    private static ConfigFileManager getConfigFileManager(Project project) {
        ProjectSpringScopeProvider scopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        assert (scopeProvider != null);
        return scopeProvider.getSpringScope().getConfigFileManager();
    }

    private static boolean hasSpringOnClassPath(Project project) {
        SourceGroup[] javaSources;
        for (SourceGroup javaSource : javaSources = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            ClassPath compileCp = ClassPath.getClassPath((FileObject)javaSource.getRootFolder(), (String)"classpath/compile");
            if (compileCp == null || !SpringUtilities.containsSpring(compileCp)) continue;
            return true;
        }
        return false;
    }

    private static final class CategoryListener
    implements ActionListener {
        private final ConfigFileManager manager;
        private final SpringCustomizerPanel panel;
        private volatile List<File> files;
        private volatile List<ConfigFileGroup> groups;

        public CategoryListener(ConfigFileManager manager, SpringCustomizerPanel panel) {
            this.manager = manager;
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.files == null || this.groups == null) {
                assert (SwingUtilities.isEventDispatchThread());
                this.files = this.panel.getConfigFiles();
                this.groups = this.panel.getConfigFileGroups();
            } else {
                this.manager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        manager.putConfigFilesAndGroups(files, groups);
                    }
                });
            }
        }
    }
}

