/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.refactoring.Bundle;
import org.netbeans.modules.lsp.client.bindings.refactoring.LSPBindingsCollection;
import org.netbeans.modules.lsp.client.bindings.refactoring.ModificationResult;
import org.netbeans.modules.lsp.client.bindings.refactoring.tree.DiffElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class Refactoring {
    private static String uri2SimpleName(String uri) {
        int dot = uri.lastIndexOf(47);
        return uri.substring(dot + 1);
    }

    public static class FactoryImpl
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            if (refactoring instanceof WhereUsedQuery) {
                WhereUsedQuery q = (WhereUsedQuery)refactoring;
                LSPBindingsCollection bindings = (LSPBindingsCollection)q.getRefactoringSource().lookup(LSPBindingsCollection.class);
                ReferenceParams params = (ReferenceParams)q.getRefactoringSource().lookup(ReferenceParams.class);
                if (bindings != null && params != null) {
                    return new WhereUsedRefactoringPlugin(q, bindings.servers(), params);
                }
            } else if (refactoring instanceof RenameRefactoring) {
                RenameRefactoring r = (RenameRefactoring)refactoring;
                LSPBindingsCollection bindings = (LSPBindingsCollection)r.getRefactoringSource().lookup(LSPBindingsCollection.class);
                RenameParams params = (RenameParams)r.getRefactoringSource().lookup(RenameParams.class);
                if (bindings != null && params != null) {
                    return new RenameRefactoringPlugin(r, bindings.servers(), params);
                }
            }
            return null;
        }
    }

    public static class LSPCreateFile
    extends SimpleRefactoringElementImplementation {
        private final String uri;
        private final String content;
        private FileObject target;

        public LSPCreateFile(String uri, String content) {
            this.uri = uri;
            this.content = content;
        }

        public String getText() {
            return Bundle.TXT_CreateFile(Refactoring.uri2SimpleName(this.uri));
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                Pair<FileObject, String> p = LSPCreateFile.fileAndRemainingPath(this.uri);
                this.target = FileUtil.createData((FileObject)((FileObject)p.first()), (String)((String)p.second()));
                try (OutputStreamWriter w = new OutputStreamWriter(this.target.getOutputStream(), FileEncodingQuery.getEncoding((FileObject)this.target));){
                    w.write(this.content);
                }
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            try {
                this.target.delete();
                this.target = null;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            try {
                return (FileObject)LSPCreateFile.fileAndRemainingPath(this.uri).first();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private static Pair<FileObject, String> fileAndRemainingPath(String uri) throws URISyntaxException, MalformedURLException {
            FileObject existing;
            StringBuilder path = new StringBuilder();
            while ((existing = URLMapper.findFileObject((URL)new URI(uri).toURL())) == null) {
                int slash = uri.lastIndexOf(47);
                if (path.length() > 0) {
                    path.insert(0, '/');
                }
                path.insert(0, uri.substring(slash + 1));
                uri = uri.substring(0, slash);
            }
            return Pair.of((Object)existing, (Object)path.toString());
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return "=>" + Refactoring.uri2SimpleName(this.uri) + "(" + this.content + ")";
        }
    }

    public static class LSPDeleteFile
    extends SimpleRefactoringElementImplementation {
        private final URL res;
        private final String filename;
        private BackupFacility.Handle id;

        public LSPDeleteFile(FileObject fo) {
            this.res = fo.toURL();
            this.filename = fo.getNameExt();
        }

        public String getText() {
            return Bundle.TXT_DeleteFile(this.filename);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                FileObject fo = URLMapper.findFileObject((URL)this.res);
                if (fo == null) {
                    throw new IOException(this.res.toString());
                }
                this.id = BackupFacility.getDefault().backup(new FileObject[]{fo});
                DataObject.find((FileObject)fo).delete();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            try {
                FileObject f = URLMapper.findFileObject((URL)this.res);
                if (f != null) {
                    // empty if block
                }
                this.id.restore();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.res);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return Refactoring.uri2SimpleName(this.res.toString()) + "=>";
        }
    }

    public static class LSPRenameFile
    extends SimpleRefactoringElementImplementation {
        private final FileObject fo;
        private final String newUri;
        private String oldUri;

        public LSPRenameFile(FileObject fo, String newUri) {
            this.fo = fo;
            this.oldUri = fo.toURI().toString();
            this.newUri = newUri;
        }

        public String getText() {
            return this.fo.isFolder() ? Bundle.TXT_RenameFolder(this.fo.getNameExt()) : Bundle.TXT_RenameFile(this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            this.oldUri = this.fo.getName();
            this.doRename(this.newUri);
        }

        public void undoChange() {
            this.doRename(this.oldUri);
        }

        private void doRename(String uri) {
            try {
                String newName = uri.substring(uri.lastIndexOf(47) + 1);
                DataObject.find((FileObject)this.fo).rename(newName);
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String toString() {
            return Refactoring.uri2SimpleName(this.fo.toURI().toString()) + "=>" + Refactoring.uri2SimpleName(this.newUri);
        }
    }

    public static class LSPRefactoringElementImpl
    extends SimpleRefactoringElementImplementation {
        private final String annotatedLine;
        private final FileObject file;
        private final PositionBounds bounds;

        public LSPRefactoringElementImpl(String annotatedLine, FileObject file, PositionBounds bounds) {
            this.annotatedLine = annotatedLine;
            this.file = file;
            this.bounds = bounds;
        }

        public String getText() {
            return "TODO: getText";
        }

        public String getDisplayText() {
            return this.annotatedLine;
        }

        public void performChange() {
            throw new UnsupportedOperationException();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }
    }

    protected static class RefactoringBase
    implements Utils.Environment {
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final List<Runnable> cancelCallbacks = new ArrayList<Runnable>();
        private Problem problem;

        protected RefactoringBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelRequest() {
            ArrayList<Runnable> localCancelCallbacks;
            this.cancel.set(true);
            List<Runnable> list = this.cancelCallbacks;
            synchronized (list) {
                localCancelCallbacks = new ArrayList<Runnable>(this.cancelCallbacks);
            }
            localCancelCallbacks.forEach(Runnable::run);
        }

        @Override
        public boolean isCanceled() {
            return this.cancel.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCancelCallback(Runnable callback) {
            List<Runnable> list = this.cancelCallbacks;
            synchronized (list) {
                this.cancelCallbacks.add(callback);
            }
        }

        @Override
        public void handleCancellationException(CancellationException ex) {
            this.addProblem(new Problem(false, Bundle.TXT_Canceled()));
        }

        @Override
        public void handleException(Exception ex) {
            this.addProblem(new Problem(true, ex.getLocalizedMessage()));
        }

        protected void addProblem(Problem current) {
            if (this.problem != null) {
                current.setNext(this.problem);
            }
            this.problem = current;
        }

        protected Problem getProblem() {
            return this.problem;
        }
    }

    private static final class RenameRefactoringPlugin
    extends RefactoringBase
    implements RefactoringPlugin {
        private final RenameRefactoring refactoring;
        private final List<LSPBindings> servers;
        private final RenameParams params;

        public RenameRefactoringPlugin(RenameRefactoring refactoring, List<LSPBindings> servers, RenameParams params) {
            this.refactoring = refactoring;
            this.servers = servers;
            this.params = params;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            BiConsumer<LSPBindings, WorkspaceEdit> handleResult = (server, edit) -> {
                try {
                    List<Either<TextDocumentEdit, ResourceOperation>> documentChanges = edit.getDocumentChanges();
                    ModificationResult result = new ModificationResult();
                    HashMap<FileObject, List> file2Diffs = new HashMap<FileObject, List>();
                    HashMap<String, String> newURI2Old = new HashMap<String, String>();
                    HashMap<String, String> newFileURI2Content = new HashMap<String, String>();
                    if (documentChanges != null) {
                        block17: for (Either<TextDocumentEdit, ResourceOperation> part : documentChanges) {
                            if (this.isCanceled()) break;
                            if (part.isLeft()) {
                                String uri = ((TextDocumentEdit)part.getLeft()).getTextDocument().getUri();
                                FileObject file = Utils.fromURI(uri = newURI2Old.getOrDefault(uri, uri));
                                if (file != null) {
                                    for (TextEdit te : ((TextDocumentEdit)part.getLeft()).getEdits()) {
                                        ModificationResult.Difference diff = this.textEdit2Difference(file, te);
                                        file2Diffs.computeIfAbsent(file, f -> new ArrayList()).add(diff);
                                    }
                                    continue;
                                }
                                if (!newFileURI2Content.containsKey(uri)) continue;
                                FileObject temp = FileUtil.createMemoryFileSystem().getRoot().createData("temp.txt");
                                try (OutputStream out = temp.getOutputStream();){
                                    out.write(((String)newFileURI2Content.get(uri)).getBytes());
                                }
                                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                                for (TextEdit te : ((TextDocumentEdit)part.getLeft()).getEdits()) {
                                    diffs.add(this.textEdit2Difference(temp, te));
                                }
                                ModificationResult tempResult = new ModificationResult();
                                tempResult.addDifferences(temp, diffs);
                                newFileURI2Content.put(uri, tempResult.getResultingSource(temp));
                                continue;
                            }
                            switch (((ResourceOperation)part.getRight()).getKind()) {
                                case "rename": {
                                    RenameFile rename = (RenameFile)part.getRight();
                                    FileObject file = Utils.fromURI(rename.getOldUri());
                                    refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPRenameFile(file, rename.getNewUri()));
                                    newURI2Old.put(rename.getNewUri(), rename.getOldUri());
                                    continue block17;
                                }
                                case "delete": {
                                    DeleteFile delete = (DeleteFile)part.getRight();
                                    FileObject file = Utils.fromURI(delete.getUri());
                                    refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPDeleteFile(file));
                                    continue block17;
                                }
                                case "create": {
                                    CreateFile create = (CreateFile)part.getRight();
                                    String uri = create.getUri();
                                    newFileURI2Content.put(uri, "");
                                    continue block17;
                                }
                            }
                            this.addProblem(new Problem(true, "Unknown file operation: " + ((ResourceOperation)part.getRight()).getKind()));
                        }
                    } else {
                        for (Map.Entry<String, List<TextEdit>> fileAndChanges : edit.getChanges().entrySet()) {
                            if (!this.isCanceled()) {
                                FileObject file = Utils.fromURI(fileAndChanges.getKey());
                                for (TextEdit te : fileAndChanges.getValue()) {
                                    ModificationResult.Difference diff = this.textEdit2Difference(file, te);
                                    file2Diffs.computeIfAbsent(file, f -> new ArrayList()).add(diff);
                                }
                                continue;
                            }
                            break;
                        }
                    }
                    if (this.isCanceled()) {
                        this.addProblem(new Problem(false, Bundle.TXT_Canceled()));
                    } else {
                        file2Diffs.entrySet().forEach(e -> {
                            ((List)e.getValue()).forEach(diff -> refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, (FileObject)e.getKey(), result)));
                            result.addDifferences((FileObject)e.getKey(), (List)e.getValue());
                        });
                        newFileURI2Content.entrySet().forEach(e -> refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new LSPCreateFile((String)e.getKey(), (String)e.getValue())));
                        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(result)));
                        if (this.isCanceled()) {
                            this.addProblem(new Problem(false, Bundle.TXT_Canceled()));
                        }
                    }
                }
                catch (IOException ex) {
                    this.addProblem(new Problem(true, ex.getLocalizedMessage()));
                }
            };
            Utils.handleBindings(this.servers, server -> true, () -> this.params, (server, params) -> server.getTextDocumentService().rename((RenameParams)params), handleResult);
            return this.getProblem();
        }

        private ModificationResult.Difference textEdit2Difference(FileObject file, TextEdit edit) {
            if (file != null) {
                try {
                    EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                    StyledDocument doc = ec.openDocument();
                    CloneableEditorSupport es = (CloneableEditorSupport)file.getLookup().lookup(CloneableEditorSupport.class);
                    PositionRef start = es.createPositionRef(Utils.getOffset(doc, edit.getRange().getStart()), Position.Bias.Forward);
                    PositionRef end = es.createPositionRef(Utils.getOffset(doc, edit.getRange().getEnd()), Position.Bias.Forward);
                    PositionBounds bounds = new PositionBounds(start, end);
                    return new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, start, end, bounds.getText(), edit.getNewText());
                }
                catch (IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    private static final class WhereUsedRefactoringPlugin
    extends RefactoringBase
    implements RefactoringPlugin {
        private final WhereUsedQuery query;
        private final List<LSPBindings> servers;
        private final ReferenceParams params;

        public WhereUsedRefactoringPlugin(WhereUsedQuery query, List<LSPBindings> servers, ReferenceParams params) {
            this.query = query;
            this.servers = servers;
            this.params = params;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            BiConsumer<LSPBindings, List> handleResult = (server, usages) -> {
                for (Location l : usages) {
                    PositionBounds bounds;
                    if (this.isCanceled()) break;
                    FileObject file = Utils.fromURI(l.getUri());
                    if (file == null) continue;
                    try {
                        CloneableEditorSupport es = (CloneableEditorSupport)file.getLookup().lookup(CloneableEditorSupport.class);
                        EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                        StyledDocument doc = ec.openDocument();
                        bounds = new PositionBounds(es.createPositionRef(Utils.getOffset(doc, l.getRange().getStart()), Position.Bias.Forward), es.createPositionRef(Utils.getOffset(doc, l.getRange().getEnd()), Position.Bias.Forward));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        bounds = null;
                    }
                    LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
                    Line startLine = lc.getLineSet().getCurrent(l.getRange().getStart().getLine());
                    String lineText = startLine.getText();
                    int highlightEnd = Math.min(lineText.length(), l.getRange().getEnd().getCharacter());
                    String annotatedLine = lineText.substring(0, l.getRange().getStart().getCharacter()) + "<strong>" + lineText.substring(l.getRange().getStart().getCharacter(), highlightEnd) + "</strong>" + lineText.substring(highlightEnd);
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new LSPRefactoringElementImpl(annotatedLine, file, bounds));
                }
            };
            Utils.handleBindings(this.servers, server -> true, () -> this.params, (server, params) -> server.getTextDocumentService().references((ReferenceParams)params), handleResult);
            return this.getProblem();
        }
    }
}

