/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.cert.X509Certificate;
import java.util.Deque;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.keycloak.config.ProxyOptions;
import org.keycloak.http.FormPartValue;
import org.keycloak.http.HttpRequest;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.integration.jaxrs.EmptyMultivaluedMap;
import org.keycloak.services.FormPartValueImpl;

public final class QuarkusHttpRequest
implements HttpRequest {
    private static final MultivaluedMap<String, String> EMPTY_FORM_PARAM = new EmptyMultivaluedMap();
    private static final MultivaluedMap<String, FormPartValue> EMPTY_MULTI_MAP_MULTI_PART = new EmptyMultivaluedMap();
    private final ResteasyReactiveRequestContext context;
    private MultivaluedMap<String, String> decodedFormParameters;

    public <R> QuarkusHttpRequest(ResteasyReactiveRequestContext context) {
        this.context = context;
    }

    public String getHttpMethod() {
        if (this.context == null) {
            return null;
        }
        return this.context.getMethod();
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.context == null) {
            return null;
        }
        if (this.decodedFormParameters == null) {
            FormData parameters = this.context.getFormData();
            if (parameters == null || !parameters.iterator().hasNext()) {
                return EMPTY_FORM_PARAM;
            }
            this.decodedFormParameters = new QuarkusMultivaluedHashMap();
            for (String name : parameters) {
                Deque values = parameters.get(name);
                if (values == null || values.isEmpty()) continue;
                for (FormValue value : values) {
                    this.decodedFormParameters.add((Object)name, (Object)value.getValue());
                }
            }
        }
        return this.decodedFormParameters;
    }

    public MultivaluedMap<String, FormPartValue> getMultiPartFormParameters() {
        if (this.context == null) {
            return null;
        }
        FormData formData = this.context.getFormData();
        if (formData == null) {
            return EMPTY_MULTI_MAP_MULTI_PART;
        }
        QuarkusMultivaluedHashMap params = new QuarkusMultivaluedHashMap();
        for (String name : formData) {
            Deque formValues = formData.get(name);
            if (formValues == null) continue;
            for (FormValue formValue : formValues) {
                if (formValue.isFileItem()) {
                    try {
                        params.add((Object)name, (Object)new FormPartValueImpl(formValue.getFileItem().getInputStream()));
                        continue;
                    }
                    catch (IOException cause) {
                        throw new RuntimeException("Failed to parse multipart file parameter", cause);
                    }
                }
                params.add((Object)name, (Object)new FormPartValueImpl(formValue.getValue()));
            }
        }
        return params;
    }

    public HttpHeaders getHttpHeaders() {
        if (this.context == null) {
            return null;
        }
        return this.context.getHttpHeaders();
    }

    public X509Certificate[] getClientCertificateChain() {
        Instance instances = CDI.current().select(RoutingContext.class, new Annotation[0]);
        if (instances.isResolvable()) {
            RoutingContext context = (RoutingContext)instances.get();
            try {
                SSLSession sslSession = context.request().sslSession();
                if (sslSession == null) {
                    return null;
                }
                return (X509Certificate[])sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }

    public UriInfo getUri() {
        if (this.context == null) {
            return null;
        }
        return this.context.getUriInfo();
    }

    public boolean isProxyTrusted() {
        boolean noTrustedProxies = Configuration.getOptionalKcValue(ProxyOptions.PROXY_TRUSTED_ADDRESSES).isEmpty();
        return noTrustedProxies || Boolean.parseBoolean(this.getHttpHeaders().getHeaderString("X-Forwarded-Trusted-Proxy"));
    }
}

