/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialoffer;

import java.util.Map;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.credentialoffer.CredentialOfferStorage;
import org.keycloak.util.JsonSerialization;

class InMemoryCredentialOfferStorage
implements CredentialOfferStorage {
    private static final String ENTRY_KEY = "json";

    InMemoryCredentialOfferStorage() {
    }

    @Override
    public void putOfferState(KeycloakSession session, CredentialOfferStorage.CredentialOfferState entry) {
        String entryJson = JsonSerialization.valueAsString((Object)entry);
        session.singleUseObjects().put(entry.getNonce(), (long)entry.getExpiration(), Map.of(ENTRY_KEY, entryJson));
        entry.getPreAuthorizedCode().ifPresent(it -> session.singleUseObjects().put(it, (long)entry.getExpiration(), Map.of(ENTRY_KEY, entryJson)));
        Optional.ofNullable(entry.getAuthorizationDetails()).ifPresent(it -> it.getCredentialIdentifiers().forEach(cid -> session.singleUseObjects().put(cid, (long)entry.getExpiration(), Map.of(ENTRY_KEY, entryJson))));
    }

    @Override
    public CredentialOfferStorage.CredentialOfferState findOfferStateByNonce(KeycloakSession session, String nonce) {
        if (session.singleUseObjects().contains(nonce)) {
            String entryJson = (String)session.singleUseObjects().get(nonce).get(ENTRY_KEY);
            return (CredentialOfferStorage.CredentialOfferState)JsonSerialization.valueFromString((String)entryJson, CredentialOfferStorage.CredentialOfferState.class);
        }
        return null;
    }

    @Override
    public CredentialOfferStorage.CredentialOfferState findOfferStateByCode(KeycloakSession session, String code) {
        if (session.singleUseObjects().contains(code)) {
            String entryJson = (String)session.singleUseObjects().get(code).get(ENTRY_KEY);
            return (CredentialOfferStorage.CredentialOfferState)JsonSerialization.valueFromString((String)entryJson, CredentialOfferStorage.CredentialOfferState.class);
        }
        return null;
    }

    @Override
    public CredentialOfferStorage.CredentialOfferState findOfferStateByCredentialId(KeycloakSession session, String credId) {
        if (session.singleUseObjects().contains(credId)) {
            String entryJson = (String)session.singleUseObjects().get(credId).get(ENTRY_KEY);
            return (CredentialOfferStorage.CredentialOfferState)JsonSerialization.valueFromString((String)entryJson, CredentialOfferStorage.CredentialOfferState.class);
        }
        return null;
    }

    @Override
    public void replaceOfferState(KeycloakSession session, CredentialOfferStorage.CredentialOfferState entry) {
        String entryJson = JsonSerialization.valueAsString((Object)entry);
        session.singleUseObjects().replace(entry.getNonce(), Map.of(ENTRY_KEY, entryJson));
        entry.getPreAuthorizedCode().ifPresent(it -> session.singleUseObjects().replace(it, Map.of(ENTRY_KEY, entryJson)));
        Optional.ofNullable(entry.getAuthorizationDetails()).ifPresent(it -> it.getCredentialIdentifiers().forEach(cid -> {
            if (session.singleUseObjects().contains(cid)) {
                session.singleUseObjects().replace(cid, Map.of(ENTRY_KEY, entryJson));
            } else {
                session.singleUseObjects().put(cid, (long)entry.getExpiration(), Map.of(ENTRY_KEY, entryJson));
            }
        }));
    }

    @Override
    public void removeOfferState(KeycloakSession session, CredentialOfferStorage.CredentialOfferState entry) {
        session.singleUseObjects().remove(entry.getNonce());
        entry.getPreAuthorizedCode().ifPresent(it -> session.singleUseObjects().remove(it));
        Optional.ofNullable(entry.getAuthorizationDetails()).ifPresent(it -> it.getCredentialIdentifiers().forEach(cid -> session.singleUseObjects().remove(cid)));
    }
}

