/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MethodPredicate
implements Predicate {
    private final String[] methods;

    MethodPredicate(String[] methods) {
        String[] values = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            values[i] = methods[i];
        }
        this.methods = values;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!value.getRequestMethod().equals(this.methods[i])) continue;
            return true;
        }
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "method";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] methods = (String[])config.get("value");
            return new MethodPredicate(methods);
        }
    }
}

