/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelAuthenticationRequestContext;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.request.BackchannelAuthenticationEndpointRequest;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureCibaSignedAuthenticationRequestExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureCibaSignedAuthenticationRequestExecutor.class);
    public static final String INVALID_REQUEST_OBJECT = "invalid_request_object";
    public static final Integer DEFAULT_AVAILABLE_PERIOD = 3600;
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureCibaSignedAuthenticationRequestExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        if (config == null) {
            this.configuration = new Configuration();
            this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
        } else {
            this.configuration = config;
            if (config.getAvailablePeriod() == null) {
                this.configuration.setAvailablePeriod(DEFAULT_AVAILABLE_PERIOD);
            }
        }
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-ciba-signed-authn-req";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case BACKCHANNEL_AUTHENTICATION_REQUEST: {
                BackchannelAuthenticationRequestContext backchannelAuthenticationRequestContext = (BackchannelAuthenticationRequestContext)context;
                this.executeOnBackchannelAuthenticationRequest(backchannelAuthenticationRequestContext.getRequest(), backchannelAuthenticationRequestContext.getRequestParameters());
                return;
            }
        }
    }

    private void executeOnBackchannelAuthenticationRequest(BackchannelAuthenticationEndpointRequest request, MultivaluedMap<String, String> params) throws ClientPolicyException {
        logger.trace((Object)"Backchannel Authentication Endpoint - authn request");
        if (params == null) {
            logger.trace((Object)"request parameter not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameters");
        }
        String requestParam = (String)params.getFirst((Object)"request");
        String requestUriParam = (String)params.getFirst((Object)"request_uri");
        if (requestParam == null && requestUriParam == null) {
            logger.trace((Object)"signed authentication request not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameter: 'request' or 'request_uri'");
        }
        JsonNode signedAuthReq = (JsonNode)this.session.getAttribute("ParsedSignedAuthenticationRequest");
        if (signedAuthReq == null || signedAuthReq.isEmpty()) {
            logger.trace((Object)"signed authentication request not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter: : 'request' or 'request_uri'");
        }
        if (signedAuthReq.get("exp") == null) {
            logger.trace((Object)"exp claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the signed authentication request: exp");
        }
        long exp = signedAuthReq.get("exp").asLong();
        if ((long)Time.currentTime() > exp) {
            logger.trace((Object)"request object expired.");
            throw new ClientPolicyException("invalid_request", "Request Expired");
        }
        if (signedAuthReq.get("nbf") == null) {
            logger.trace((Object)"nbf claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the signed authentication request: nbf");
        }
        long nbf = signedAuthReq.get("nbf").asLong();
        if ((long)Time.currentTime() < nbf) {
            logger.trace((Object)"request object not yet being processed.");
            throw new ClientPolicyException("invalid_request", "Request not yet being processed");
        }
        int availablePeriod = Optional.ofNullable(this.configuration.getAvailablePeriod()).orElse(DEFAULT_AVAILABLE_PERIOD);
        if (exp - nbf > (long)availablePeriod) {
            logger.trace((Object)"signed authentication request's available period is long.");
            throw new ClientPolicyException("invalid_request", "signed authentication request's available period is long");
        }
        ArrayList<String> aud = new ArrayList<String>();
        JsonNode audience = signedAuthReq.get("aud");
        if (audience == null) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the 'request' object: aud");
        }
        if (audience.isArray()) {
            for (JsonNode node : audience) {
                aud.add(node.asText());
            }
        } else {
            aud.add(audience.asText());
        }
        if (aud.isEmpty()) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter value in the 'request' object: aud");
        }
        String authzServerIss = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName());
        if (!aud.contains(authzServerIss)) {
            logger.trace((Object)"aud not points to the intended realm.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter in the 'request' object: aud");
        }
        if (signedAuthReq.get("iss") == null) {
            logger.trace((Object)"iss claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the 'request' object: iss");
        }
        ClientModel client = this.session.getContext().getClient();
        String iss = signedAuthReq.get("iss").asText();
        if (!iss.equals(client.getClientId())) {
            logger.trace((Object)"iss claim not match client's identity.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter in the 'request' object: iss");
        }
        if (signedAuthReq.get("iat") == null) {
            logger.trace((Object)"iat claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the signed authentication request: iat");
        }
        if (signedAuthReq.get("jti") == null) {
            logger.trace((Object)"jti claim not incuded.");
            throw new ClientPolicyException("invalid_request", "Missing parameter in the signed authentication request: jti");
        }
        logger.trace((Object)"Passed.");
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="available-period")
        protected Integer availablePeriod;

        public Integer getAvailablePeriod() {
            return this.availablePeriod;
        }

        public void setAvailablePeriod(Integer availablePeriod) {
            this.availablePeriod = availablePeriod;
        }
    }
}

