/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class StaticResourcesBuildItem
extends SimpleBuildItem {
    private final Set<Entry> entries;

    public StaticResourcesBuildItem(Set<Entry> entries) {
        this.entries = entries;
    }

    public Set<Entry> getEntries() {
        return this.entries;
    }

    public Set<String> getPaths() {
        HashSet<String> paths = new HashSet<String>(this.entries.size());
        for (Entry entry : this.entries) {
            paths.add(entry.getPath());
        }
        return paths;
    }

    public static class Entry {
        private final String path;
        private final boolean isDirectory;

        public Entry(String path, boolean isDirectory) {
            this.path = path;
            this.isDirectory = isDirectory;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.isDirectory == entry.isDirectory && this.path.equals(entry.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.isDirectory);
        }
    }
}

