/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.access.exception.ObjectNotFoundException;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICache;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.control.event.ElementEvent;
import org.apache.commons.jcs3.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs3.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs3.engine.memory.shrinking.ShrinkerThread;
import org.apache.commons.jcs3.engine.stats.CacheStats;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class CompositeCache<K, V>
implements ICache<K, V>,
IRequireScheduler {
    private static final Log log = LogManager.getLog(CompositeCache.class);
    private IElementEventQueue elementEventQ;
    private CopyOnWriteArrayList<AuxiliaryCache<K, V>> auxCaches = new CopyOnWriteArrayList();
    private final AtomicBoolean alive;
    private IElementAttributes attr;
    private ICompositeCacheAttributes cacheAttr;
    private final AtomicLong updateCount;
    private final AtomicLong removeCount;
    private final AtomicLong hitCountRam;
    private final AtomicLong hitCountAux;
    private final AtomicLong missCountNotFound;
    private final AtomicLong missCountExpired;
    private CompositeCacheManager cacheManager;
    private IMemoryCache<K, V> memCache;
    private IKeyMatcher<K> keyMatcher = new KeyMatcherPatternImpl();
    private ScheduledFuture<?> future;

    public CompositeCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        this.attr = attr;
        this.cacheAttr = cattr;
        this.alive = new AtomicBoolean(true);
        this.updateCount = new AtomicLong();
        this.removeCount = new AtomicLong();
        this.hitCountRam = new AtomicLong();
        this.hitCountAux = new AtomicLong();
        this.missCountNotFound = new AtomicLong();
        this.missCountExpired = new AtomicLong();
        this.createMemoryCache(cattr);
        log.info("Constructed cache with name [{0}] and cache attributes {1}", this.cacheAttr.getCacheName(), cattr);
    }

    public void setElementEventQueue(IElementEventQueue queue) {
        this.elementEventQ = queue;
    }

    public void setCompositeCacheManager(CompositeCacheManager manager) {
        this.cacheManager = manager;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutor) {
        if (this.cacheAttr.isUseMemoryShrinker()) {
            this.future = scheduledExecutor.scheduleAtFixedRate(new ShrinkerThread(this), 0L, this.cacheAttr.getShrinkerIntervalSeconds(), TimeUnit.SECONDS);
        }
        if (this.memCache instanceof IRequireScheduler) {
            ((IRequireScheduler)((Object)this.memCache)).setScheduledExecutorService(scheduledExecutor);
        }
    }

    public void setAuxCaches(List<AuxiliaryCache<K, V>> auxCaches) {
        this.auxCaches = auxCaches.stream().filter(Objects::nonNull).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    @Deprecated
    public void setAuxCaches(AuxiliaryCache<K, V>[] auxCaches) {
        this.setAuxCaches(Arrays.asList(auxCaches));
    }

    public List<AuxiliaryCache<K, V>> getAuxCacheList() {
        return this.auxCaches;
    }

    @Deprecated
    public AuxiliaryCache<K, V>[] getAuxCaches() {
        return this.getAuxCacheList().toArray(new AuxiliaryCache[0]);
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, false);
    }

    public void localUpdate(ICacheElement<K, V> ce) throws IOException {
        this.update(ce, true);
    }

    protected void update(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (cacheElement.getKey() instanceof String && cacheElement.getKey().toString().endsWith(":")) {
            throw new IllegalArgumentException("key must not end with : for a put operation");
        }
        if (cacheElement.getKey() instanceof GroupId) {
            throw new IllegalArgumentException("key cannot be a GroupId  for a put operation");
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = cacheElement::getKey;
        log.debug("Updating memory cache {0}", supplierArray);
        this.updateCount.incrementAndGet();
        this.memCache.update(cacheElement);
        this.updateAuxiliaries(cacheElement, localOnly);
        cacheElement.getElementAttributes().setLastAccessTimeNow();
    }

    protected void updateAuxiliaries(ICacheElement<K, V> cacheElement, boolean localOnly) throws IOException {
        if (!this.auxCaches.isEmpty()) {
            log.debug("Updating auxiliary caches");
        } else {
            log.debug("No auxiliary cache to update");
        }
        for (ICache iCache : this.auxCaches) {
            if (iCache == null) continue;
            log.debug("Auxiliary cache type: {0}", new Object[]{iCache.getCacheType()});
            switch (iCache.getCacheType()) {
                case REMOTE_CACHE: {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = cacheElement.getElementAttributes()::getIsRemote;
                    log.debug("ce.getElementAttributes().getIsRemote() = {0}", supplierArray);
                    if (!cacheElement.getElementAttributes().getIsRemote() || localOnly) break;
                    try {
                        iCache.update(cacheElement);
                        log.debug("Updated remote store for {0} {1}", cacheElement.getKey(), cacheElement);
                    }
                    catch (IOException ex) {
                        log.error("Failure in updateExclude", ex);
                    }
                    break;
                }
                case LATERAL_CACHE: {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = this.cacheAttr::isUseLateral;
                    log.debug("lateralcache in aux list: cattr {0}", supplierArray);
                    if (!this.cacheAttr.isUseLateral() || !cacheElement.getElementAttributes().getIsLateral() || localOnly) break;
                    iCache.update(cacheElement);
                    Supplier[] supplierArray2 = new Supplier[1];
                    supplierArray2[0] = cacheElement::getKey;
                    log.debug("updated lateral cache for {0}", supplierArray2);
                    break;
                }
                case DISK_CACHE: {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = this.cacheAttr::isUseDisk;
                    log.debug("diskcache in aux list: cattr {0}", supplierArray);
                    if (!this.cacheAttr.isUseDisk() || this.cacheAttr.getDiskUsagePattern() != ICompositeCacheAttributes.DiskUsagePattern.UPDATE || !cacheElement.getElementAttributes().getIsSpool()) break;
                    iCache.update(cacheElement);
                    Supplier[] supplierArray3 = new Supplier[1];
                    supplierArray3[0] = cacheElement::getKey;
                    log.debug("updated disk cache for {0}", supplierArray3);
                    break;
                }
            }
        }
    }

    public void spoolToDisk(ICacheElement<K, V> ce) {
        if (!ce.getElementAttributes().getIsSpool()) {
            this.handleElementEvent(ce, ElementEventType.SPOOLED_NOT_ALLOWED);
            return;
        }
        boolean diskAvailable = false;
        for (ICache iCache : this.auxCaches) {
            if (iCache.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            diskAvailable = true;
            if (this.cacheAttr.getDiskUsagePattern() == ICompositeCacheAttributes.DiskUsagePattern.SWAP) {
                try {
                    this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_AVAILABLE);
                    iCache.update(ce);
                }
                catch (IOException ex) {
                    log.error("Problem spooling item to disk cache.", ex);
                    throw new IllegalStateException(ex.getMessage());
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = ce::getKey;
                supplierArray[1] = iCache::getCacheName;
                log.debug("spoolToDisk done for: {0} on disk cache[{1}]", supplierArray);
                continue;
            }
            log.debug("DiskCache available, but JCS is not configured to use the DiskCache as a swap.");
        }
        if (!diskAvailable) {
            this.handleElementEvent(ce, ElementEventType.SPOOLED_DISK_NOT_AVAILABLE);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        return this.get(key, false);
    }

    public ICacheElement<K, V> localGet(K key) {
        return this.get(key, true);
    }

    protected ICacheElement<K, V> get(K key, boolean localOnly) {
        boolean found;
        ICacheElement<K, V> element;
        block13: {
            element = null;
            found = false;
            log.debug("get: key = {0}, localOnly = {1}", key, localOnly);
            try {
                element = this.memCache.get(key);
                if (element != null) {
                    if (this.isExpired(element)) {
                        log.debug("{0} - Memory cache hit, but element expired", () -> this.cacheAttr.getCacheName());
                        this.doExpires(element);
                        element = null;
                    } else {
                        log.debug("{0} - Memory cache hit", () -> this.cacheAttr.getCacheName());
                        this.hitCountRam.incrementAndGet();
                    }
                    found = true;
                    break block13;
                }
                for (AuxiliaryCache<K, V> aux : this.auxCaches) {
                    ICacheType.CacheType cacheType = aux.getCacheType();
                    if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = aux::getCacheName;
                        supplierArray[1] = () -> cacheType;
                        log.debug("Attempting to get from aux [{0}] which is of type: {1}", supplierArray);
                        try {
                            element = aux.get(key);
                        }
                        catch (IOException e) {
                            log.error("Error getting from aux", e);
                        }
                    }
                    log.debug("Got CacheElement: {0}", element);
                    if (element == null) continue;
                    if (this.isExpired(element)) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = () -> this.cacheAttr.getCacheName();
                        supplierArray[1] = aux::getCacheName;
                        log.debug("{0} - Aux cache[{1}] hit, but element expired.", supplierArray);
                        this.doExpires(element);
                        element = null;
                    } else {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = () -> this.cacheAttr.getCacheName();
                        supplierArray[1] = aux::getCacheName;
                        log.debug("{0} - Aux cache[{1}] hit.", supplierArray);
                        this.hitCountAux.incrementAndGet();
                        this.copyAuxiliaryRetrievedItemToMemory(element);
                    }
                    found = true;
                    break;
                }
            }
            catch (IOException e) {
                log.error("Problem encountered getting element.", e);
            }
        }
        if (!found) {
            this.missCountNotFound.incrementAndGet();
            log.debug("{0} - Miss", () -> this.cacheAttr.getCacheName());
        }
        if (element != null) {
            element.getElementAttributes().setLastAccessTimeNow();
        }
        return element;
    }

    protected void doExpires(ICacheElement<K, V> element) {
        this.missCountExpired.incrementAndGet();
        this.remove(element.getKey());
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        return this.getMultiple(keys, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMultiple(Set<K> keys) {
        return this.getMultiple(keys, true);
    }

    protected Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys, boolean localOnly) {
        HashMap elements = new HashMap();
        log.debug("get: key = {0}, localOnly = {1}", keys, localOnly);
        try {
            elements.putAll(this.getMultipleFromMemory(keys));
            if (elements.size() != keys.size()) {
                Set<K> remainingKeys = this.pruneKeysFound(keys, elements);
                elements.putAll(this.getMultipleFromAuxiliaryCaches(remainingKeys, localOnly));
            }
        }
        catch (IOException e) {
            log.error("Problem encountered getting elements.", e);
        }
        if (elements.size() != keys.size()) {
            this.missCountNotFound.addAndGet(keys.size() - elements.size());
            log.debug("{0} - {1} Misses", () -> this.cacheAttr.getCacheName(), () -> keys.size() - elements.size());
        }
        return elements;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromMemory(Set<K> keys) throws IOException {
        Map<K, ICacheElement<K, V>> elementsFromMemory = this.memCache.getMultiple(keys);
        elementsFromMemory.entrySet().removeIf(entry -> {
            ICacheElement element = (ICacheElement)entry.getValue();
            if (this.isExpired(element)) {
                log.debug("{0} - Memory cache hit, but element expired", () -> this.cacheAttr.getCacheName());
                this.doExpires(element);
                return true;
            }
            log.debug("{0} - Memory cache hit", () -> this.cacheAttr.getCacheName());
            this.hitCountRam.incrementAndGet();
            return false;
        });
        return elementsFromMemory;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromAuxiliaryCaches(Set<K> keys, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        Set<K> remainingKeys = new HashSet<K>(keys);
        for (AuxiliaryCache<K, V> aux : this.auxCaches) {
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (!localOnly || cacheType == ICacheType.CacheType.DISK_CACHE) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = aux::getCacheName;
                supplierArray[1] = () -> cacheType;
                log.debug("Attempting to get from aux [{0}] which is of type: {1}", supplierArray);
                try {
                    elementsFromAuxiliary.putAll(aux.getMultiple(remainingKeys));
                }
                catch (IOException e) {
                    log.error("Error getting from aux", e);
                }
            }
            log.debug("Got CacheElements: {0}", elementsFromAuxiliary);
            this.processRetrievedElements(aux, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
            if (elements.size() == keys.size()) break;
            remainingKeys = this.pruneKeysFound(keys, elements);
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        return this.getMatching(pattern, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMatching(String pattern) {
        return this.getMatching(pattern, true);
    }

    protected Map<K, ICacheElement<K, V>> getMatching(String pattern, boolean localOnly) {
        log.debug("get: pattern [{0}], localOnly = {1}", pattern, localOnly);
        try {
            return Stream.concat(this.getMatchingFromMemory(pattern).entrySet().stream(), this.getMatchingFromAuxiliaryCaches(pattern, localOnly).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (mem, aux) -> mem));
        }
        catch (IOException e) {
            log.error("Problem encountered getting elements.", e);
            return new HashMap();
        }
    }

    protected Map<K, ICacheElement<K, V>> getMatchingFromMemory(String pattern) throws IOException {
        Set<K> keyArray = this.memCache.getKeySet();
        Set<K> matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        return this.getMultipleFromMemory(matchingKeys);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromAuxiliaryCaches(String pattern, boolean localOnly) throws IOException {
        HashMap elements = new HashMap();
        ListIterator<AuxiliaryCache<K, V>> i = this.auxCaches.listIterator(this.auxCaches.size());
        while (i.hasPrevious()) {
            AuxiliaryCache<K, V> aux = i.previous();
            HashMap elementsFromAuxiliary = new HashMap();
            ICacheType.CacheType cacheType = aux.getCacheType();
            if (localOnly && cacheType != ICacheType.CacheType.DISK_CACHE) continue;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = aux::getCacheName;
            supplierArray[1] = () -> cacheType;
            log.debug("Attempting to get from aux [{0}] which is of type: {1}", supplierArray);
            try {
                elementsFromAuxiliary.putAll(aux.getMatching(pattern));
            }
            catch (IOException e) {
                log.error("Error getting from aux", e);
            }
            log.debug("Got CacheElements: {0}", elementsFromAuxiliary);
            this.processRetrievedElements(aux, elementsFromAuxiliary);
            elements.putAll(elementsFromAuxiliary);
        }
        return elements;
    }

    private void processRetrievedElements(AuxiliaryCache<K, V> aux, Map<K, ICacheElement<K, V>> elementsFromAuxiliary) throws IOException {
        elementsFromAuxiliary.entrySet().removeIf(entry -> {
            ICacheElement element = (ICacheElement)entry.getValue();
            if (element != null) {
                if (this.isExpired(element)) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> this.cacheAttr.getCacheName();
                    supplierArray[1] = aux::getCacheName;
                    log.debug("{0} - Aux cache[{1}] hit, but element expired.", supplierArray);
                    this.doExpires(element);
                    return true;
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> this.cacheAttr.getCacheName();
                supplierArray[1] = aux::getCacheName;
                log.debug("{0} - Aux cache[{1}] hit.", supplierArray);
                this.hitCountAux.incrementAndGet();
                try {
                    this.copyAuxiliaryRetrievedItemToMemory(element);
                }
                catch (IOException e) {
                    log.error("{0} failed to copy element to memory {1}", this.cacheAttr.getCacheName(), element, e);
                }
            }
            return false;
        });
    }

    private void copyAuxiliaryRetrievedItemToMemory(ICacheElement<K, V> element) throws IOException {
        if (this.memCache.getCacheAttributes().getMaxObjects() > 0) {
            this.memCache.update(element);
        } else {
            log.debug("Skipping memory update since no items are allowed in memory");
        }
    }

    private Set<K> pruneKeysFound(Set<K> keys, Map<K, ICacheElement<K, V>> foundElements) {
        HashSet<K> remainingKeys = new HashSet<K>(keys);
        remainingKeys.removeAll(foundElements.keySet());
        return remainingKeys;
    }

    public Set<K> getKeySet() {
        return this.getKeySet(false);
    }

    public Set<K> getKeySet(boolean localOnly) {
        return Stream.concat(this.memCache.getKeySet().stream(), this.auxCaches.stream().filter(aux -> !localOnly || aux.getCacheType() == ICacheType.CacheType.DISK_CACHE).flatMap(aux -> {
            try {
                return aux.getKeySet().stream();
            }
            catch (IOException e) {
                return Stream.of(new Object[0]);
            }
        })).collect(Collectors.toSet());
    }

    @Override
    public boolean remove(K key) {
        return this.remove(key, false);
    }

    public boolean localRemove(K key) {
        return this.remove(key, true);
    }

    protected boolean remove(K key, boolean localOnly) {
        this.removeCount.incrementAndGet();
        boolean removed = false;
        try {
            removed = this.memCache.remove(key);
        }
        catch (IOException e) {
            log.error(e);
        }
        for (ICache iCache : this.auxCaches) {
            if (iCache == null) continue;
            ICacheType.CacheType cacheType = iCache.getCacheType();
            if (localOnly && (cacheType == ICacheType.CacheType.REMOTE_CACHE || cacheType == ICacheType.CacheType.LATERAL_CACHE)) continue;
            try {
                log.debug("Removing {0} from cacheType {1}", new Object[]{key, cacheType});
                boolean b = iCache.remove(key);
                if (removed || cacheType == ICacheType.CacheType.REMOTE_CACHE) continue;
                removed = b;
            }
            catch (IOException ex) {
                log.error("Failure removing from aux", ex);
            }
        }
        return removed;
    }

    @Override
    public void removeAll() throws IOException {
        this.removeAll(false);
    }

    public void localRemoveAll() throws IOException {
        this.removeAll(true);
    }

    protected void removeAll(boolean localOnly) throws IOException {
        try {
            this.memCache.removeAll();
            log.debug("Removed All keys from the memory cache.");
        }
        catch (IOException ex) {
            log.error("Trouble updating memory cache.", ex);
        }
        this.auxCaches.stream().filter(aux -> aux.getCacheType() == ICacheType.CacheType.DISK_CACHE || !localOnly).forEach(aux -> {
            try {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = aux::getCacheType;
                log.debug("Removing All keys from cacheType {0}", supplierArray);
                aux.removeAll();
            }
            catch (IOException ex) {
                log.error("Failure removing all from aux " + aux, ex);
            }
        });
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean fromRemote) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = this.cacheAttr::getCacheName;
        supplierArray[1] = () -> fromRemote;
        log.info("In DISPOSE, [{0}] fromRemote [{1}]", supplierArray);
        if (this.cacheManager != null) {
            this.cacheManager.freeCache(this.getCacheName(), fromRemote);
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.elementEventQ != null) {
            this.elementEventQ.dispose();
            this.elementEventQ = null;
        }
        for (ICache iCache : this.auxCaches) {
            try {
                if (iCache == null || iCache.getStatus() != CacheStatus.ALIVE || fromRemote && iCache.getCacheType() == ICacheType.CacheType.REMOTE_CACHE) {
                    Supplier[] supplierArray2 = new Supplier[3];
                    supplierArray2[0] = this.cacheAttr::getCacheName;
                    supplierArray2[1] = () -> aux == null ? "null" : aux.getCacheName();
                    supplierArray2[2] = () -> fromRemote;
                    log.info("In DISPOSE, [{0}] SKIPPING auxiliary [{1}] fromRemote [{2}]", supplierArray2);
                    continue;
                }
                Supplier[] supplierArray3 = new Supplier[2];
                supplierArray3[0] = this.cacheAttr::getCacheName;
                supplierArray3[1] = iCache::getCacheName;
                log.info("In DISPOSE, [{0}] auxiliary [{1}]", supplierArray3);
                if (iCache.getCacheType() == ICacheType.CacheType.DISK_CACHE) {
                    int numToFree = this.memCache.getSize();
                    this.memCache.freeElements(numToFree);
                    Supplier[] supplierArray4 = new Supplier[3];
                    supplierArray4[0] = this.cacheAttr::getCacheName;
                    supplierArray4[1] = () -> numToFree;
                    supplierArray4[2] = iCache::getCacheName;
                    log.info("In DISPOSE, [{0}] put {1} into auxiliary [{2}]", supplierArray4);
                }
                iCache.dispose();
            }
            catch (IOException ex) {
                log.error("Failure disposing of aux.", ex);
            }
        }
        Supplier[] supplierArray5 = new Supplier[1];
        supplierArray5[0] = this.cacheAttr::getCacheName;
        log.info("In DISPOSE, [{0}] disposing of memory cache.", supplierArray5);
        try {
            this.memCache.dispose();
        }
        catch (IOException ex) {
            log.error("Failure disposing of memCache", ex);
        }
    }

    public void save() {
        if (!this.alive.get()) {
            return;
        }
        this.auxCaches.stream().filter(aux -> aux.getStatus() == CacheStatus.ALIVE).forEach(aux -> this.memCache.getKeySet().stream().map(this::localGet).filter(Objects::nonNull).forEach(ce -> {
            try {
                aux.update(ce);
            }
            catch (IOException e) {
                log.warn("Failure saving element {0} to aux {1}.", ce, aux, e);
            }
        }));
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.cacheAttr::getCacheName;
        log.debug("Called save for [{0}]", supplierArray);
    }

    @Override
    public int getSize() {
        return this.memCache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    @Override
    public CacheStatus getStatus() {
        return this.alive.get() ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    public ICacheStats getStatistics() {
        CacheStats stats = new CacheStats();
        stats.setRegionName(this.getCacheName());
        stats.setStatElements(Arrays.asList(new StatElement<Long>("HitCountRam", this.getHitCountRam()), new StatElement<Long>("HitCountAux", this.getHitCountAux())));
        ArrayList<IStats> auxStats = new ArrayList<IStats>(this.auxCaches.size() + 1);
        auxStats.add(this.getMemoryCache().getStatistics());
        auxStats.addAll(this.auxCaches.stream().map(AuxiliaryCache::getStatistics).collect(Collectors.toList()));
        stats.setAuxiliaryCacheStats(auxStats);
        return stats;
    }

    @Override
    public String getCacheName() {
        return this.cacheAttr.getCacheName();
    }

    public IElementAttributes getElementAttributes() {
        if (this.attr != null) {
            return this.attr.clone();
        }
        return null;
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttr = cattr;
        this.memCache.initialize(this);
    }

    public IElementAttributes getElementAttributes(K key) throws CacheException, IOException {
        ICacheElement<K, V> ce = this.get(key);
        if (ce == null) {
            throw new ObjectNotFoundException("key " + key + " is not found");
        }
        return ce.getElementAttributes();
    }

    public boolean isExpired(ICacheElement<K, V> element) {
        return this.isExpired(element, System.currentTimeMillis(), ElementEventType.EXCEEDED_MAXLIFE_ONREQUEST, ElementEventType.EXCEEDED_IDLETIME_ONREQUEST);
    }

    public boolean isExpired(ICacheElement<K, V> element, long timestamp, ElementEventType eventMaxlife, ElementEventType eventIdle) {
        try {
            IElementAttributes attributes = element.getElementAttributes();
            if (!attributes.getIsEternal()) {
                long maxLifeSeconds = attributes.getMaxLife();
                long createTime = attributes.getCreateTime();
                long timeFactorForMilliseconds = attributes.getTimeFactorForMilliseconds();
                if (maxLifeSeconds != -1L && timestamp - createTime > maxLifeSeconds * timeFactorForMilliseconds) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = element::getKey;
                    log.debug("Exceeded maxLife: {0}", supplierArray);
                    this.handleElementEvent(element, eventMaxlife);
                    return true;
                }
                long idleTime = attributes.getIdleTime();
                long lastAccessTime = attributes.getLastAccessTime();
                if (idleTime != -1L && timestamp - lastAccessTime > idleTime * timeFactorForMilliseconds) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = element::getKey;
                    log.debug("Exceeded maxIdle: {0}", supplierArray);
                    this.handleElementEvent(element, eventIdle);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("Error determining expiration period, expiring", e);
            return true;
        }
        return false;
    }

    public void handleElementEvent(ICacheElement<K, V> element, ElementEventType eventType) {
        ArrayList<IElementEventHandler> eventHandlers = element.getElementAttributes().getElementEventHandlers();
        if (eventHandlers != null) {
            log.debug("Element Handlers are registered.  Create event type {0}", new Object[]{eventType});
            if (this.elementEventQ == null) {
                log.warn("No element event queue available for cache {0}", this::getCacheName);
                return;
            }
            ElementEvent<ICacheElement<K, V>> event = new ElementEvent<ICacheElement<K, V>>(element, eventType);
            for (IElementEventHandler hand : eventHandlers) {
                try {
                    this.elementEventQ.addElementEvent(hand, event);
                }
                catch (IOException e) {
                    log.error("Trouble adding element event to queue", e);
                }
            }
        }
    }

    private void createMemoryCache(ICompositeCacheAttributes cattr) {
        if (this.memCache == null) {
            try {
                IMemoryCache newInstance;
                Class<?> c = Class.forName(cattr.getMemoryCacheName());
                this.memCache = newInstance = (IMemoryCache)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.memCache.initialize(this);
            }
            catch (Exception e) {
                log.warn("Failed to init mem cache, using: LRUMemoryCache", e);
                this.memCache = new LRUMemoryCache();
                this.memCache.initialize(this);
            }
        } else {
            log.warn("Refusing to create memory cache -- already exists.");
        }
    }

    public IMemoryCache<K, V> getMemoryCache() {
        return this.memCache;
    }

    public long getHitCountRam() {
        return this.hitCountRam.get();
    }

    public long getHitCountAux() {
        return this.hitCountAux.get();
    }

    public long getMissCountNotFound() {
        return this.missCountNotFound.get();
    }

    public long getMissCountExpired() {
        return this.missCountExpired.get();
    }

    public long getUpdateCount() {
        return this.updateCount.get();
    }

    @Override
    public void setKeyMatcher(IKeyMatcher<K> keyMatcher) {
        if (keyMatcher != null) {
            this.keyMatcher = keyMatcher;
        }
    }

    public IKeyMatcher<K> getKeyMatcher() {
        return this.keyMatcher;
    }

    public String toString() {
        return this.getStats();
    }
}

