/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameDispatcherHandler;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler;", "<init>", "()V", "createRenamer", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "element", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "RenamerImpl", "kotlin.refactorings.common"})
public class KotlinVariableInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiNameIdentifierOwner currentElementToRename = (PsiNameIdentifierOwner)elementToRename;
        Object object = currentElementToRename.getNameIdentifier();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object currentName = object;
        return new RenamerImpl((PsiNamedElement)currentElementToRename, editor, (String)currentName, (String)currentName);
    }

    public boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return editor.getSettings().isVariableInplaceRenameEnabled() && element != null && Companion.isInplaceRenameAvailable(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler$Companion;", "", "<init>", "()V", "isInplaceRenameAvailable", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.refactorings.common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInplaceRenameAvailable(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            return psiElement instanceof KtDestructuringDeclarationEntry ? true : (psiElement instanceof KtParameter ? ((KtParameter)element).isLoopParameter() || ((KtParameter)element).isCatchParameter() || ((KtParameter)element).isLambdaParameter() : psiElement instanceof KtLabeledExpression || psiElement instanceof KtImportAlias);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0014\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J \u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\tH\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler$RenamerImpl;", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/openapi/editor/Editor;)V", "currentName", "", "oldName", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;)V", "acceptReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "startsOnTheSameElement", "handler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "element", "Lcom/intellij/psi/PsiElement;", "createInplaceRenamerToRestart", "variable", "initialName", "kotlin.refactorings.common"})
    protected static class RenamerImpl
    extends VariableInplaceRenamer {
        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(elementToRename, editor);
        }

        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull String currentName, @NotNull String oldName) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)currentName, (String)"currentName");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            super(elementToRename, editor, project, currentName, oldName);
        }

        protected boolean acceptReference(@NotNull PsiReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiElement psiElement = reference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            PsiElement refElement = psiElement;
            TextRange textRange = reference.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
            TextRange textRange2 = textRange;
            String string = refElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = textRange2.getStartOffset();
            int n2 = textRange2.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String referenceText = KotlinPsiModificationUtils.unquoteKotlinIdentifier(string3);
            return Intrinsics.areEqual((Object)referenceText, (Object)this.myElementToRename.getName());
        }

        protected boolean startsOnTheSameElement(@Nullable RefactoringActionHandler handler2, @Nullable PsiElement element) {
            return Intrinsics.areEqual((Object)this.getVariable(), (Object)element) && (handler2 instanceof VariableInplaceRenameHandler || handler2 instanceof KotlinRenameDispatcherHandler);
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(@NotNull PsiNamedElement variable, @NotNull Editor editor, @NotNull String initialName2) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)initialName2, (String)"initialName");
            String string = this.myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myOldName");
            return new RenamerImpl(variable, editor, initialName2, string);
        }
    }
}

