/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixesPsiBasedFactory;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixMpp;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixMppKt;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\t\f\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp;", "Lcom/intellij/modcommand/ModCommandAction;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "addModifierFix", "org/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp$addModifierFix$1", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp$addModifierFix$1;", "cancelFix", "org/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp$cancelFix$1", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp$cancelFix$1;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "Companion", "kotlin.fir.frontend-independent"})
public final class AddModifierFixMpp
implements ModCommandAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtModifierListOwner element;
    @NotNull
    private final KtModifierKeywordToken modifier;
    @NotNull
    private final addModifierFix.1 addModifierFix;
    @NotNull
    private final cancelFix.1 cancelFix;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addAbstractModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addAbstractToContainingClass;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addOpenToContainingClass;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addFinalToProperty;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addInnerModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addOverrideModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addDataModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addInlineToFunctionWithReified;

    public AddModifierFixMpp(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        this.element = element;
        this.modifier = modifier;
        KtModifierListOwner ktModifierListOwner = this.element;
        KtModifierKeywordToken ktModifierKeywordToken = this.modifier;
        this.addModifierFix = new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken){

            protected Presentation getPresentation(ActionContext context2, KtModifierListOwner element) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Presentation presentation = Presentation.of((String)KotlinBundle.message((String)"action.text.continue", (Object[])new Object[0]));
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
                return presentation;
            }

            /*
             * WARNING - void declaration
             */
            protected void invoke(ActionContext context2, KtModifierListOwner element, ModPsiUpdater updater2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                if (!(element instanceof KtDeclaration)) {
                    throw new IllegalArgumentException("KtDeclaration expected but " + Reflection.getOrCreateKotlinClass(element.getClass()) + " found");
                }
                KtDeclaration declaration = (KtDeclaration)PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiElement)element), (PsiFile)((KtDeclaration)element).getContainingFile().getOriginalFile());
                Intrinsics.checkNotNull((Object)declaration);
                Iterable $this$map$iv = ExpectActualUtils.INSTANCE.collectAllExpectAndActualDeclaration(declaration, true);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    KtDeclaration ktDeclaration = (KtDeclaration)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((KtDeclaration)updater2.getWritable((PsiElement)p0));
                }
                List elementsToMutate = (List)destination$iv$iv;
                for (KtDeclaration elementToMutate : elementsToMutate) {
                    Intrinsics.checkNotNull((Object)elementToMutate);
                    super.invoke(context2, (KtModifierListOwner)elementToMutate, updater2);
                }
            }
        };
        this.cancelFix = new ModCommandAction(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"action.text.cancel", (Object[])new Object[0]);
            }

            public Presentation getPresentation(ActionContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Presentation presentation = Presentation.of((String)this.getFamilyName());
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
                return presentation;
            }

            public ModCommand perform(ActionContext context2) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
        };
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.modifier.family", (Object[])new Object[0]);
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.addModifierFix.getPresentationImpl(this.element);
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context2) {
        ModCommand modCommand;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (AddModifierFix.Companion.getModifiersWithWarning().contains(this.modifier)) {
            Object[] objectArray = new ModCommandAction[]{this.addModifierFix, this.cancelFix};
            ModCommand modCommand2 = ModCommand.chooseAction((String)KotlinBundle.message((String)"fix.potentially.broken.inheritance.message", (Object[])new Object[0]), (List)CollectionsKt.listOf((Object[])objectArray));
            modCommand = modCommand2;
            Intrinsics.checkNotNullExpressionValue((Object)modCommand2, (String)"chooseAction(...)");
        } else if (AddModifierFixMppKt.isMultiplatformPersistent(this.modifier)) {
            ModCommand modCommand3 = this.addModifierFix.perform(context2);
            modCommand = modCommand3;
            Intrinsics.checkNotNullExpressionValue((Object)modCommand3, (String)"perform(...)");
        } else {
            throw new IllegalArgumentException("'" + this.modifier + "' is not multiplatform-persistent. Use 'org.jetbrains.kotlin.idea.quickfix.AddModifierFix' instead.");
        }
        return modCommand;
    }

    static {
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ABSTRACT_KEYWORD");
        addAbstractModifier = Companion.createFactory(ktModifierKeywordToken);
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"ABSTRACT_KEYWORD");
        addAbstractToContainingClass = Companion.createFactory(ktModifierKeywordToken2, KtClassOrObject.class);
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"OPEN_KEYWORD");
        addOpenToContainingClass = Companion.createFactory(ktModifierKeywordToken3, KtClassOrObject.class);
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"FINAL_KEYWORD");
        addFinalToProperty = Companion.createFactory(ktModifierKeywordToken4, KtProperty.class);
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken5, (String)"INNER_KEYWORD");
        addInnerModifier = Companion.createFactory(ktModifierKeywordToken5);
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken6, (String)"OVERRIDE_KEYWORD");
        addOverrideModifier = Companion.createFactory(ktModifierKeywordToken6);
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken7, (String)"DATA_KEYWORD");
        addDataModifier = Companion.createFactory(ktModifierKeywordToken7, KtClass.class);
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.INLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken8, (String)"INLINE_KEYWORD");
        addInlineToFunctionWithReified = Companion.createFactory(ktModifierKeywordToken8, KtNamedFunction.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFixMpp$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "Lcom/intellij/modcommand/ModCommandAction;", "<init>", "()V", "addAbstractModifier", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "getAddAbstractModifier", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "addAbstractToContainingClass", "getAddAbstractToContainingClass", "addOpenToContainingClass", "getAddOpenToContainingClass", "addFinalToProperty", "getAddFinalToProperty", "addInnerModifier", "getAddInnerModifier", "addOverrideModifier", "getAddOverrideModifier", "addDataModifier", "getAddDataModifier", "addInlineToFunctionWithReified", "getAddInlineToFunctionWithReified", "createModifierFix", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.fir.frontend-independent"})
    public static final class Companion
    implements AddModifierFix.Factory<ModCommandAction> {
        private Companion() {
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddAbstractModifier() {
            return addAbstractModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddAbstractToContainingClass() {
            return addAbstractToContainingClass;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddOpenToContainingClass() {
            return addOpenToContainingClass;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddFinalToProperty() {
            return addFinalToProperty;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddInnerModifier() {
            return addInnerModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddOverrideModifier() {
            return addOverrideModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddDataModifier() {
            return addDataModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddInlineToFunctionWithReified() {
            return addInlineToFunctionWithReified;
        }

        @Override
        @NotNull
        public ModCommandAction createModifierFix(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return AddModifierFix.Companion.getModifiersWithWarning().contains(modifier) || AddModifierFixMppKt.isMultiplatformPersistent(modifier) ? (ModCommandAction)new AddModifierFixMpp(element, modifier) : (ModCommandAction)new AddModifierFix(element, modifier);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

