/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.openapi.util.Key;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineScopeExtractorKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineScopeExtractor;", "", "getContextMethod", "Lcom/sun/jdi/Method;", "getMethod", "jobKey", "Lcom/sun/jdi/Value;", "<init>", "(Lcom/sun/jdi/Method;Lcom/sun/jdi/Method;Lcom/sun/jdi/Value;)V", "extractCoroutineScope", "Lcom/sun/jdi/ObjectReference;", "continuation", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "getCoroutineScopeByJobKey", "getCoroutineContext", "Companion", "intellij.kotlin.jvm.debugger.coroutines"})
public final class CoroutineScopeExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Method getContextMethod;
    @Nullable
    private final Method getMethod;
    @Nullable
    private final Value jobKey;
    @NotNull
    private static final Key<CoroutineScopeExtractor> KEY;

    public CoroutineScopeExtractor(@Nullable Method getContextMethod, @Nullable Method getMethod, @Nullable Value jobKey) {
        this.getContextMethod = getContextMethod;
        this.getMethod = getMethod;
        this.jobKey = jobKey;
    }

    @Nullable
    public final ObjectReference extractCoroutineScope(@NotNull ObjectReference continuation2, @NotNull EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)continuation2, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        try {
            ObjectReference objectReference = this.getCoroutineContext(continuation2, evaluationContext);
            if (objectReference == null) {
                return null;
            }
            ObjectReference coroutineContext = objectReference;
            ObjectReference objectReference2 = this.getCoroutineScopeByJobKey(coroutineContext, evaluationContext);
            if (objectReference2 == null) {
                return null;
            }
            ObjectReference coroutineScope = objectReference2;
            ReferenceType referenceType = coroutineScope.referenceType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"referenceType(...)");
            if (CoroutineUtilsKt.isCoroutineScope(referenceType)) {
                return coroutineScope;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final ObjectReference getCoroutineScopeByJobKey(ObjectReference $this$getCoroutineScopeByJobKey, EvaluationContext evaluationContext) {
        Value value = this.jobKey;
        if (value == null) {
            return null;
        }
        Value jobKey = value;
        Method method = this.getMethod;
        if (method == null) {
            return null;
        }
        Method getMethod = method;
        if (!DebuggerUtils.instanceOf((Type)$this$getCoroutineScopeByJobKey.type(), (String)"kotlin.coroutines.CoroutineContext")) {
            return null;
        }
        Value coroutineScope = evaluationContext.getDebugProcess().invokeMethod(evaluationContext, $this$getCoroutineScopeByJobKey, getMethod, CollectionsKt.listOf((Object)jobKey));
        return coroutineScope instanceof ObjectReference ? (ObjectReference)coroutineScope : null;
    }

    private final ObjectReference getCoroutineContext(ObjectReference $this$getCoroutineContext, EvaluationContext evaluationContext) {
        Method method = this.getContextMethod;
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        if (!DebuggerUtils.instanceOf((Type)$this$getCoroutineContext.type(), (String)"kotlin.coroutines.Continuation")) {
            return null;
        }
        Value coroutineContext = evaluationContext.getDebugProcess().invokeMethod(evaluationContext, $this$getCoroutineContext, getContextMethod, CollectionsKt.emptyList());
        return coroutineContext instanceof ObjectReference ? (ObjectReference)coroutineContext : null;
    }

    static {
        Key key = Key.create((String)"CoroutineScopeExtractor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineScopeExtractor$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineScopeExtractor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "create", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<CoroutineScopeExtractor> getKEY() {
            return KEY;
        }

        @NotNull
        public final CoroutineScopeExtractor create(@NotNull EvaluationContext evaluationContext) {
            Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
            try {
                Field jobKeyField;
                ReferenceType jobType = CoroutineScopeExtractorKt.access$findClass(evaluationContext, "kotlinx.coroutines.Job");
                Value jobKey = null;
                if (jobType != null && (jobKeyField = DebuggerUtils.findField((ReferenceType)jobType, (String)"Key")) != null) {
                    jobKey = jobType.getValue(jobKeyField);
                }
                ReferenceType continuationType = CoroutineScopeExtractorKt.access$findClass(evaluationContext, "kotlin.coroutines.Continuation");
                ReferenceType coroutineContextType = CoroutineScopeExtractorKt.access$findClass(evaluationContext, "kotlin.coroutines.CoroutineContext");
                Method getContextMethod = CoroutineScopeExtractorKt.access$findMethod(continuationType, "getContext", "()Lkotlin/coroutines/CoroutineContext;");
                Method getMethod = CoroutineScopeExtractorKt.access$findMethod(coroutineContextType, "get", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;");
                return new CoroutineScopeExtractor(getContextMethod, getMethod, jobKey);
            }
            catch (Exception exception) {
                return new CoroutineScopeExtractor(null, null, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

