/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.caches.KotlinShortNamesCache;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J.\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u000bJ$\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u000bH\u0002J\u001c\u0010\u001d\u001a\u00020\u00132\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/completion/AllClassesCompletion;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kotlinIndicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "", "includeTypeAliases", "includeJavaClassesNotToBeUsed", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lkotlin/jvm/functions/Function1;ZZ)V", "collect", "", "classifierDescriptorCollector", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "javaClassCollector", "Lcom/intellij/psi/PsiClass;", "collectClassesFromScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "collector", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "addAdaptedJavaCompletion", "isNotToBeUsed", "javaClass", "hasPreferableKotlinTypeAlias", "kotlin.completion.impl.k1"})
@SourceDebugExtension(value={"SMAP\nAllClassesCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllClassesCompletion.kt\norg/jetbrains/kotlin/idea/completion/AllClassesCompletion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n295#2,2:115\n*S KotlinDebug\n*F\n+ 1 AllClassesCompletion.kt\norg/jetbrains/kotlin/idea/completion/AllClassesCompletion\n*L\n77#1:115,2\n*E\n"})
public final class AllClassesCompletion {
    @NotNull
    private final CompletionParameters parameters;
    @NotNull
    private final KotlinIndicesHelper kotlinIndicesHelper;
    @NotNull
    private final PrefixMatcher prefixMatcher;
    @NotNull
    private final ResolutionFacade resolutionFacade;
    @NotNull
    private final Function1<ClassKind, Boolean> kindFilter;
    private final boolean includeTypeAliases;
    private final boolean includeJavaClassesNotToBeUsed;

    public AllClassesCompletion(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper kotlinIndicesHelper, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade, @NotNull Function1<? super ClassKind, Boolean> kindFilter, boolean includeTypeAliases, boolean includeJavaClassesNotToBeUsed) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)kotlinIndicesHelper, (String)"kotlinIndicesHelper");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter(kindFilter, (String)"kindFilter");
        this.parameters = parameters2;
        this.kotlinIndicesHelper = kotlinIndicesHelper;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade;
        this.kindFilter = kindFilter;
        this.includeTypeAliases = includeTypeAliases;
        this.includeJavaClassesNotToBeUsed = includeJavaClassesNotToBeUsed;
    }

    public final void collect(@NotNull Function1<? super ClassifierDescriptorWithTypeParameters, Unit> classifierDescriptorCollector, @NotNull Function1<? super PsiClass, Unit> javaClassCollector) {
        Intrinsics.checkNotNullParameter(classifierDescriptorCollector, (String)"classifierDescriptorCollector");
        Intrinsics.checkNotNullParameter(javaClassCollector, (String)"javaClassCollector");
        for (PackageViewDescriptor builtInPackage : this.resolutionFacade.getModuleDescriptor().getBuiltIns().getBuiltInPackagesImportedByDefault()) {
            this.collectClassesFromScope(builtInPackage.getMemberScope(), (Function1<? super ClassDescriptor, Unit>)((Function1)arg_0 -> AllClassesCompletion.collect$lambda$0(classifierDescriptorCollector, arg_0)));
        }
        KotlinIndicesHelper.processKotlinClasses$default(this.kotlinIndicesHelper, arg_0 -> AllClassesCompletion.collect$lambda$1(this, arg_0), null, this.kindFilter, classifierDescriptorCollector, 2, null);
        if (this.includeTypeAliases) {
            this.kotlinIndicesHelper.processTopLevelTypeAliases(CompletionUtilsKt.asStringNameFilter(this.prefixMatcher), classifierDescriptorCollector);
        }
        PsiFile psiFile = this.parameters.getOriginalFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        if (JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)((KtFile)psiFile)))) {
            this.addAdaptedJavaCompletion(javaClassCollector);
        }
    }

    private final void collectClassesFromScope(MemberScope scope, Function1<? super ClassDescriptor, Unit> collector2) {
        for (DeclarationDescriptor descriptor2 : MemberScopeKt.getDescriptorsFiltered$default((MemberScope)scope, (DescriptorKindFilter)DescriptorKindFilter.CLASSIFIERS, null, (int)2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassKind classKind = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)classKind, (String)"getKind(...)");
            if (((Boolean)this.kindFilter.invoke((Object)classKind)).booleanValue() && this.prefixMatcher.prefixMatches(((ClassDescriptor)descriptor2).getName().asString())) {
                collector2.invoke((Object)descriptor2);
            }
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"getUnsubstitutedInnerClassesScope(...)");
            this.collectClassesFromScope(memberScope2, collector2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addAdaptedJavaCompletion(Function1<? super PsiClass, Unit> collector2) {
        Object object;
        KotlinShortNamesCache shortNamesCache;
        Object object2;
        Object v0;
        block4: {
            Iterable $this$firstOrNull$iv = PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)this.parameters.getEditor().getProject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiShortNamesCache it = (PsiShortNamesCache)element$iv;
                boolean bl = false;
                if (!(it instanceof KotlinShortNamesCache)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((object2 = (shortNamesCache = (KotlinShortNamesCache)v0)) != null && (object2 = ((KotlinShortNamesCache)((Object)object2)).getDisableSearch()) != null) {
            ((ThreadLocal)object2).set(true);
        }
        try {
            AllClassesGetter.processJavaClasses((CompletionParameters)this.parameters, (PrefixMatcher)this.prefixMatcher, (boolean)true, arg_0 -> AllClassesCompletion.addAdaptedJavaCompletion$lambda$2(arg_0 -> AllClassesCompletion.addAdaptedJavaCompletion$lambda$1(this, collector2, arg_0), arg_0));
            object = shortNamesCache;
            if (object == null || (object = object.getDisableSearch()) == null) return;
        }
        catch (Throwable throwable) {
            Object object3 = shortNamesCache;
            if (object3 == null || (object3 = object3.getDisableSearch()) == null) throw throwable;
            ((ThreadLocal)object3).set(false);
            throw throwable;
        }
        ((ThreadLocal)object).set(false);
    }

    private final boolean isNotToBeUsed(PsiClass javaClass) {
        FqName fqName2;
        if (this.includeJavaClassesNotToBeUsed) {
            return false;
        }
        FqName fqName3 = fqName2 = JavaPsiUtils.getKotlinFqName((PsiElement)javaClass);
        return fqName3 != null ? FqNameUtils.isJavaClassNotToBeUsedInKotlin(fqName3) : false;
    }

    private final boolean hasPreferableKotlinTypeAlias(PsiClass javaClass) {
        FqName fqName2;
        if (this.includeJavaClassesNotToBeUsed) {
            return false;
        }
        FqName fqName3 = fqName2 = JavaPsiUtils.getKotlinFqName((PsiElement)javaClass);
        return fqName3 != null ? FqNameUtils.isJavaClassWithKotlinTypeAlias(fqName3) : false;
    }

    private static final Unit collect$lambda$0(Function1 $classifierDescriptorCollector, ClassDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getContainingDeclaration() instanceof ClassDescriptor) {
            $classifierDescriptorCollector.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean collect$lambda$1(AllClassesCompletion this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.prefixMatcher.prefixMatches(it);
    }

    private static final Unit addAdaptedJavaCompletion$lambda$1(AllClassesCompletion this$0, Function1 $collector, PsiClass psiClass) {
        PsiClass psiClass2 = psiClass;
        Intrinsics.checkNotNull((Object)psiClass2);
        if (!(psiClass2 instanceof KtLightClass)) {
            ClassKind kind2;
            if (PsiUtilsKt.isSyntheticKotlinClass(psiClass)) {
                return Unit.INSTANCE;
            }
            ClassKind classKind = psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : (psiClass.isInterface() ? ClassKind.INTERFACE : (kind2 = psiClass.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
            if (((Boolean)this$0.kindFilter.invoke((Object)kind2)).booleanValue() && !this$0.isNotToBeUsed(psiClass) && !this$0.hasPreferableKotlinTypeAlias(psiClass)) {
                $collector.invoke((Object)psiClass);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void addAdaptedJavaCompletion$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

