/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.RangeHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0016\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0002J\"\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0002J\u000e\u0010(\u001a\u00020\u0011*\u0004\u0018\u00010)H\u0002J\u000e\u0010*\u001a\u00020\u0011*\u0004\u0018\u00010+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/Transformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/RangeHeaderInfoBuilder;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchStdlibExtensionContainsCall", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "buildContainsComparison", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "headerInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "argument", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "computeComparisonClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "lowerType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "upperType", "argumentType", "leastCommonPrimitiveNumericType", "type1", "type2", "isPromotableToInt", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "isPromotableToUInt", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nRangeContainsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeContainsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/Transformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,444:1\n1761#2,3:445\n385#3,11:448\n379#4,13:459\n133#5,2:472\n*S KotlinDebug\n*F\n+ 1 RangeContainsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/Transformer\n*L\n86#1:445,3\n296#1:448,11\n343#1:459,13\n343#1:472,2\n*E\n"})
final class Transformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final RangeHeaderInfoBuilder headerInfoBuilder;

    public Transformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(container, "container");
        this.context = context2;
        this.container = container;
        this.headerInfoBuilder = new RangeHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)new Function0<IrSymbol>((Object)this){

            public final IrSymbol invoke() {
                return ((Transformer)this.receiver).getScopeOwnerSymbol();
            }
        });
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    private final boolean matchStdlibExtensionContainsCall(IrCall expression2) {
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        return IrUtilsKt.hasShape$default(callee, false, true, 0, 1, null, 21, null) && IrTypeUtilsKt.isSubtypeOfClass(callee.getParameters().get(0).getType(), this.context.getSymbols().getClosedRange()) && Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), new FqName("kotlin.ranges." + OperatorNameConventions.CONTAINS));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        boolean hasExtensionReceiver;
        IrStatementOrigin origin;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            origin = expression2.getOrigin();
            if (!Intrinsics.areEqual(origin, IrStatementOrigin.Companion.getIN()) && !Intrinsics.areEqual(origin, IrStatementOrigin.Companion.getNOT_IN())) {
                return super.visitCall(expression2);
            }
            if (Intrinsics.areEqual(origin, IrStatementOrigin.Companion.getNOT_IN()) && Intrinsics.areEqual(expression2.getSymbol(), this.context.getIrBuiltIns().getBooleanNotSymbol())) {
                return super.visitCall(expression2);
            }
            Iterable $this$any$iv = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                    bl = true;
                    break block9;
                }
                bl = hasExtensionReceiver = false;
            }
        }
        if (hasExtensionReceiver && !this.matchStdlibExtensionContainsCall(expression2)) {
            return super.visitCall(expression2);
        }
        IrExpression receiver = (IrExpression)expression2.getArguments().get(0);
        Object object = receiver;
        if (object == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, expression2)) == null) {
            return super.visitCall(expression2);
        }
        Object headerInfo = object;
        Object e2 = expression2.getArguments().get(1);
        Intrinsics.checkNotNull(e2);
        IrExpression argument = (IrExpression)e2;
        if (IrTypeUtilsKt.isNullable(argument.getType())) {
            return super.visitCall(expression2);
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrExpression irExpression = this.buildContainsComparison(builder, (HeaderInfo)headerInfo, argument, origin);
        if (irExpression == null) {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildContainsComparison(DeclarationIrBuilder $this$buildContainsComparison, HeaderInfo headerInfo, IrExpression argument, IrStatementOrigin origin) {
        IrExpression irExpression;
        Object object;
        Object lowerClause;
        Object $this$buildContainsComparison_u24lambda_u242;
        Object object2;
        IrFunctionAccessExpression $this$buildContainsComparison_u24lambda_u241_u240;
        IrSimpleFunction irSimpleFunction;
        Object it2;
        Object object3;
        Object $this$singleOrNull$iv;
        IrSimpleFunctionSymbol upperCompFun;
        IrSimpleFunctionSymbol lowerCompFun;
        boolean useLowerClauseOnLeftSide;
        IrExpression upperExpression;
        IrExpression lowerExpression;
        IrExpression argExpression;
        List additionalStatements;
        boolean useCompareTo;
        block39: {
            IrExpression tmpLowerExpression;
            IrVariable lowerVar;
            Pair pair;
            IrClass comparisonClass;
            IrClass irClass;
            IrExpression lower2 = null;
            IrExpression upper = null;
            boolean isUpperInclusive = false;
            boolean shouldUpperComeFirst = false;
            useCompareTo = false;
            boolean isNumericRange = false;
            additionalStatements = new ArrayList();
            HeaderInfo headerInfo2 = headerInfo;
            if (headerInfo2 instanceof NumericHeaderInfo) {
                NumericHeaderInfo numericHeaderInfo = (NumericHeaderInfo)headerInfo;
                if (!(numericHeaderInfo instanceof ProgressionHeaderInfo)) {
                    if (numericHeaderInfo instanceof IndexedGetHeaderInfo) {
                        throw new IllegalStateException("Unexpected IndexedGetHeaderInfo returned by RangeHeaderInfoBuilder".toString());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                additionalStatements.addAll((Collection)((ProgressionHeaderInfo)headerInfo).getAdditionalStatements());
                switch (WhenMappings.$EnumSwitchMapping$0[((ProgressionHeaderInfo)headerInfo).getDirection().ordinal()]) {
                    case 1: {
                        Long l2 = UtilsKt.getConstLongValue(((ProgressionHeaderInfo)headerInfo).getStep());
                        long l3 = 1L;
                        if (l2 == null || l2 != l3) {
                            return null;
                        }
                        lower2 = ((ProgressionHeaderInfo)headerInfo).getFirst();
                        upper = ((ProgressionHeaderInfo)headerInfo).getLast();
                        shouldUpperComeFirst = ((ProgressionHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 2: {
                        Long l4 = UtilsKt.getConstLongValue(((ProgressionHeaderInfo)headerInfo).getStep());
                        long l3 = -1L;
                        if (l4 == null || l4 != l3) {
                            return null;
                        }
                        lower2 = ((ProgressionHeaderInfo)headerInfo).getLast();
                        upper = ((ProgressionHeaderInfo)headerInfo).getFirst();
                        shouldUpperComeFirst = !((ProgressionHeaderInfo)headerInfo).isReversed();
                        break;
                    }
                    case 3: {
                        return null;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                useCompareTo = ((ProgressionHeaderInfo)headerInfo).getProgressionType() instanceof UnsignedProgressionType;
                isUpperInclusive = ((ProgressionHeaderInfo)headerInfo).isLastInclusive();
                isNumericRange = true;
            } else if (headerInfo2 instanceof FloatingPointRangeHeaderInfo) {
                lower2 = ((FloatingPointRangeHeaderInfo)headerInfo).getStart();
                upper = ((FloatingPointRangeHeaderInfo)headerInfo).getEndInclusive();
                isUpperInclusive = true;
                shouldUpperComeFirst = false;
                useCompareTo = false;
                isNumericRange = true;
            } else if (headerInfo2 instanceof ComparableRangeInfo) {
                lower2 = ((ComparableRangeInfo)headerInfo).getStart();
                upper = ((ComparableRangeInfo)headerInfo).getEndInclusive();
                isUpperInclusive = true;
                shouldUpperComeFirst = false;
                useCompareTo = true;
                isNumericRange = false;
            } else {
                return null;
            }
            IrExpression arg = argument;
            IrBuiltIns builtIns = $this$buildContainsComparison.getContext().getIrBuiltIns();
            if (isNumericRange) {
                irClass = this.computeComparisonClass(this.context.getSymbols(), lower2.getType(), upper.getType(), arg.getType());
                if (irClass == null) {
                    return null;
                }
            } else {
                boolean bl = headerInfo instanceof ComparableRangeInfo;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                irClass = comparisonClass = (IrClass)this.context.getSymbols().getComparable().getOwner();
            }
            if (isNumericRange) {
                arg = UtilsKt.castIfNecessary(arg, comparisonClass);
            }
            Pair pair2 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, arg, "containsArg", null, false, 12, null);
            IrVariable argVar = (IrVariable)pair2.component1();
            argExpression = (IrExpression)pair2.component2();
            lowerExpression = null;
            upperExpression = null;
            useLowerClauseOnLeftSide = false;
            if (argVar != null) {
                pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                lowerVar = (IrVariable)pair.component1();
                tmpLowerExpression = (IrExpression)pair.component2();
                Pair pair3 = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                IrVariable upperVar = (IrVariable)pair3.component1();
                IrExpression tmpUpperExpression = (IrExpression)pair3.component2();
                if (shouldUpperComeFirst) {
                    CollectionsKt.addIfNotNull(additionalStatements, upperVar);
                    CollectionsKt.addIfNotNull(additionalStatements, lowerVar);
                } else {
                    CollectionsKt.addIfNotNull(additionalStatements, lowerVar);
                    CollectionsKt.addIfNotNull(additionalStatements, upperVar);
                }
                lowerExpression = IrUtilsKt.shallowCopy(tmpLowerExpression);
                upperExpression = IrUtilsKt.shallowCopy(tmpUpperExpression);
                useLowerClauseOnLeftSide = true;
            } else if (UtilsKt.getCanHaveSideEffects(lower2) && UtilsKt.getCanHaveSideEffects(upper)) {
                if (shouldUpperComeFirst) {
                    pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, upper, "containsUpper", null, false, 12, null);
                    IrVariable upperVar = (IrVariable)pair.component1();
                    IrExpression tmpUpperExpression = (IrExpression)pair.component2();
                    IrVariable irVariable = upperVar;
                    Intrinsics.checkNotNull(irVariable);
                    additionalStatements.add(irVariable);
                    lowerExpression = lower2;
                    upperExpression = IrUtilsKt.shallowCopy(tmpUpperExpression);
                    useLowerClauseOnLeftSide = true;
                } else {
                    pair = UtilsKt.createTemporaryVariableIfNecessary$default($this$buildContainsComparison, lower2, "containsLower", null, false, 12, null);
                    lowerVar = (IrVariable)pair.component1();
                    tmpLowerExpression = (IrExpression)pair.component2();
                    IrVariable irVariable = lowerVar;
                    Intrinsics.checkNotNull(irVariable);
                    additionalStatements.add(irVariable);
                    lowerExpression = IrUtilsKt.shallowCopy(tmpLowerExpression);
                    upperExpression = upper;
                    useLowerClauseOnLeftSide = false;
                }
            } else {
                lowerExpression = lower2;
                upperExpression = upper;
                useLowerClauseOnLeftSide = true;
            }
            CollectionsKt.addIfNotNull(additionalStatements, argVar);
            if (isNumericRange) {
                lowerExpression = UtilsKt.castIfNecessary(lowerExpression, comparisonClass);
                upperExpression = UtilsKt.castIfNecessary(upperExpression, comparisonClass);
            }
            lowerCompFun = MapsKt.getValue(builtIns.getLessOrEqualFunByOperandType(), useCompareTo ? builtIns.getIntClass() : comparisonClass.getSymbol());
            upperCompFun = MapsKt.getValue(isUpperInclusive ? builtIns.getLessOrEqualFunByOperandType() : builtIns.getLessFunByOperandType(), useCompareTo ? builtIns.getIntClass() : comparisonClass.getSymbol());
            $this$singleOrNull$iv = IrUtilsKt.getFunctions(comparisonClass);
            boolean $i$f$singleOrNull = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            object3 = $this$singleOrNull$iv.iterator();
            while (object3.hasNext()) {
                IrSimpleFunction element$iv = object3.next();
                it2 = element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it2.getName(), OperatorNameConventions.COMPARE_TO) && IrUtilsKt.hasShape$default((IrFunction)it2, true, false, 0, 1, null, 22, null) && (!isNumericRange || Intrinsics.areEqual(((IrFunction)it2).getParameters().get(1).getType(), IrUtilsKt.getDefaultType(comparisonClass))))) continue;
                if (found$iv) {
                    irSimpleFunction = null;
                    break block39;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            irSimpleFunction = !found$iv ? null : single$iv;
        }
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
        if (irSimpleFunction2 == null) {
            return null;
        }
        IrSimpleFunction compareToFun = irSimpleFunction2;
        if (useCompareTo) {
            Object $this$buildContainsComparison_u24lambda_u241 = $this$singleOrNull$iv = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, lowerCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u241).getArguments().set(0, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            IrFunctionAccessExpression found$iv = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, compareToFun);
            object3 = found$iv;
            int element$iv = 1;
            it2 = ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u241).getArguments();
            boolean bl2 = false;
            $this$buildContainsComparison_u24lambda_u241_u240.getArguments().set(0, IrUtilsKt.shallowCopy(argExpression));
            $this$buildContainsComparison_u24lambda_u241_u240.getArguments().set(1, lowerExpression);
            Unit unit = Unit.INSTANCE;
            ((ArrayList)it2).set(element$iv, found$iv);
            object2 = $this$singleOrNull$iv;
        } else {
            $this$buildContainsComparison_u24lambda_u242 = $this$singleOrNull$iv = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, lowerCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u242).getArguments().set(0, lowerExpression);
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u242).getArguments().set(1, IrUtilsKt.shallowCopy(argExpression));
            object2 = lowerClause = $this$singleOrNull$iv;
        }
        if (useCompareTo) {
            void $this$buildContainsComparison_u24lambda_u243_u240;
            Object $this$buildContainsComparison_u24lambda_u243 = $this$buildContainsComparison_u24lambda_u242 = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, upperCompFun);
            boolean bl = false;
            IrFunctionAccessExpression element$iv = $this$buildContainsComparison_u24lambda_u241_u240 = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, compareToFun);
            int it2 = 0;
            IrMemberAccessExpression.ValueArgumentsList bl2 = ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u243).getArguments();
            boolean bl3 = false;
            $this$buildContainsComparison_u24lambda_u243_u240.getArguments().set(0, IrUtilsKt.shallowCopy(argExpression));
            $this$buildContainsComparison_u24lambda_u243_u240.getArguments().set(1, upperExpression);
            Unit unit = Unit.INSTANCE;
            bl2.set(it2, $this$buildContainsComparison_u24lambda_u241_u240);
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u243).getArguments().set(1, ExpressionHelpersKt.irInt$default($this$buildContainsComparison, 0, null, 2, null));
            object = $this$buildContainsComparison_u24lambda_u242;
        } else {
            Object $this$buildContainsComparison_u24lambda_u244 = $this$buildContainsComparison_u24lambda_u242 = ExpressionHelpersKt.irCall((IrBuilder)$this$buildContainsComparison, upperCompFun);
            boolean bl = false;
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u244).getArguments().set(0, IrUtilsKt.shallowCopy(argExpression));
            ((IrMemberAccessExpression)$this$buildContainsComparison_u24lambda_u244).getArguments().set(1, upperExpression);
            object = $this$buildContainsComparison_u24lambda_u242;
        }
        Object upperClause = object;
        IrWhen contains = PrimitivesKt.andand($this$buildContainsComparison.getContext(), (IrExpression)(useLowerClauseOnLeftSide ? lowerClause : upperClause), (IrExpression)(useLowerClauseOnLeftSide ? upperClause : lowerClause), origin);
        if (additionalStatements.isEmpty()) {
            irExpression = contains;
        } else {
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$buildContainsComparison;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder bl3 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$buildContainsComparison_u24lambda_u245 = this_$iv$iv;
            boolean bl = false;
            for (IrStatement stmt : additionalStatements) {
                $this$buildContainsComparison_u24lambda_u245.unaryPlus(stmt);
            }
            $this$buildContainsComparison_u24lambda_u245.unaryPlus(contains);
            irExpression = (IrExpression)this_$iv$iv.doBuild();
        }
        return irExpression;
    }

    private final IrClass computeComparisonClass(Symbols symbols, IrType lowerType, IrType upperType, IrType argumentType) {
        IrType irType = this.leastCommonPrimitiveNumericType(symbols, lowerType, upperType);
        if (irType == null) {
            return null;
        }
        IrType commonBoundType = irType;
        IrType irType2 = this.leastCommonPrimitiveNumericType(symbols, argumentType, commonBoundType);
        return irType2 != null ? IrTypesKt.getClass(irType2) : null;
    }

    private final IrType leastCommonPrimitiveNumericType(Symbols symbols, IrType type1, IrType type2) {
        IrClassSymbol irClassSymbol;
        Intrinsics.checkNotNull(type1, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrClassSymbol irClassSymbol2 = UtilsKt.closestSuperClass(((IrSimpleType)type1).getClassifier());
        Intrinsics.checkNotNull(irClassSymbol2);
        IrSimpleType t1 = IrTypesKt.getDefaultType(irClassSymbol2);
        Intrinsics.checkNotNull(type2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrClassSymbol irClassSymbol3 = UtilsKt.closestSuperClass(((IrSimpleType)type2).getClassifier());
        Intrinsics.checkNotNull(irClassSymbol3);
        IrSimpleType t2 = IrTypesKt.getDefaultType(irClassSymbol3);
        PrimitiveType primitive1 = IrTypePredicatesKt.getPrimitiveType(t1);
        PrimitiveType primitive2 = IrTypePredicatesKt.getPrimitiveType(t2);
        UnsignedType unsigned1 = IrTypePredicatesKt.getUnsignedType(t1);
        UnsignedType unsigned2 = IrTypePredicatesKt.getUnsignedType(t2);
        if (primitive1 == PrimitiveType.DOUBLE || primitive2 == PrimitiveType.DOUBLE) {
            irClassSymbol = symbols.getDouble();
        } else if (primitive1 == PrimitiveType.FLOAT || primitive2 == PrimitiveType.FLOAT) {
            irClassSymbol = symbols.getFloat();
        } else if (unsigned1 == UnsignedType.ULONG || unsigned2 == UnsignedType.ULONG) {
            IrClassSymbol irClassSymbol4 = symbols.getULong();
            irClassSymbol = irClassSymbol4;
            Intrinsics.checkNotNull(irClassSymbol4);
        } else if (this.isPromotableToUInt(unsigned1) || this.isPromotableToUInt(unsigned2)) {
            IrClassSymbol irClassSymbol5 = symbols.getUInt();
            irClassSymbol = irClassSymbol5;
            Intrinsics.checkNotNull(irClassSymbol5);
        } else if (primitive1 == PrimitiveType.LONG || primitive2 == PrimitiveType.LONG) {
            irClassSymbol = symbols.getLong();
        } else if (this.isPromotableToInt(primitive1) || this.isPromotableToInt(primitive2)) {
            irClassSymbol = symbols.getInt();
        } else if (primitive1 == PrimitiveType.CHAR || primitive2 == PrimitiveType.CHAR) {
            irClassSymbol = symbols.getChar();
        } else {
            throw new IllegalStateException(("Unexpected types: t1=" + RenderIrElementKt.render$default(t1, null, 1, null) + ", t2=" + RenderIrElementKt.render$default(t2, null, 1, null)).toString());
        }
        return IrTypesKt.getDefaultType(irClassSymbol);
    }

    private final boolean isPromotableToInt(PrimitiveType $this$isPromotableToInt) {
        return $this$isPromotableToInt == PrimitiveType.INT || $this$isPromotableToInt == PrimitiveType.SHORT || $this$isPromotableToInt == PrimitiveType.BYTE;
    }

    private final boolean isPromotableToUInt(UnsignedType $this$isPromotableToUInt) {
        return $this$isPromotableToUInt == UnsignedType.UINT || $this$isPromotableToUInt == UnsignedType.USHORT || $this$isPromotableToUInt == UnsignedType.UBYTE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressionDirection.values().length];
            try {
                nArray[ProgressionDirection.INCREASING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressionDirection.DECREASING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressionDirection.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

