/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPackageEntryTableAccessor
extends ValueListPropertyAccessor<PackageEntryTable> {
    public static final char BLANK_LINE_CHAR = '|';
    public static final String STATIC_PREFIX = "$";
    public static final String MODULE_PREFIX = "@";
    private final Field myField;

    public JavaPackageEntryTableAccessor(@NotNull Object object, @NotNull Field field) {
        if (object == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(0);
        }
        if (field == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(1);
        }
        super(object, field);
        this.myField = field;
    }

    @Nullable
    protected PackageEntryTable fromExternal(@NotNull List<String> strList) {
        if (strList == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(2);
        }
        PackageEntryTable entryTable = new PackageEntryTable();
        for (String strValue : strList) {
            String parseStr = strValue.trim();
            if (!parseStr.isEmpty() && parseStr.charAt(0) == '|') {
                for (int i = 0; i < parseStr.length(); ++i) {
                    if (parseStr.charAt(i) != '|') continue;
                    entryTable.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                continue;
            }
            boolean isStatic = false;
            boolean isWithSubpackages = false;
            boolean isModule = false;
            if (parseStr.startsWith(STATIC_PREFIX)) {
                parseStr = parseStr.substring(STATIC_PREFIX.length()).trim();
                isStatic = true;
            }
            if (parseStr.startsWith(MODULE_PREFIX)) {
                parseStr = parseStr.substring(MODULE_PREFIX.length()).trim();
                isModule = true;
            }
            if ((parseStr = parseStr.trim()).endsWith("**")) {
                isWithSubpackages = true;
                parseStr = parseStr.substring(0, parseStr.length() - 1);
            }
            if ("*".equals(parseStr)) {
                if (isModule) {
                    entryTable.addEntry(PackageEntry.ALL_MODULE_IMPORTS);
                    continue;
                }
                if (isStatic) {
                    entryTable.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
                    continue;
                }
                entryTable.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
                continue;
            }
            entryTable.addEntry(new PackageEntry(isStatic, parseStr, isWithSubpackages));
        }
        if ("imports_layout".equals(this.getPropertyName()) && JavaCodeStyleSettings.class.equals(this.myField.getDeclaringClass()) && !ContainerUtil.exists((Object[])entryTable.getEntries(), entry -> entry == PackageEntry.ALL_MODULE_IMPORTS)) {
            entryTable.insertEntryAt(PackageEntry.ALL_MODULE_IMPORTS, 0);
        }
        return entryTable;
    }

    @NotNull
    protected List<String> toExternal(@NotNull PackageEntryTable value) {
        if (value == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(3);
        }
        ArrayList<String> externalList = new ArrayList<String>();
        PackageEntry[] entries = value.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            PackageEntry entry = entries[i];
            if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                externalList.add(String.valueOf('|'));
                continue;
            }
            StringBuilder entryBuilder = new StringBuilder();
            if (entry.isStatic()) {
                entryBuilder.append(STATIC_PREFIX);
            }
            if (entry == PackageEntry.ALL_MODULE_IMPORTS) {
                Object dataObject = this.getDataObject();
                if (i == 0 && dataObject instanceof JavaCodeStyleSettings) continue;
                entryBuilder.append(MODULE_PREFIX);
            }
            if (entry.isSpecial()) {
                entryBuilder.append("*");
            } else {
                entryBuilder.append(entry.getPackageName()).append(".*");
                if (entry.isWithSubpackages()) {
                    entryBuilder.append("*");
                }
            }
            externalList.add(entryBuilder.toString());
        }
        ArrayList<String> arrayList = externalList;
        if (arrayList == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected String valueToString(@NotNull List<String> value) {
        if (value == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(5);
        }
        return CodeStylePropertiesUtil.toCommaSeparatedString(value);
    }

    public boolean isEmptyListAllowed() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strList";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/JavaPackageEntryTableAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/JavaPackageEntryTableAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toExternal";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

