/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.props;

import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.Date;

public class ExtProperty
implements IsfObject {
    String name;
    String type;
    String value;
    private static final String LESS_THAN = "&lt;";
    private static final String GREATER_THAN = "&gt;";
    private static final String APOSTROPHE = "&apos;";
    private static final String QUOTE = "&quot;";
    private static final String AMPERSAND = "&amp;";

    public ExtProperty(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public ExtProperty(String name, Options propList) {
        this.name = name;
        OptionType optionType = propList.getType(name);
        switch (optionType) {
            case INT_TYPE: {
                this.type = "int";
                this.value = Integer.toString(propList.getInt(name, 0));
                break;
            }
            case LONG_TYPE: {
                this.type = "long";
                this.value = Long.toString(propList.getLong(name, 0L));
                break;
            }
            case STRING_TYPE: {
                this.type = "string";
                this.value = propList.getString(name, "");
                break;
            }
            case BOOLEAN_TYPE: {
                this.type = "bool";
                this.value = Boolean.toString(propList.getBoolean(name, true));
                break;
            }
            case DOUBLE_TYPE: {
                this.type = "double";
                this.value = Double.toString(propList.getDouble(name, 0.0));
                break;
            }
            case FLOAT_TYPE: {
                this.type = "float";
                this.value = Float.toString(propList.getFloat(name, 0.0f));
                break;
            }
            case DATE_TYPE: {
                this.type = "date";
                Date date = propList.getDate(name, (Date)null);
                long time = date == null ? 0L : date.getTime();
                this.value = Long.toHexString(time);
                break;
            }
            case COLOR_TYPE: {
                this.type = "color";
                Color color = propList.getColor(name, null);
                int rgb = color.getRGB();
                this.value = Integer.toHexString(rgb);
                break;
            }
            case ENUM_TYPE: {
                this.type = "enum";
                Enum enuum = propList.getEnum(name, null);
                String enumString = OptionType.ENUM_TYPE.convertObjectToString((Object)enuum);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case FILE_TYPE: {
                String path;
                this.type = "file";
                File file = propList.getFile(name, null);
                this.value = path = file.getAbsolutePath();
                break;
            }
            case FONT_TYPE: {
                this.type = "font";
                Font font = propList.getFont(name, null);
                String enumString = OptionType.FONT_TYPE.convertObjectToString((Object)font);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case KEYSTROKE_TYPE: {
                this.type = "actionTrigger";
                ActionTrigger trigger = propList.getActionTrigger(name, null);
                String enumString = OptionType.ACTION_TRIGGER.convertObjectToString((Object)trigger);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case ACTION_TRIGGER: {
                this.type = "actionTrigger";
                ActionTrigger actionTrigger = propList.getActionTrigger(name, null);
                String enumString = OptionType.ACTION_TRIGGER.convertObjectToString((Object)actionTrigger);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case CUSTOM_TYPE: {
                this.type = "custom";
                CustomOption custom = propList.getCustomOption(name, null);
                String enumString = OptionType.CUSTOM_TYPE.convertObjectToString((Object)custom);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case BYTE_ARRAY_TYPE: {
                this.type = "bytes";
                byte[] bytes = propList.getByteArray(name, null);
                String enumString = OptionType.BYTE_ARRAY_TYPE.convertObjectToString((Object)bytes);
                this.value = ExtProperty.escapeElementEntities(enumString);
                break;
            }
            case NO_TYPE: {
                break;
            }
            default: {
                throw new AssertException();
            }
        }
    }

    public static String escapeElementEntities(String sarif) {
        int codePoint;
        StringBuilder buffer = new StringBuilder();
        block7: for (int offset = 0; offset < sarif.length(); offset += Character.charCount(codePoint)) {
            codePoint = sarif.codePointAt(offset);
            if (codePoint < 32 && codePoint != 9 && codePoint != 10 && codePoint != 13) continue;
            if (codePoint >= 127) {
                buffer.append("&#x");
                buffer.append(Integer.toString(codePoint, 16).toUpperCase());
                buffer.append(";");
                continue;
            }
            switch (codePoint) {
                case 60: {
                    buffer.append(LESS_THAN);
                    continue block7;
                }
                case 62: {
                    buffer.append(GREATER_THAN);
                    continue block7;
                }
                case 39: {
                    buffer.append(APOSTROPHE);
                    continue block7;
                }
                case 34: {
                    buffer.append(QUOTE);
                    continue block7;
                }
                case 38: {
                    buffer.append(AMPERSAND);
                    continue block7;
                }
            }
            buffer.appendCodePoint(codePoint);
        }
        return buffer.toString();
    }
}

