/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime._type", "internal/abi.Type"})
public class GoPlainType
extends GoType
implements StructureReader<GoType> {
    @Override
    public void readStructure() throws IOException {
        this.typ = this.context.getDataTypeMapper().readStructure(GoBaseType.class, this.context.getReader());
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoTypeManager goTypes = this.programContext.getGoTypes();
        DataType dt = goTypes.recoverPlainDataType(this.typ.getKind());
        if (dt == null) {
            dt = super.recoverDataType();
        }
        String name = goTypes.getTypeName(this);
        if (!dt.getName().equalsIgnoreCase(name)) {
            DataTypeManager dtm = goTypes.getDTM();
            dt = new TypedefDataType(goTypes.getCP(this), name, dt, dtm);
        }
        if ((long)dt.getLength() != this.typ.getSize()) {
            Msg.warn((Object)this, (Object)"Recovered Go data type size mismatch: %s, %d != %d".formatted(this.getDebugId(), this.typ.getSize(), dt.getLength()));
        }
        return dt;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        return super.discoverGoTypes(discoveredTypes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isValid() {
        if (!super.isValid()) return false;
        switch (this.typ.getKind()) {
            case Bool: {
                if (this.typ.getSize() != 1L) return false;
                break;
            }
            case Float32: {
                if (this.typ.getSize() != 4L) return false;
                break;
            }
            case Float64: {
                if (this.typ.getSize() != 8L) return false;
                break;
            }
            case Uint: 
            case Int: {
                if (this.typ.getSize() != (long)this.programContext.getPtrSize()) return false;
                break;
            }
            case Uint8: 
            case Int8: {
                if (this.typ.getSize() != 1L) return false;
                break;
            }
            case Uint16: 
            case Int16: {
                if (this.typ.getSize() != 2L) return false;
                break;
            }
            case Uint32: 
            case Int32: {
                if (this.typ.getSize() != 4L) return false;
                break;
            }
            case Uint64: 
            case Int64: {
                if (this.typ.getSize() != 8L) return false;
                break;
            }
            case Uintptr: {
                if (this.typ.getSize() != (long)this.programContext.getPtrSize()) return false;
                break;
            }
            case String: {
                if (this.typ.getSize() != (long)(this.programContext.getPtrSize() * 2)) return false;
                break;
            }
            case UnsafePointer: {
                if (this.typ.getSize() != (long)this.programContext.getPtrSize()) return false;
            }
        }
        return true;
    }
}

