/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.nodes.CodeSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.FunctionSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.app.util.SelectionTransferData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import java.awt.datatransfer.DataFlavor;
import javax.swing.Icon;
import resources.ResourceManager;

public class ClassSymbolNode
extends SymbolNode {
    static final DataFlavor LOCAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Local Classes");
    static final DataFlavor GLOBAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Global Classes");
    private static final Icon CLASS_ICON = new GIcon("icon.plugin.symboltree.node.class");
    private static final Icon DISABLED_CLASS_ICONDISABLED_CLASS_ICON = ResourceManager.getDisabledIcon((Icon)CLASS_ICON);

    ClassSymbolNode(Program program, Symbol symbol) {
        super(program, symbol);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.isCut()) {
            return DISABLED_CLASS_ICONDISABLED_CLASS_ICON;
        }
        return CLASS_ICON;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return this.symbol.isGlobal() ? GLOBAL_DATA_FLAVOR : LOCAL_DATA_FLAVOR;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (this.symbol.isExternal() && this.isExternal(flavor)) {
                return true;
            }
            if (this.isLabelOrFunction(flavor)) {
                return true;
            }
            if (!this.isProgramSelection(flavor)) continue;
            return true;
        }
        return false;
    }

    private boolean isProgramSelection(DataFlavor flavor) {
        Class<?> clazz = flavor.getRepresentationClass();
        return SelectionTransferData.class.equals(clazz);
    }

    private boolean isExternal(DataFlavor dataFlavor) {
        return dataFlavor == CodeSymbolNode.EXTERNAL_DATA_FLAVOR || dataFlavor == FunctionSymbolNode.EXTERNAL_DATA_FLAVOR;
    }

    private boolean isLabelOrFunction(DataFlavor dataFlavor) {
        return dataFlavor == CodeSymbolNode.GLOBAL_DATA_FLAVOR || dataFlavor == CodeSymbolNode.LOCAL_DATA_FLAVOR || dataFlavor == FunctionSymbolNode.GLOBAL_DATA_FLAVOR || dataFlavor == FunctionSymbolNode.LOCAL_DATA_FLAVOR;
    }

    @Override
    public Namespace getNamespace() {
        return (Namespace)this.symbol.getObject();
    }

    @Override
    public boolean canCut() {
        return true;
    }
}

