/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DockingWindowManager;
import docking.widgets.PasswordDialog;
import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.SystemUtilities;
import java.util.Arrays;
import javax.swing.JFrame;

public class PopupKeyStorePasswordProvider
implements KeyStorePasswordProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getKeyStorePassword(String keystorePath, boolean passwordError) {
        KeystorePasswordPrompt pp = new KeystorePasswordPrompt(keystorePath, passwordError);
        try {
            SystemUtilities.runSwingNow((Runnable)pp);
            char[] cArray = pp.getPassword();
            return cArray;
        }
        finally {
            pp.clearPassword();
        }
    }

    private static class KeystorePasswordPrompt
    implements Runnable {
        private String file;
        private boolean passwordError;
        private char[] password;

        KeystorePasswordPrompt(String file, boolean passwordError) {
            this.file = file;
            this.passwordError = passwordError;
        }

        @Override
        public void run() {
            DockingWindowManager winMgr;
            PasswordDialog pwdDialog = new PasswordDialog("Protected PKI Certificate", "Cert File", this.file, null);
            if (this.passwordError) {
                pwdDialog.setErrorText("Incorrect password");
            }
            JFrame rootFrame = (winMgr = DockingWindowManager.getActiveInstance()) != null ? winMgr.getRootFrame() : null;
            DockingWindowManager.showDialog(rootFrame, pwdDialog);
            if (pwdDialog.okWasPressed()) {
                this.password = pwdDialog.getPassword();
            }
            pwdDialog.dispose();
        }

        char[] getPassword() {
            return this.password == null ? null : (char[])this.password.clone();
        }

        void clearPassword() {
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
        }
    }
}

