/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.util.Utils;

public class Scope
extends FreeColObject {
    public static final String TAG = "scope";
    private String type = null;
    private String abilityId = null;
    private boolean abilityValue = true;
    private String methodName = null;
    private String methodValue = null;
    private boolean matchesNull = true;
    private boolean matchNegated = false;
    private static final String ABILITY_ID_TAG = "ability-id";
    private static final String ABILITY_VALUE_TAG = "ability-value";
    private static final String MATCH_NEGATED_TAG = "match-negated";
    private static final String MATCHES_NULL_TAG = "matches-null";
    private static final String METHOD_NAME_TAG = "method-name";
    private static final String METHOD_VALUE_TAG = "method-value";
    private static final String TYPE_TAG = "type";
    private static final String OLD_MATCH_NEGATED_TAG = "matchNegated";
    private static final String OLD_MATCHES_NULL_TAG = "matchesNull";
    private static final String OLD_METHOD_NAME_TAG = "methodName";
    private static final String OLD_METHOD_VALUE_TAG = "methodValue";

    public Scope() {
    }

    public Scope(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public String getKey() {
        return this.getType() != null ? this.getType() : (this.getAbilityId() != null ? this.getAbilityId() : (this.getMethodName() != null ? "scope.method." + this.getMethodName() : null));
    }

    public String getFeatureString() {
        Object k = this.getKey();
        if (k == null) {
            k = "";
        } else {
            k = Messages.getName((String)k);
            if (this.getMatchNegated()) {
                k = "!" + (String)k;
            }
        }
        return k;
    }

    private boolean getMatchesNull() {
        return this.matchesNull;
    }

    public void setMatchesNull(boolean newMatchesNull) {
        this.matchesNull = newMatchesNull;
    }

    public boolean getMatchNegated() {
        return this.matchNegated;
    }

    public void setMatchNegated(boolean newMatchNegated) {
        this.matchNegated = newMatchNegated;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getAbilityId() {
        return this.abilityId;
    }

    public void setAbilityId(String newAbilityId) {
        this.abilityId = newAbilityId;
    }

    public boolean getAbilityValue() {
        return this.abilityValue;
    }

    public void setAbilityValue(boolean newAbilityValue) {
        this.abilityValue = newAbilityValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public void setMethodValue(String newMethodValue) {
        this.methodValue = newMethodValue;
    }

    public boolean appliesTo(FreeColObject object) {
        Object ret;
        FreeColSpecObjectType fcgot;
        if (object == null) {
            return this.matchesNull;
        }
        if (this.type != null && (object instanceof FreeColSpecObjectType ? !this.type.equals(object.getId()) : (fcgot = object.invokeMethod("getType", FreeColSpecObjectType.class, null)) == null || !this.type.equals(fcgot.getId()))) {
            return this.matchNegated;
        }
        if (this.abilityId != null && object.hasAbility(this.abilityId) != this.abilityValue) {
            return this.matchNegated;
        }
        if (this.methodName != null && !String.valueOf(ret = object.invokeMethod(this.methodName, Object.class, null)).equals(this.methodValue)) {
            return this.matchNegated;
        }
        return !this.matchNegated;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Scope o = this.copyInCast(other, Scope.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.type = o.getType();
        this.abilityId = o.getAbilityId();
        this.abilityValue = o.getAbilityValue();
        this.methodName = o.getMethodName();
        this.methodValue = o.getMethodValue();
        this.matchesNull = o.getMatchesNull();
        this.matchNegated = o.getMatchNegated();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeAttribute(MATCH_NEGATED_TAG, this.matchNegated);
        xw.writeAttribute(MATCHES_NULL_TAG, this.matchesNull);
        if (this.type != null) {
            xw.writeAttribute(TYPE_TAG, this.type);
        }
        if (this.abilityId != null) {
            xw.writeAttribute(ABILITY_ID_TAG, this.abilityId);
            xw.writeAttribute(ABILITY_VALUE_TAG, this.abilityValue);
        }
        if (this.methodName != null) {
            xw.writeAttribute(METHOD_NAME_TAG, this.methodName);
            if (this.methodValue != null) {
                xw.writeAttribute(METHOD_VALUE_TAG, this.methodValue);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.matchNegated = xr.hasAttribute(OLD_MATCH_NEGATED_TAG) ? xr.getAttribute(OLD_MATCH_NEGATED_TAG, false) : xr.getAttribute(MATCH_NEGATED_TAG, false);
        this.matchesNull = xr.hasAttribute(OLD_MATCHES_NULL_TAG) ? xr.getAttribute(OLD_MATCHES_NULL_TAG, true) : xr.getAttribute(MATCHES_NULL_TAG, true);
        this.type = xr.getAttribute(TYPE_TAG, null);
        this.abilityId = xr.getAttribute(ABILITY_ID_TAG, null);
        this.abilityValue = xr.getAttribute(ABILITY_VALUE_TAG, true);
        this.methodName = xr.hasAttribute(OLD_METHOD_NAME_TAG) ? xr.getAttribute(OLD_METHOD_NAME_TAG, null) : xr.getAttribute(METHOD_NAME_TAG, null);
        this.methodValue = xr.hasAttribute(OLD_METHOD_VALUE_TAG) ? xr.getAttribute(OLD_METHOD_VALUE_TAG, null) : xr.getAttribute(METHOD_VALUE_TAG, null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Scope) {
            Scope other = (Scope)o;
            if (this.matchNegated != other.matchNegated) {
                return false;
            }
            if (this.matchesNull != other.matchesNull) {
                return false;
            }
            if (this.type == null ? other.getType() != null : !this.type.equals(other.getType())) {
                return false;
            }
            if (this.abilityId == null ? !Utils.equals(other.getAbilityId(), this.abilityId) : !this.abilityId.equals(other.getAbilityId())) {
                return false;
            }
            if (this.abilityValue != other.getAbilityValue()) {
                return false;
            }
            if (this.methodName == null ? !Utils.equals(other.getMethodName(), this.methodName) : !this.methodName.equals(other.getMethodName())) {
                return false;
            }
            if (this.methodValue == null ? !Utils.equals(other.getMethodValue(), this.methodValue) : !this.methodValue.equals(other.getMethodValue())) {
                return false;
            }
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.type == null ? 0 : this.type.hashCode());
        hash = 31 * hash + (this.abilityId == null ? 0 : this.abilityId.hashCode());
        hash = 31 * hash + (this.abilityValue ? 1 : 0);
        hash = 31 * hash + (this.methodName == null ? 0 : this.methodName.hashCode());
        hash = 31 * hash + (this.methodValue == null ? 0 : this.methodValue.hashCode());
        hash = 31 * hash + (this.matchesNull ? 1 : 0);
        return 31 * hash + (this.matchNegated ? 1 : 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[Scope ").append(this.type);
        if (this.abilityId != null) {
            sb.append(' ').append(this.abilityId).append('=').append(this.abilityValue);
        }
        if (this.methodName != null) {
            sb.append(' ').append(this.methodName).append('=').append(this.methodValue);
        }
        if (this.matchesNull) {
            sb.append(" matches-null");
        }
        if (this.matchNegated) {
            sb.append(" match-negated");
        }
        sb.append(']');
        return sb.toString();
    }
}

