/**
 * Proj4js -- Javascript reprojection library.
 * Authors:
 *   Mike Adair madairATdmsolutions.ca
 *   Richard Greenwood richATgreenwoodmap.com
 *   Didier Richard didier.richardATign.fr
 *   Stephen Irons stephen.ironsATclear.net.nz
 *   Olivier Terral oterralATgmail.com
 *   Calvin Metcalf cmetcalfATappgeo.com
 * Copyright (c) 2014, Mike Adair, Richard Greenwood, Didier Richard, Stephen Irons, Olivier Terral and Calvin Metcalf
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(t,s){"object"==typeof exports&&"undefined"!=typeof module?module.exports=s():"function"==typeof define&&define.amd?define(s):t.proj4=s()}(this,function(){"use strict";function d(t,s){if(t[s])return t[s];for(var i,a=Object.keys(t),h=s.toLowerCase().replace($,""),e=-1;++e<a.length;)if((i=a[e]).toLowerCase().replace($,"")===h)return t[i]}function a(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}function h(t,s,i){Array.isArray(s)&&(i.unshift(s),s=null);i=i.reduce(function(t,s){return e(s,t),t},s?{}:t);s&&(t[s]=i)}function e(t,s){if(Array.isArray(t)){var i,a=t.shift();if("PARAMETER"===a&&(a=t.shift()),1===t.length)return Array.isArray(t[0])?(s[a]={},void e(t[0],s[a])):void(s[a]=t[0]);if(t.length)if("TOWGS84"!==a){if("AXIS"===a)return a in s||(s[a]=[]),void s[a].push(t);switch(Array.isArray(a)||(s[a]={}),a){case"UNIT":case"PRIMEM":case"VERT_DATUM":return s[a]={name:t[0].toLowerCase(),convert:t[1]},void(3===t.length&&e(t[2],s[a]));case"SPHEROID":case"ELLIPSOID":return s[a]={name:t[0],a:t[1],rf:t[2]},void(4===t.length&&e(t[3],s[a]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return t[0]=["name",t[0]],void h(s,a,t);default:for(i=-1;++i<t.length;)if(!Array.isArray(t[i]))return e(t,s[a]);return h(s,a,t)}}else s[a]=t;else s[a]=!0}else s[t]=!0}function r(t){return.017453292519943295*t}function n(h){function t(t){return t*(h.to_meter||1)}if("GEOGCS"===h.type?h.projName="longlat":"LOCAL_CS"===h.type?(h.projName="identity",h.local=!0):"object"==typeof h.PROJECTION?h.projName=Object.keys(h.PROJECTION)[0]:h.projName=h.PROJECTION,h.AXIS){for(var s="",i=0,a=h.AXIS.length;i<a;++i){var e=[h.AXIS[i][0].toLowerCase(),h.AXIS[i][1].toLowerCase()];-1!==e[0].indexOf("north")||("y"===e[0]||"lat"===e[0])&&"north"===e[1]?s+="n":-1!==e[0].indexOf("south")||("y"===e[0]||"lat"===e[0])&&"south"===e[1]?s+="s":-1!==e[0].indexOf("east")||("x"===e[0]||"lon"===e[0])&&"east"===e[1]?s+="e":-1===e[0].indexOf("west")&&("x"!==e[0]&&"lon"!==e[0]||"west"!==e[1])||(s+="w")}2===s.length&&(s+="u"),3===s.length&&(h.axis=s)}h.UNIT&&(h.units=h.UNIT.name.toLowerCase(),"metre"===h.units&&(h.units="meter"),h.UNIT.convert&&("GEOGCS"===h.type?h.DATUM&&h.DATUM.SPHEROID&&(h.to_meter=h.UNIT.convert*h.DATUM.SPHEROID.a):h.to_meter=h.UNIT.convert));var n=h.GEOGCS;(n="GEOGCS"===h.type?h:n)&&(n.DATUM?h.datumCode=n.DATUM.name.toLowerCase():h.datumCode=n.name.toLowerCase(),"d_"===h.datumCode.slice(0,2)&&(h.datumCode=h.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==h.datumCode&&"new_zealand_1949"!==h.datumCode||(h.datumCode="nzgd49"),"wgs_1984"!==h.datumCode&&"world_geodetic_system_1984"!==h.datumCode||("Mercator_Auxiliary_Sphere"===h.PROJECTION&&(h.sphere=!0),h.datumCode="wgs84"),"_ferro"===h.datumCode.slice(-6)&&(h.datumCode=h.datumCode.slice(0,-6)),"_jakarta"===h.datumCode.slice(-8)&&(h.datumCode=h.datumCode.slice(0,-8)),~h.datumCode.indexOf("belge")&&(h.datumCode="rnb72"),n.DATUM&&n.DATUM.SPHEROID&&(h.ellps=n.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===h.ellps.toLowerCase().slice(0,13)&&(h.ellps="intl"),h.a=n.DATUM.SPHEROID.a,h.rf=parseFloat(n.DATUM.SPHEROID.rf,10)),n.DATUM&&n.DATUM.TOWGS84&&(h.datum_params=n.DATUM.TOWGS84),~h.datumCode.indexOf("osgb_1936")&&(h.datumCode="osgb36"),~h.datumCode.indexOf("osni_1952")&&(h.datumCode="osni52"),(~h.datumCode.indexOf("tm65")||~h.datumCode.indexOf("geodetic_datum_of_1965"))&&(h.datumCode="ire65"),"ch1903+"===h.datumCode&&(h.datumCode="ch1903"),~h.datumCode.indexOf("israel")&&(h.datumCode="isr93")),h.b&&!isFinite(h.b)&&(h.b=h.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",r],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",r],["x0","false_easting",t],["y0","false_northing",t],["long0","central_meridian",r],["lat0","latitude_of_origin",r],["lat0","standard_parallel_1",r],["lat1","standard_parallel_1",r],["lat2","standard_parallel_2",r],["azimuth","Azimuth"],["alpha","azimuth",r],["srsCode","name"]].forEach(function(t){var s,i,a;s=h,a=(i=t)[0],t=i[1],!(a in s)&&t in s&&(s[a]=s[t],3===i.length&&(s[a]=i[2](s[a])))}),h.long0||!h.longc||"Albers_Conic_Equal_Area"!==h.projName&&"Lambert_Azimuthal_Equal_Area"!==h.projName||(h.long0=h.longc),h.lat_ts||!h.lat1||"Stereographic_South_Pole"!==h.projName&&"Polar Stereographic (variant B)"!==h.projName||(h.lat0=r(0<h.lat1?90:-90),h.lat_ts=h.lat1)}function o(t){var s=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=tt(arguments[1]):o[t]=nt(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map(function(t){Array.isArray(t)?o.apply(s,t):o(t)});if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t)}}function p(t){if("string"!=typeof t)return t;if(t in o)return o[t];var s;if(s=t,Mt.some(function(t){return-1<s.indexOf(t)})){var i=nt(t);if(function(t){if(t=d(t,"authority")){t=d(t,"epsg");return t&&-1<ft.indexOf(t)}}(i))return o["EPSG:3857"];var a=function(t){if(t=d(t,"extension"))return d(t,"proj4")}(i);return a?tt(a):i}return"+"===t[0]?tt(t):void 0}function t(t){return t}function s(t,s){var i=yt.length;return t.names?((yt[i]=t).names.forEach(function(t){mt[t.toLowerCase()]=i}),this):(console.log(s),!0)}function m(t){if(0===t.length)return null;var s="@"===t[0];return"null"===(t=s?t.slice(1):t)?{name:"null",mandatory:!s,grid:null,isNull:!0}:{name:t,mandatory:!s,grid:vt[t]||null,isNull:!1}}function l(t){return t/3600*Math.PI/180}function u(t,s,i){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(s,i)))}function c(t,s,i){for(var a=[],h=0;h<s.nSubgrids;h++){var e=(o=i,{name:u(n=t,(r=176)+8,r+16).trim(),parent:u(n,r+24,r+24+8).trim(),lowerLatitude:n.getFloat64(r+72,o),upperLatitude:n.getFloat64(r+88,o),lowerLongitude:n.getFloat64(r+104,o),upperLongitude:n.getFloat64(r+120,o),latitudeInterval:n.getFloat64(r+136,o),longitudeInterval:n.getFloat64(r+152,o),gridNodeCount:n.getInt32(r+168,o)}),n=function(t,s,i,a){for(var h=s+176,e=[],n=0;n<i.gridNodeCount;n++){var r={latitudeShift:t.getFloat32(h+16*n,a),longitudeShift:t.getFloat32(h+16*n+4,a),latitudeAccuracy:t.getFloat32(h+16*n+8,a),longitudeAccuracy:t.getFloat32(h+16*n+12,a)};e.push(r)}return e}(t,176,e,i),r=Math.round(1+(e.upperLongitude-e.lowerLongitude)/e.longitudeInterval),o=Math.round(1+(e.upperLatitude-e.lowerLatitude)/e.latitudeInterval);a.push({ll:[l(e.lowerLongitude),l(e.lowerLatitude)],del:[l(e.longitudeInterval),l(e.latitudeInterval)],lim:[r,o],count:e.gridNodeCount,cvs:n.map(function(t){return[l(t.longitudeShift),l(t.latitudeShift)]})})}return a}function y(t,s){if(!(this instanceof y))return new y(t);s=s||function(t){if(t)throw t};var i,a,h,e,n,r,o,l,u,c,M,f=p(t);"object"==typeof f&&(i=y.projections.get(f.projName))?(!f.datumCode||"none"===f.datumCode||(r=d(bt,f.datumCode))&&(f.datum_params=f.datum_params||(r.towgs84?r.towgs84.split(","):null),f.ellps=r.ellipse,f.datumName=r.datumName||f.datumCode),f.k0=f.k0||1,f.axis=f.axis||"enu",f.ellps=f.ellps||"wgs84",f.lat1=f.lat1||f.lat0,o=f.a,l=f.b,u=f.rf,c=f.ellps,M=f.sphere,o||(o=(c=(c=d(gt,c))||xt).a,l=c.b,u=c.rf),u&&!l&&(l=(1-1/u)*o),(0===u||Math.abs(o-l)<W)&&(M=!0,l=o),e=(a={a:o,b:l,rf:u,sphere:M}).a,n=a.b,r=f.R_A,l=((c=e*e)-(o=n*n))/c,n=0,r?(c=(e*=1-l*(F+l*(U+l*Q)))*e,l=0):n=Math.sqrt(l),u={es:l,e:n,ep2:(c-o)/o},r=void 0===(M=f.nadgrids)?null:M.split(",").map(m),h=f.datum||(e=f.datumCode,l=f.datum_params,n=a.a,c=a.b,o=u.es,M=u.ep2,r=r,(h={}).datum_type=void 0===e||"none"===e?B:z,l&&(h.datum_params=l.map(parseFloat),0===h.datum_params[0]&&0===h.datum_params[1]&&0===h.datum_params[2]||(h.datum_type=G),3<h.datum_params.length&&(0===h.datum_params[3]&&0===h.datum_params[4]&&0===h.datum_params[5]&&0===h.datum_params[6]||(h.datum_type=L,h.datum_params[3]*=T,h.datum_params[4]*=T,h.datum_params[5]*=T,h.datum_params[6]=h.datum_params[6]/1e6+1))),r&&(h.datum_type=R,h.grids=r),h.a=n,h.b=c,h.es=o,h.ep2=M,h),rt(this,f),rt(this,i),this.a=a.a,this.b=a.b,this.rf=a.rf,this.sphere=a.sphere,this.es=u.es,this.e=u.e,this.ep2=u.ep2,this.datum=h,this.init(),s(null,this)):s(t)}function M(t,s,i){var a=t.x,h=t.y,e=t.z||0;if(h<-D&&-1.001*D<h)h=-D;else if(D<h&&h<1.001*D)h=D;else{if(h<-D)return{x:-1/0,y:-1/0,z:t.z};if(D<h)return{x:1/0,y:1/0,z:t.z}}return a>Math.PI&&(a-=2*Math.PI),t=Math.sin(h),h=Math.cos(h),{x:((i=i/Math.sqrt(1-s*(t*t)))+e)*h*Math.cos(a),y:(i+e)*h*Math.sin(a),z:(i*(1-s)+e)*t}}function f(t,s,i,a){var h,e,n,r,o,l,u,c,M,f,d,p=t.x,m=t.y,y=t.z||0,_=Math.sqrt(p*p+m*m),g=Math.sqrt(p*p+m*m+y*y);if(_/i<1e-12){if(f=0,g/i<1e-12)return d=-a,{x:t.x,y:t.y,z:t.z}}else f=Math.atan2(m,p);for(h=y/g,r=(e=_/g)*(1-s)*(n=1/Math.sqrt(1-s*(2-s)*e*e)),o=h*n,M=0;M++,c=s*(c=i/Math.sqrt(1-s*o*o))/(c+(d=_*r+y*o-c*(1-s*o*o))),c=(u=h*(n=1/Math.sqrt(1-c*(2-c)*e*e)))*r-(l=e*(1-c)*n)*o,r=l,o=u,1e-24<c*c&&M<30;);return{x:f,y:Math.atan(u/Math.abs(l)),z:d}}function _(t){return t===G||t===L}function g(t,s,i){if(null===t.grids||0===t.grids.length)return console.log("Grid shift grids not found"),-1;for(var a={x:-i.x,y:i.y},h={x:Number.NaN,y:Number.NaN},e=[],n=0;n<t.grids.length;n++){var r=t.grids[n];if(e.push(r.name),r.isNull){h=a;break}if(null!==r.grid){var o=r.grid.subgrids[0],l=(Math.abs(o.del[1])+Math.abs(o.del[0]))/1e4,u=o.ll[0]-l,c=o.ll[1]-l,M=o.ll[0]+(o.lim[0]-1)*o.del[0]+l,l=o.ll[1]+(o.lim[1]-1)*o.del[1]+l;if(!(a.y<c||a.x<u||l<a.y||M<a.x||(h=function(t,s,i){var a={x:Number.NaN,y:Number.NaN};if(isNaN(t.x))return a;var h={x:t.x,y:t.y};h.x-=i.ll[0],h.y-=i.ll[1],h.x=dt(h.x-Math.PI)+Math.PI;var e=x(h,i);if(s){if(isNaN(e.x))return a;e.x=h.x-e.x,e.y=h.y-e.y;var n,r=9;do{if(n=x(e,i),isNaN(n.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}}while(n={x:h.x-(n.x+e.x),y:h.y-(n.y+e.y)},e.x+=n.x,e.y+=n.y,r--&&1e-12<Math.abs(n.x)&&1e-12<Math.abs(n.y));if(r<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=dt(e.x+i.ll[0]),a.y=e.y+i.ll[1]}else isNaN(e.x)||(a.x=t.x+e.x,a.y=t.y+e.y);return a}(a,s,o),isNaN(h.x))))break}else if(r.mandatory)return console.log("Unable to find mandatory grid '"+r.name+"'"),-1}return isNaN(h.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*H+" "+a.y*H+" tried: '"+e+"'"),-1):(i.x=-h.x,i.y=h.y,0)}function x(t,s){var i={x:t.x/s.del[0],y:t.y/s.del[1]},a=Math.floor(i.x),h=Math.floor(i.y),e=i.x-+a,n=i.y-+h,r={x:Number.NaN,y:Number.NaN};if(a<0||a>=s.lim[0])return r;if(h<0||h>=s.lim[1])return r;var o=h*s.lim[0]+a,l=s.cvs[o][0],u=s.cvs[o][1],c=s.cvs[++o][0],M=s.cvs[o][1];o+=s.lim[0];var f=s.cvs[o][0],t=s.cvs[o][1],i=s.cvs[--o][0],h=s.cvs[o][1],a=e*n,s=e*(1-n),o=(1-e)*(1-n),n=(1-e)*n;return r.x=o*l+s*c+n*i+a*f,r.y=o*u+s*M+n*h+a*t,r}function i(t){if("function"==typeof Number.isFinite){if(Number.isFinite(t))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof t||t!=t||!isFinite(t))throw new TypeError("coordinates must be finite numbers")}function b(t,s,i,a){var h,e;if(Array.isArray(i)&&(i=Ct(i)),St(i),t.datum&&s.datum&&(e=s,((h=t).datum.datum_type===G||h.datum.datum_type===L)&&"WGS84"!==e.datumCode||(e.datum.datum_type===G||e.datum.datum_type===L)&&"WGS84"!==h.datumCode)&&(i=b(t,h=new y("WGS84"),i,a),t=h),a&&"enu"!==t.axis&&(i=Nt(t,!1,i)),"longlat"===t.projName)i={x:i.x*X,y:i.y*X,z:i.z||0};else if(t.to_meter&&(i={x:i.x*t.to_meter,y:i.y*t.to_meter,z:i.z||0}),!(i=t.inverse(i)))return;if(t.from_greenwich&&(i.x+=t.from_greenwich),i=wt(t.datum,s.datum,i))return s.from_greenwich&&(i={x:i.x-s.from_greenwich,y:i.y,z:i.z||0}),"longlat"===s.projName?i={x:i.x*H,y:i.y*H,z:i.z||0}:(i=s.forward(i),s.to_meter&&(i={x:i.x/s.to_meter,y:i.y/s.to_meter,z:i.z||0})),a&&"enu"!==s.axis?Nt(s,!0,i):i}function v(s,i,a,t){var h,e;return Array.isArray(a)?(h=b(s,i,a,t)||{x:NaN,y:NaN},2<a.length?void 0!==s.name&&"geocent"===s.name||void 0!==i.name&&"geocent"===i.name?("number"==typeof h.z?[h.x,h.y,h.z]:[h.x,h.y,a[2]]).concat(a.splice(3)):[h.x,h.y].concat(a.splice(2)):[h.x,h.y]):(e=b(s,i,a,t),2===(t=Object.keys(a)).length||t.forEach(function(t){if(void 0!==s.name&&"geocent"===s.name||void 0!==i.name&&"geocent"===i.name){if("x"===t||"y"===t||"z"===t)return}else if("x"===t||"y"===t)return;e[t]=a[t]}),e)}function w(t){return t instanceof y?t:t.oProj||y(t)}function N(i,a,t){i=w(i);var s=!1;return void 0===a?(a=i,i=Pt,s=!0):void 0===a.x&&!Array.isArray(a)||(t=a,a=i,i=Pt,s=!0),a=w(a),t?v(i,a,t):(t={forward:function(t,s){return v(i,a,t,s)},inverse:function(t,s){return v(a,i,t,s)}},s&&(t.oProj=a),t)}function C(t,s){return s=s||5,i=function(t){var s,i,a=t.lat,h=t.lon,e=P(a),n=P(h);i=Math.floor((h+180)/6)+1,180===h&&(i=60),56<=a&&a<64&&3<=h&&h<12&&(i=32),72<=a&&a<84&&(0<=h&&h<9?i=31:9<=h&&h<21?i=33:21<=h&&h<33?i=35:33<=h&&h<42&&(i=37)),r=P(6*(i-1)-180+3),s=6378137/Math.sqrt(1-.00669438*Math.sin(e)*Math.sin(e)),t=Math.tan(e)*Math.tan(e),h=.006739496752268451*Math.cos(e)*Math.cos(e);var r=.9996*s*((n=Math.cos(e)*(n-r))+(1-t+h)*n*n*n/6+(5-18*t+t*t+72*h-.39089081163157013)*n*n*n*n*n/120)+5e5,n=.9996*(6378137*(.9983242984503243*e-.002514607064228144*Math.sin(2*e)+2639046602129982e-21*Math.sin(4*e)-3.418046101696858e-9*Math.sin(6*e))+s*Math.tan(e)*(n*n/2+(5-t+9*h+4*h*h)*n*n*n*n/24+(61-58*t+t*t+600*h-2.2240339282485886)*n*n*n*n*n*n/720));return a<0&&(n+=1e7),{northing:Math.round(n),easting:Math.round(r),zoneNumber:i,zoneLetter:function(t){var s="Z";return t<=84&&72<=t?s="X":t<72&&64<=t?s="W":t<64&&56<=t?s="V":t<56&&48<=t?s="U":t<48&&40<=t?s="T":t<40&&32<=t?s="S":t<32&&24<=t?s="R":t<24&&16<=t?s="Q":t<16&&8<=t?s="P":t<8&&0<=t?s="N":t<0&&-8<=t?s="M":t<-8&&-16<=t?s="L":t<-16&&-24<=t?s="K":t<-24&&-32<=t?s="J":t<-32&&-40<=t?s="H":t<-40&&-48<=t?s="G":t<-48&&-56<=t?s="F":t<-56&&-64<=t?s="E":t<-64&&-72<=t?s="D":t<-72&&-80<=t&&(s="C"),s}(a)}}({lat:t[1],lon:t[0]}),a=s,t="00000"+i.easting,s="00000"+i.northing,i.zoneNumber+i.zoneLetter+function(t,s,i){i=I(i);return function(t,s,i){var a=i-1,h=kt.charCodeAt(a),i=It.charCodeAt(a),a=h+t-1,t=i+s,s=!1;return Gt<a&&(a=a-Gt+qt-1,s=!0),(a===At||h<At&&At<a||(At<a||h<At)&&s)&&a++,(a===Ot||h<Ot&&Ot<a||(Ot<a||h<Ot)&&s)&&++a===At&&a++,Gt<a&&(a=a-Gt+qt-1),s=jt<t&&(t=t-jt+qt-1,!0),(t===At||i<At&&At<t||(At<t||i<At)&&s)&&t++,(t===Ot||i<Ot&&Ot<t||(Ot<t||i<Ot)&&s)&&++t===At&&t++,jt<t&&(t=t-jt+qt-1),String.fromCharCode(a)+String.fromCharCode(t)}(Math.floor(t/1e5),Math.floor(s/1e5)%20,i)}(i.easting,i.northing,i.zoneNumber)+t.substr(t.length-5,a)+s.substr(s.length-5,a);var i,a}function S(t){t=k(q(t.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat]:[(t.left+t.right)/2,(t.top+t.bottom)/2]}function P(t){return t*(Math.PI/180)}function E(t){return t/Math.PI*180}function k(t){var s=t.northing,i=t.easting,a=t.zoneLetter,h=t.zoneNumber;if(h<0||60<h)return null;var e=(1-Math.sqrt(.99330562))/(1+Math.sqrt(.99330562)),n=i-5e5,r=s;a<"N"&&(r-=1e7);i=6*(h-1)-180+3,a=(s=r/.9996/6367449.145945056)+(3*e/2-27*e*e*e/32)*Math.sin(2*s)+(21*e*e/16-55*e*e*e*e/32)*Math.sin(4*s)+151*e*e*e/96*Math.sin(6*s),h=6378137/Math.sqrt(1-.00669438*Math.sin(a)*Math.sin(a)),r=Math.tan(a)*Math.tan(a),e=.006739496752268451*Math.cos(a)*Math.cos(a),s=6335439.32722994/Math.pow(1-.00669438*Math.sin(a)*Math.sin(a),1.5),n/=.9996*h,s=E(s=a-h*Math.tan(a)/s*(n*n/2-(5+3*r+10*e-4*e*e-.06065547077041606)*n*n*n*n/24+(61+90*r+298*e+45*r*r-1.6983531815716497-3*e*e)*n*n*n*n*n*n/720)),a=i+E(a=(n-(1+2*r+e)*n*n*n/6+(5-2*e+28*r-3*e*e+.05391597401814761+24*r*r)*n*n*n*n*n/120)/Math.cos(a));return t.accuracy?{top:(t=k({northing:t.northing+t.accuracy,easting:t.easting+t.accuracy,zoneLetter:t.zoneLetter,zoneNumber:t.zoneNumber})).lat,right:t.lon,bottom:s,left:a}:{lat:s,lon:a}}function I(t){t%=Et;return t=0===t?Et:t}function q(t){if(t&&0===t.length)throw"MGRSPoint coverting from nothing";for(var s,i=t.length,a=null,h="",e=0;!/[A-Z]/.test(s=t.charAt(e));){if(2<=e)throw"MGRSPoint bad conversion from: "+t;h+=s,e++}var n=parseInt(h,10);if(0===e||i<e+3)throw"MGRSPoint bad conversion from: "+t;var r=t.charAt(e++);if(r<="A"||"B"===r||"Y"===r||"Z"<=r||"I"===r||"O"===r)throw"MGRSPoint zone letter "+r+" not handled: "+t;for(var a=t.substring(e,e+=2),o=I(n),l=function(t,s){for(var i=kt.charCodeAt(s-1),a=1e5,h=!1;i!==t.charCodeAt(0);){if(++i===At&&i++,i===Ot&&i++,Gt<i){if(h)throw"Bad character: "+t;i=qt,h=!0}a+=1e5}return a}(a.charAt(0),o),u=function(t,s){if("V"<t)throw"MGRSPoint given invalid Northing "+t;for(var i=It.charCodeAt(s-1),a=0,h=!1;i!==t.charCodeAt(0);){if(++i===At&&i++,i===Ot&&i++,jt<i){if(h)throw"Bad character: "+t;i=qt,h=!0}a+=1e5}return a}(a.charAt(1),o);u<function(t){var s;switch(t){case"C":s=11e5;break;case"D":s=2e6;break;case"E":s=28e5;break;case"F":s=37e5;break;case"G":s=46e5;break;case"H":s=55e5;break;case"J":s=64e5;break;case"K":s=73e5;break;case"L":s=82e5;break;case"M":s=91e5;break;case"N":s=0;break;case"P":s=8e5;break;case"Q":s=17e5;break;case"R":s=26e5;break;case"S":s=35e5;break;case"T":s=44e5;break;case"U":s=53e5;break;case"V":s=62e5;break;case"W":s=7e6;break;case"X":s=79e5;break;default:s=-1}if(0<=s)return s;throw"Invalid zone letter: "+t}(r);)u+=2e6;var c=i-e;if(c%2!=0)throw"MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters"+t;var M,a=c/2,o=0,i=0;return 0<a&&(M=1e5/Math.pow(10,a),c=t.substring(e,e+a),o=parseFloat(c)*M,a=t.substring(e+a),i=parseFloat(a)*M),{easting:o+l,northing:i+u,zoneLetter:r,zoneNumber:n,accuracy:M}}function A(t,s,i){if(!(this instanceof A))return new A(t,s,i);var a;Array.isArray(t)?(this.x=t[0],this.y=t[1],this.z=t[2]||0):"object"==typeof t?(this.x=t.x,this.y=t.y,this.z=t.z||0):"string"==typeof t&&void 0===s?(a=t.split(","),this.x=parseFloat(a[0],10),this.y=parseFloat(a[1],10),this.z=parseFloat(a[2],10)||0):(this.x=t,this.y=s,this.z=i||0),console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}function O(t,s,i,a){var h;return t<W?(a.value=Ls,h=0):(h=Math.atan2(s,i),Math.abs(h)<=J?a.value=Ls:J<h&&h<=D+J?(a.value=Rs,h-=D):D+J<h||h<=-(D+J)?(a.value=zs,h=0<=h?h-V:h+V):(a.value=Bs,h+=D)),h}function j(t,s){s=t+s;return s<-V?s+=K:+V<s&&(s-=K),s}var G=1,L=2,R=3,z=4,B=5,T=484813681109536e-20,D=Math.PI/2,F=.16666666666666666,U=.04722222222222222,Q=.022156084656084655,W=1e-10,X=.017453292519943295,H=57.29577951308232,J=Math.PI/4,K=2*Math.PI,V=3.14159265359,Z={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667},Y={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}},$=/[\s_\-\/\(\)]/g,tt=function(t){var s,i,a,h={},e=t.split("+").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,s){s=s.split("=");return s.push(!0),t[s[0].toLowerCase()]=s[1],t},{}),n={proj:"projName",datum:"datumCode",rf:function(t){h.rf=parseFloat(t)},lat_0:function(t){h.lat0=t*X},lat_1:function(t){h.lat1=t*X},lat_2:function(t){h.lat2=t*X},lat_ts:function(t){h.lat_ts=t*X},lon_0:function(t){h.long0=t*X},lon_1:function(t){h.long1=t*X},lon_2:function(t){h.long2=t*X},alpha:function(t){h.alpha=parseFloat(t)*X},gamma:function(t){h.rectified_grid_angle=parseFloat(t)},lonc:function(t){h.longc=t*X},x_0:function(t){h.x0=parseFloat(t)},y_0:function(t){h.y0=parseFloat(t)},k_0:function(t){h.k0=parseFloat(t)},k:function(t){h.k0=parseFloat(t)},a:function(t){h.a=parseFloat(t)},b:function(t){h.b=parseFloat(t)},r_a:function(){h.R_A=!0},zone:function(t){h.zone=parseInt(t,10)},south:function(){h.utmSouth=!0},towgs84:function(t){h.datum_params=t.split(",").map(function(t){return parseFloat(t)})},to_meter:function(t){h.to_meter=parseFloat(t)},units:function(t){h.units=t;t=d(Y,t);t&&(h.to_meter=t.to_meter)},from_greenwich:function(t){h.from_greenwich=t*X},pm:function(t){var s=d(Z,t);h.from_greenwich=(s||parseFloat(t))*X},nadgrids:function(t){"@null"===t?h.datumCode="none":h.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(h.axis=t)},approx:function(){h.approx=!0}};for(s in e)i=e[s],s in n?"function"==typeof(a=n[s])?a(i):h[a]=i:h[s]=i;return"string"==typeof h.datumCode&&"WGS84"!==h.datumCode&&(h.datumCode=h.datumCode.toLowerCase()),h},st=/\s/,it=/[A-Za-z]/,at=/[A-Za-z84]/,ht=/[,\]]/,et=/[\d\.E\-\+]/;a.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;st.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},a.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(ht.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},a.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},a.prototype.number=function(t){if(!et.test(t)){if(ht.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},a.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},a.prototype.keyword=function(t){if(at.test(t))this.word+=t;else{if("["===t){var s=[];return s.push(this.word),this.level++,null===this.root?this.root=s:this.currentObject.push(s),this.stack.push(this.currentObject),this.currentObject=s,void(this.state=1)}if(!ht.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},a.prototype.neutral=function(t){if(it.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(et.test(t))return this.word=t,void(this.state=3);if(!ht.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},a.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};var nt=function(t){var s=new a(t).output(),i=s.shift(),t=s.shift();s.unshift(["name",t]),s.unshift(["type",i]);i={};return e(s,i),n(i),i};(Ys=o)("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),Ys("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),Ys("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),Ys.WGS84=Ys["EPSG:4326"],Ys["EPSG:3785"]=Ys["EPSG:3857"],Ys.GOOGLE=Ys["EPSG:3857"],Ys["EPSG:900913"]=Ys["EPSG:3857"],Ys["EPSG:102113"]=Ys["EPSG:3857"];function rt(t,s){var i,a;if(t=t||{},!s)return t;for(a in s)void 0!==(i=s[a])&&(t[a]=i);return t}function ot(t,s,i){return s*=t,i/Math.sqrt(1-s*s)}function lt(t){return t<0?-1:1}function ut(t,s,i){return i*=t,i=Math.pow((1-i)/(1+i),.5*t),Math.tan(.5*(D-s))/i}function ct(t,s){for(var i,a=.5*t,h=D-2*Math.atan(s),e=0;e<=15;e++)if(i=t*Math.sin(h),h+=i=D-2*Math.atan(s*Math.pow((1-i)/(1+i),a))-h,Math.abs(i)<=1e-10)return h;return-9999}var Mt=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"],ft=["3857","900913","3785","102113"],dt=function(t){return Math.abs(t)<=V?t:t-lt(t)*K},pt=[{init:function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=ot(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},forward:function(t){var s,i,a=t.x,h=t.y;return 90<h*H&&h*H<-90&&180<a*H&&a*H<-180||Math.abs(Math.abs(h)-D)<=W?null:(i=this.sphere?(s=this.x0+this.a*this.k0*dt(a-this.long0),this.y0+this.a*this.k0*Math.log(Math.tan(J+.5*h))):(i=Math.sin(h),i=ut(this.e,h,i),s=this.x0+this.a*this.k0*dt(a-this.long0),this.y0-this.a*this.k0*Math.log(i)),t.x=s,t.y=i,t)},inverse:function(t){var s,i=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=D-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{a=Math.exp(-a/(this.a*this.k0));if(-9999===(s=ct(this.e,a)))return null}return i=dt(this.long0+i/(this.a*this.k0)),t.x=i,t.y=s,t},names:["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},{init:function(){},forward:t,inverse:t,names:["longlat","identity"]}],mt={},yt=[],_t={start:function(){pt.forEach(s)},add:s,get:function(t){if(!t)return!1;t=t.toLowerCase();return void 0!==mt[t]&&yt[mt[t]]?yt[mt[t]]:void 0}},gt={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},APL4:{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},clrk58:{a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},CPM:{a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS7:{a:6378135,rf:298.26,ellipseName:"WGS 72"}},xt=gt.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};gt.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};var bt={wgs84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},ch1903:{towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},ggrs87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},nad83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},nad27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},osni52:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},rassadiran:{towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},osgb36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},s_jtsk:{towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},beduaram:{towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},gunung_segara:{towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},rnb72:{towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},vt={};(y.projections=_t).start();function wt(t,s,i){if(r=s,(n=t).datum_type===r.datum_type&&!(n.a!==r.a||5e-11<Math.abs(n.es-r.es))&&(n.datum_type===G?n.datum_params[0]===r.datum_params[0]&&n.datum_params[1]===r.datum_params[1]&&n.datum_params[2]===r.datum_params[2]:n.datum_type!==L||n.datum_params[0]===r.datum_params[0]&&n.datum_params[1]===r.datum_params[1]&&n.datum_params[2]===r.datum_params[2]&&n.datum_params[3]===r.datum_params[3]&&n.datum_params[4]===r.datum_params[4]&&n.datum_params[5]===r.datum_params[5]&&n.datum_params[6]===r.datum_params[6]))return i;if(t.datum_type===B||s.datum_type===B)return i;var a=t.a,h=t.es;if(t.datum_type===R){if(0!==g(t,!1,i))return;a=6378137,h=.0066943799901413165}var e=s.a,n=s.b,r=s.es;return s.datum_type===R&&(e=6378137,n=6356752.314,r=.0066943799901413165),h!==r||a!==e||_(t.datum_type)||_(s.datum_type)?(i=M(i,h,a),_(t.datum_type)&&(i=function(t,s,i){if(s===G)return{x:t.x+i[0],y:t.y+i[1],z:t.z+i[2]};if(s===L){var a=i[0],h=i[1],e=i[2],n=i[3],r=i[4],s=i[5],i=i[6];return{x:i*(t.x-s*t.y+r*t.z)+a,y:i*(s*t.x+t.y-n*t.z)+h,z:i*(-r*t.x+n*t.y+t.z)+e}}}(i,t.datum_type,t.datum_params)),i=f(i=_(s.datum_type)?function(t,s,i){if(s===G)return{x:t.x-i[0],y:t.y-i[1],z:t.z-i[2]};if(s===L){var a=i[0],h=i[1],e=i[2],n=i[3],r=i[4],s=i[5],i=i[6],a=(t.x-a)/i,h=(t.y-h)/i,i=(t.z-e)/i;return{x:a+s*h-r*i,y:-s*a+h+n*i,z:r*a-n*h+i}}}(i,s.datum_type,s.datum_params):i,r,e,n),s.datum_type!==R||0===g(s,!0,i)?i:void 0):i}function Nt(t,s,i){for(var a,h,e=i.x,n=i.y,r=i.z||0,o={},l=0;l<3;l++)if(!s||2!==l||void 0!==i.z)switch(h=0===l?(a=e,-1!=="ew".indexOf(t.axis[l])?"x":"y"):1===l?(a=n,-1!=="ns".indexOf(t.axis[l])?"y":"x"):(a=r,"z"),t.axis[l]){case"e":o[h]=a;break;case"w":o[h]=-a;break;case"n":o[h]=a;break;case"s":o[h]=-a;break;case"u":void 0!==i[h]&&(o.z=a);break;case"d":void 0!==i[h]&&(o.z=-a);break;default:return null}return o}function Ct(t){var s={x:t[0],y:t[1]};return 2<t.length&&(s.z=t[2]),3<t.length&&(s.m=t[3]),s}function St(t){i(t.x),i(t.y)}var Pt=y("WGS84"),Et=6,kt="AJSAJS",It="AFAFAF",qt=65,At=73,Ot=79,jt=86,Gt=90,Lt={forward:C,inverse:function(t){t=k(q(t.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat,t.lon,t.lat]:[t.left,t.bottom,t.right,t.top]},toPoint:S};A.fromMGRS=function(t){return new A(S(t))},A.prototype.toMGRS=function(t){return C([this.x,this.y],t)};function Rt(t){var s=[];s[0]=1-t*(.25+t*(.046875+t*(.01953125+t*as))),s[1]=t*(.75-t*(.046875+t*(.01953125+t*as)));var i=t*t;return s[2]=i*(.46875-t*(.013020833333333334+.007120768229166667*t)),s[3]=(i*=t)*(.3645833333333333-.005696614583333333*t),s[4]=i*t*.3076171875,s}function zt(t,s,i,a){return a[0]*t-(i*=s)*(a[1]+(s*=s)*(a[2]+s*(a[3]+s*a[4])))}function Bt(t,s,i){for(var a=1/(1-s),h=t,e=20;e;--e){var n=Math.sin(h),r=1-s*n*n;if(h-=r=(zt(h,n,Math.cos(h),i)-t)*(r*Math.sqrt(r))*a,Math.abs(r)<W)return h}return h}function Tt(t){return((t=Math.exp(t))-1/t)/2}function Dt(t,s){t=Math.abs(t),s=Math.abs(s);var i=Math.max(t,s),s=Math.min(t,s)/(i||1);return i*Math.sqrt(1+Math.pow(s,2))}function Ft(t){var s,i,a,h=Math.abs(t);return s=h*(1+h/(Dt(1,h)+1)),h=0==(a=(i=1+s)-1)?s:s*Math.log(i)/a,t<0?-h:h}function Ut(t,s){for(var i,a=2*Math.cos(2*s),h=t.length-1,e=t[h],n=0;0<=--h;)i=a*e-n+t[h],n=e,e=i;return s+i*Math.sin(2*s)}function Qt(t,s,i){for(var a,h,e=Math.sin(s),n=Math.cos(s),s=Tt(i),i=function(t){t=Math.exp(t);return(t+1/t)/2}(i),r=2*n*i,o=-2*e*s,l=t.length-1,u=t[l],c=0,M=0,f=0;0<=--l;)a=M,h=c,u=r*(M=u)-a-o*(c=f)+t[l],f=o*M-h+r*c;return[(r=e*i)*u-(o=n*s)*f,r*f+o*u]}function Wt(t,s){return Math.pow((1-t)/(1+t),s)}function Xt(t,s,i,a,h){return t*h-s*Math.sin(2*h)+i*Math.sin(4*h)-a*Math.sin(6*h)}function Ht(t){return 1-.25*t*(1+t/16*(3+1.25*t))}function Jt(t){return.375*t*(1+.25*t*(1+.46875*t))}function Kt(t){return.05859375*t*t*(1+.75*t)}function Vt(t){return t*t*t*(35/3072)}function Zt(t,s,i){return i*=s,t/Math.sqrt(1-i*i)}function Yt(t){return Math.abs(t)<D?t:t-lt(t)*Math.PI}function $t(t,s,i,a,h){for(var e,n=t/s,r=0;r<15;r++)if(n+=e=(t-(s*n-i*Math.sin(2*n)+a*Math.sin(4*n)-h*Math.sin(6*n)))/(s-2*i*Math.cos(2*n)+4*a*Math.cos(4*n)-6*h*Math.cos(6*n)),Math.abs(e)<=1e-10)return n;return NaN}function ts(t,s){var i;return 1e-7<t?(1-t*t)*(s/(1-(i=t*s)*i)-.5/t*Math.log((1-i)/(1+i))):2*s}function ss(t){return 1<Math.abs(t)&&(t=1<t?1:-1),Math.asin(t)}function is(t,s){return t[0]+s*(t[1]+s*(t[2]+s*t[3]))}var as=.01068115234375,hs={init:function(){this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.es&&(this.en=Rt(this.es),this.ml0=zt(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))},forward:function(t){var s=t.x,i=t.y,a=dt(s-this.long0),h=Math.sin(i),e=Math.cos(i);if(this.es){var n=e*a,r=Math.pow(n,2),o=this.ep2*Math.pow(e,2),l=Math.pow(o,2),s=Math.abs(e)>W?Math.tan(i):0,u=Math.pow(s,2),c=Math.pow(u,2),M=1-this.es*Math.pow(h,2);n/=Math.sqrt(M);s=zt(i,h,e,this.en),M=this.a*(this.k0*n*(1+r/6*(1-u+o+r/20*(5-18*u+c+14*o-58*u*o+r/42*(61+179*c-c*u-479*u)))))+this.x0,c=this.a*(this.k0*(s-this.ml0+h*a*n/2*(1+r/12*(5-u+9*o+4*l+r/30*(61+c-58*u+270*o-330*u*o+r/56*(1385+543*c-c*u-3111*u))))))+this.y0}else{u=e*Math.sin(a);if(Math.abs(Math.abs(u)-1)<W)return 93;if(M=.5*this.a*this.k0*Math.log((1+u)/(1-u))+this.x0,c=e*Math.cos(a)/Math.sqrt(1-Math.pow(u,2)),1<=(u=Math.abs(c))){if(W<u-1)return 93;c=0}else c=Math.acos(c);c=this.a*this.k0*((c=i<0?-c:c)-this.lat0)+this.y0}return t.x=M,t.y=c,t},inverse:function(t){var s,i,a,h,e,n,r,o,l,u,c=(t.x-this.x0)*(1/this.a),M=(t.y-this.y0)*(1/this.a);return u=this.es?(n=this.ml0+M/this.k0,s=Bt(n,this.es,this.en),Math.abs(s)<D?(r=Math.sin(s),i=Math.cos(s),o=Math.abs(i)>W?Math.tan(s):0,a=this.ep2*Math.pow(i,2),l=Math.pow(a,2),h=Math.pow(o,2),e=Math.pow(h,2),n=1-this.es*Math.pow(r,2),r=c*Math.sqrt(n)/this.k0,l=s-(n*=o)*(o=Math.pow(r,2))/(1-this.es)*.5*(1-o/12*(5+3*h-9*a*h+a-4*l-o/30*(61+90*h-252*a*h+45*e+46*a-o/56*(1385+3633*h+4095*e+1574*e*h)))),dt(this.long0+r*(1-o/6*(1+2*h+a-o/20*(5+28*h+24*e+8*a*h+6*a-o/42*(61+662*h+1320*e+720*e*h))))/i)):(l=D*lt(M),0)):(c=.5*((u=Math.exp(c/this.k0))-1/u),u=this.lat0+M/this.k0,u=Math.cos(u),n=Math.sqrt((1-Math.pow(u,2))/(1+Math.pow(c,2))),l=Math.asin(n),M<0&&(l=-l),0==c&&0===u?0:dt(Math.atan2(c,u)+this.long0)),t.x=u,t.y=l,t},names:["Fast_Transverse_Mercator","Fast Transverse Mercator"]},es={init:function(){if(!this.approx&&(isNaN(this.es)||this.es<=0))throw new Error('Incorrect elliptical usage. Try using the +approx option in the proj string, or PROJECTION["Fast_Transverse_Mercator"] in the WKT.');this.approx&&(hs.init.apply(this),this.forward=hs.forward,this.inverse=hs.inverse),this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var t=this.es/(1+Math.sqrt(1-this.es)),s=t/(2-t),t=s;this.cgb[0]=s*(2+s*(-2/3+s*(s*(116/45+s*(26/45+-2854/675*s))-2))),this.cbg[0]=s*(s*(2/3+s*(4/3+s*(-82/45+s*(32/45+4642/4725*s))))-2),this.cgb[1]=(t*=s)*(7/3+s*(s*(-227/45+s*(2704/315+2323/945*s))-1.6)),this.cbg[1]=t*(5/3+s*(-16/15+s*(-13/9+s*(904/315+-1522/945*s)))),this.cgb[2]=(t*=s)*(56/15+s*(-136/35+s*(-1262/105+73814/2835*s))),this.cbg[2]=t*(-26/15+s*(34/21+s*(1.6+-12686/2835*s))),this.cgb[3]=(t*=s)*(4279/630+s*(-332/35+-399572/14175*s)),this.cbg[3]=t*(1237/630+s*(-24832/14175*s-2.4)),this.cgb[4]=(t*=s)*(4174/315+-144838/6237*s),this.cbg[4]=t*(-734/315+109598/31185*s),this.cgb[5]=601676/22275*(t*=s),this.cbg[5]=444337/155925*t,t=Math.pow(s,2),this.Qn=this.k0/(1+s)*(1+t*(.25+t*(1/64+t/256))),this.utg[0]=s*(s*(2/3+s*(-37/96+s*(1/360+s*(81/512+-96199/604800*s))))-.5),this.gtu[0]=s*(.5+s*(-2/3+s*(5/16+s*(41/180+s*(-127/288+7891/37800*s))))),this.utg[1]=t*(-1/48+s*(-1/15+s*(437/1440+s*(-46/105+1118711/3870720*s)))),this.gtu[1]=t*(13/48+s*(s*(557/1440+s*(281/630+-1983433/1935360*s))-.6)),this.utg[2]=(t*=s)*(-17/480+s*(37/840+s*(209/4480+-5569/90720*s))),this.gtu[2]=t*(61/240+s*(-103/140+s*(15061/26880+167603/181440*s))),this.utg[3]=(t*=s)*(-4397/161280+s*(11/504+830251/7257600*s)),this.gtu[3]=t*(49561/161280+s*(-179/168+6601661/7257600*s)),this.utg[4]=(t*=s)*(-4583/161280+108847/3991680*s),this.gtu[4]=t*(34729/80640+-3418889/1995840*s),this.utg[5]=-.03233083094085698*(t*=s),this.gtu[5]=.6650675310896665*t;t=Ut(this.cbg,this.lat0);this.Zb=-this.Qn*(t+function(t,s){for(var i,a=2*Math.cos(s),h=t.length-1,e=t[h],n=0;0<=--h;)i=a*e-n+t[h],n=e,e=i;return Math.sin(s)*i}(this.gtu,2*t))},forward:function(t){var s=dt(t.x-this.long0),i=t.y,i=Ut(this.cbg,i),a=Math.sin(i),h=Math.cos(i),e=Math.sin(s),n=Math.cos(s);i=Math.atan2(a,n*h),s=Math.atan2(e*h,Dt(a,h*n));var r,s=Ft(Math.tan(s)),n=Qt(this.gtu,2*i,2*s);return i+=n[0],s+=n[1],i=Math.abs(s)<=2.623395162778?(r=this.a*(this.Qn*s)+this.x0,this.a*(this.Qn*i+this.Zb)+this.y0):r=1/0,t.x=r,t.y=i,t},inverse:function(t){var s,i,a,h,e=(t.x-this.x0)*(1/this.a),n=(t.y-this.y0)*(1/this.a);return n=(n-this.Zb)/this.Qn,e/=this.Qn,n=Math.abs(e)<=2.623395162778?(n+=(h=Qt(this.utg,2*n,2*e))[0],e+=h[1],e=Math.atan(Tt(e)),s=Math.sin(n),i=Math.cos(n),a=Math.sin(e),h=Math.cos(e),n=Math.atan2(s*h,Dt(a,h*i)),e=Math.atan2(a,h*i),i=dt(e+this.long0),Ut(this.cgb,n)):i=1/0,t.x=i,t.y=n,t},names:["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc","Transverse_Mercator","Transverse Mercator","tmerc"]},ns={init:function(){var t=function(t,s){if(void 0===t){if((t=Math.floor(30*(dt(s)+Math.PI)/Math.PI)+1)<0)return 0;if(60<t)return 60}return t}(this.zone,this.long0);if(void 0===t)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(t)-183)*X,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,es.init.apply(this),this.forward=es.forward,this.inverse=es.inverse},names:["Universal Transverse Mercator System","utm"],dependsOn:"etmerc"},rs={init:function(){var t=Math.sin(this.lat0),s=Math.cos(this.lat0);s*=s,this.rc=Math.sqrt(1-this.es)/(1-this.es*t*t),this.C=Math.sqrt(1+this.es*s*s/(1-this.es)),this.phic0=Math.asin(t/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+J)/(Math.pow(Math.tan(.5*this.lat0+J),this.C)*Wt(this.e*t,this.ratexp))},forward:function(t){var s=t.x,i=t.y;return t.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*i+J),this.C)*Wt(this.e*Math.sin(i),this.ratexp))-D,t.x=this.C*s,t},inverse:function(t){for(var s=t.x/this.C,i=t.y,a=Math.pow(Math.tan(.5*i+J)/this.K,1/this.C),h=20;0<h&&(i=2*Math.atan(a*Wt(this.e*Math.sin(t.y),-.5*this.e))-D,!(Math.abs(i-t.y)<1e-14));--h)t.y=i;return h?(t.x=s,t.y=i,t):null},names:["gauss"]},os={init:function(){rs.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))},forward:function(t){var s,i,a,h;return t.x=dt(t.x-this.long0),rs.forward.apply(this,[t]),s=Math.sin(t.y),i=Math.cos(t.y),a=Math.cos(t.x),h=this.k0*this.R2/(1+this.sinc0*s+this.cosc0*i*a),t.x=h*i*Math.sin(t.x),t.y=h*(this.cosc0*s-this.sinc0*i*a),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t},inverse:function(t){var s,i,a,h;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,h=(s=Math.sqrt(t.x*t.x+t.y*t.y))?(a=2*Math.atan2(s,this.R2),h=Math.sin(a),i=Math.cos(a),a=Math.asin(i*this.sinc0+t.y*h*this.cosc0/s),Math.atan2(t.x*h,s*this.cosc0*i-t.y*this.sinc0*h)):(a=this.phic0,0),t.x=h,t.y=a,rs.inverse.apply(this,[t]),t.x=dt(t.x+this.long0),t},names:["Stereographic_North_Pole","Oblique_Stereographic","Polar_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"]},ls={init:function(){this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=W&&(this.k0=.5*(1+lt(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=W&&(0<this.lat0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=W&&(this.k0=.5*this.cons*ot(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/ut(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=ot(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-D,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))},forward:function(t){var s,i,a=t.x,h=t.y,e=Math.sin(h),n=Math.cos(h),r=dt(a-this.long0);return Math.abs(Math.abs(a-this.long0)-Math.PI)<=W&&Math.abs(h+this.lat0)<=W?(t.x=NaN,t.y=NaN):this.sphere?(s=2*this.k0/(1+this.sinlat0*e+this.coslat0*n*Math.cos(r)),t.x=this.a*s*n*Math.sin(r)+this.x0,t.y=this.a*s*(this.coslat0*e-this.sinlat0*n*Math.cos(r))+this.y0):(i=2*Math.atan(this.ssfn_(h,e,this.e))-D,n=Math.cos(i),i=Math.sin(i),Math.abs(this.coslat0)<=W?(e=ut(this.e,h*this.con,this.con*e),e=2*this.a*this.k0*e/this.cons,t.x=this.x0+e*Math.sin(a-this.long0),t.y=this.y0-this.con*e*Math.cos(a-this.long0)):(Math.abs(this.sinlat0)<W?(s=2*this.a*this.k0/(1+n*Math.cos(r)),t.y=s*i):(s=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*i+this.cosX0*n*Math.cos(r))),t.y=s*(this.cosX0*i-this.sinX0*n*Math.cos(r))+this.y0),t.x=s*n*Math.sin(r)+this.x0)),t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var s,i,a=Math.sqrt(t.x*t.x+t.y*t.y);if(this.sphere){var h=2*Math.atan(a/(2*this.a*this.k0)),e=this.long0,n=this.lat0;return a<=W||(n=Math.asin(Math.cos(h)*this.sinlat0+t.y*Math.sin(h)*this.coslat0/a),e=dt(Math.abs(this.coslat0)<W?0<this.lat0?this.long0+Math.atan2(t.x,-1*t.y):this.long0+Math.atan2(t.x,t.y):this.long0+Math.atan2(t.x*Math.sin(h),a*this.coslat0*Math.cos(h)-t.y*this.sinlat0*Math.sin(h)))),t.x=e,t.y=n,t}if(Math.abs(this.coslat0)<=W){if(a<=W)return n=this.lat0,e=this.long0,t.x=e,t.y=n,t;t.x*=this.con,t.y*=this.con,s=a*this.cons/(2*this.a*this.k0),n=this.con*ct(this.e,s),e=this.con*dt(this.con*this.long0+Math.atan2(t.x,-1*t.y))}else s=2*Math.atan(a*this.cosX0/(2*this.a*this.k0*this.ms1)),e=this.long0,a<=W?i=this.X0:(i=Math.asin(Math.cos(s)*this.sinX0+t.y*Math.sin(s)*this.cosX0/a),e=dt(this.long0+Math.atan2(t.x*Math.sin(s),a*this.cosX0*Math.cos(s)-t.y*this.sinX0*Math.sin(s)))),n=-1*ct(this.e,Math.tan(.5*(D+i)));return t.x=e,t.y=n,t},names:["stere","Stereographic_South_Pole","Polar Stereographic (variant B)"],ssfn_:function(t,s,i){return s*=i,Math.tan(.5*(D+t))*Math.pow((1-s)/(1+s),.5*i)}},us={init:function(){var t=this.lat0;this.lambda0=this.long0;var s=Math.sin(t),i=this.a,a=1/this.rf,h=2*a-Math.pow(a,2),a=this.e=Math.sqrt(h);this.R=this.k0*i*Math.sqrt(1-h)/(1-h*Math.pow(s,2)),this.alpha=Math.sqrt(1+h/(1-h)*Math.pow(Math.cos(t),4)),this.b0=Math.asin(s/this.alpha);h=Math.log(Math.tan(Math.PI/4+this.b0/2)),t=Math.log(Math.tan(Math.PI/4+t/2)),s=Math.log((1+a*s)/(1-a*s));this.K=h-this.alpha*t+this.alpha*a/2*s},forward:function(t){var s=Math.log(Math.tan(Math.PI/4-t.y/2)),i=this.e/2*Math.log((1+this.e*Math.sin(t.y))/(1-this.e*Math.sin(t.y))),a=-this.alpha*(s+i)+this.K,s=2*(Math.atan(Math.exp(a))-Math.PI/4),i=this.alpha*(t.x-this.lambda0),a=Math.atan(Math.sin(i)/(Math.sin(this.b0)*Math.tan(s)+Math.cos(this.b0)*Math.cos(i))),i=Math.asin(Math.cos(this.b0)*Math.sin(s)-Math.sin(this.b0)*Math.cos(s)*Math.cos(i));return t.y=this.R/2*Math.log((1+Math.sin(i))/(1-Math.sin(i)))+this.y0,t.x=this.R*a+this.x0,t},inverse:function(t){for(var s,i=t.x-this.x0,a=t.y-this.y0,i=i/this.R,a=2*(Math.atan(Math.exp(a/this.R))-Math.PI/4),h=Math.asin(Math.cos(this.b0)*Math.sin(a)+Math.sin(this.b0)*Math.cos(a)*Math.cos(i)),a=Math.atan(Math.sin(i)/(Math.cos(this.b0)*Math.cos(i)-Math.sin(this.b0)*Math.tan(a))),a=this.lambda0+a/this.alpha,e=h,n=-1e3,r=0;1e-7<Math.abs(e-n);){if(20<++r)return;s=1/this.alpha*(Math.log(Math.tan(Math.PI/4+h/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(e))/2)),n=e,e=2*Math.atan(Math.exp(s))-Math.PI/2}return t.x=a,t.y=e,t},names:["somerc"]},cs=1e-7,Ms={init:function(){var t,s,i,a,h,e=0,n=0,r=0,o=0,l=0,u=0,c=0;this.no_off=(h="object"==typeof(p=this).PROJECTION?Object.keys(p.PROJECTION)[0]:p.PROJECTION,"no_uoff"in p||"no_off"in p||-1!==["Hotine_Oblique_Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin"].indexOf(h)),this.no_rot="no_rot"in this;var M=!1;"alpha"in this&&(M=!0);var f=!1;if("rectified_grid_angle"in this&&(f=!0),M&&(c=this.alpha),f&&(e=this.rectified_grid_angle*X),M||f)n=this.longc;else if(r=this.long1,l=this.lat1,o=this.long2,u=this.lat2,Math.abs(l-u)<=cs||(t=Math.abs(l))<=cs||Math.abs(t-D)<=cs||Math.abs(Math.abs(this.lat0)-D)<=cs||Math.abs(Math.abs(u)-D)<=cs)throw new Error;var d=1-this.es,p=Math.sqrt(d);Math.abs(this.lat0)>W?(h=Math.sin(this.lat0),i=Math.cos(this.lat0),t=1-this.es*h*h,this.B=i*i,this.B=Math.sqrt(1+this.es*this.B*this.B/d),this.A=this.B*this.k0*p/t,(i=(s=this.B*p/(i*Math.sqrt(t)))*s-1)<=0?i=0:(i=Math.sqrt(i),this.lat0<0&&(i=-i)),this.E=i+=s,this.E*=Math.pow(ut(this.e,this.lat0,h),this.B)):(this.B=1/p,this.A=this.k0,this.E=s=i=1),M||f?(M?(a=Math.asin(Math.sin(c)/s),f||(e=c)):(a=e,c=Math.asin(s*Math.sin(a))),this.lam0=n-Math.asin(.5*(i-1/i)*Math.tan(a))/this.B):(f=Math.pow(ut(this.e,l,Math.sin(l)),this.B),n=Math.pow(ut(this.e,u,Math.sin(u)),this.B),i=this.E/f,l=(n-f)/(n+f),u=((u=this.E*this.E)-n*f)/(u+n*f),(t=r-o)<-Math.pi?o-=K:t>Math.pi&&(o+=K),this.lam0=dt(.5*(r+o)-Math.atan(u*Math.tan(.5*this.B*(r-o))/l)/this.B),a=Math.atan(2*Math.sin(this.B*dt(r-this.lam0))/(i-1/i)),e=c=Math.asin(s*Math.sin(a))),this.singam=Math.sin(a),this.cosgam=Math.cos(a),this.sinrot=Math.sin(e),this.cosrot=Math.cos(e),this.rB=1/this.B,this.ArB=this.A*this.rB,this.BrA=1/this.ArB,this.no_off?this.u_0=0:(this.u_0=Math.abs(this.ArB*Math.atan(Math.sqrt(s*s-1)/Math.cos(c))),this.lat0<0&&(this.u_0=-this.u_0)),i=.5*a,this.v_pole_n=this.ArB*Math.log(Math.tan(J-i)),this.v_pole_s=this.ArB*Math.log(Math.tan(J+i))},forward:function(t){var s,i,a,h,e={};if(t.x=t.x-this.lam0,Math.abs(Math.abs(t.y)-D)>W){if(s=.5*((i=this.E/Math.pow(ut(this.e,t.y,Math.sin(t.y)),this.B))-(a=1/i)),h=.5*(i+a),i=Math.sin(this.B*t.x),h=(s*this.singam-i*this.cosgam)/h,Math.abs(Math.abs(h)-1)<W)throw new Error;h=.5*this.ArB*Math.log((1-h)/(1+h)),a=Math.cos(this.B*t.x),a=Math.abs(a)<cs?this.A*t.x:this.ArB*Math.atan2(s*this.cosgam+i*this.singam,a)}else h=0<t.y?this.v_pole_n:this.v_pole_s,a=this.ArB*t.y;return this.no_rot?(e.x=a,e.y=h):(a-=this.u_0,e.x=h*this.cosrot+a*this.sinrot,e.y=a*this.cosrot-h*this.sinrot),e.x=this.a*e.x+this.x0,e.y=this.a*e.y+this.y0,e},inverse:function(t){var s,i,a,h={};if(t.x=(t.x-this.x0)*(1/this.a),t.y=(t.y-this.y0)*(1/this.a),s=this.no_rot?(a=t.y,t.x):(a=t.x*this.cosrot-t.y*this.sinrot,t.y*this.cosrot+t.x*this.sinrot+this.u_0),t=.5*((i=Math.exp(-this.BrA*a))-1/i),a=.5*(i+1/i),a=((i=Math.sin(this.BrA*s))*this.cosgam+t*this.singam)/a,Math.abs(Math.abs(a)-1)<W)h.x=0,h.y=a<0?-D:D;else{if(h.y=this.E/Math.sqrt((1+a)/(1-a)),h.y=ct(this.e,Math.pow(h.y,1/this.B)),h.y===1/0)throw new Error;h.x=-this.rB*Math.atan2(t*this.cosgam-i*this.singam,Math.cos(this.BrA*s))}return h.x+=this.lam0,h},names:["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Two_Point_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","Oblique_Mercator","omerc"]},fs={init:function(){var t,s,i,a,h,e;this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,Math.abs(this.lat1+this.lat2)<W||(h=this.b/this.a,this.e=Math.sqrt(1-h*h),t=Math.sin(this.lat1),a=Math.cos(this.lat1),s=ot(this.e,t,a),i=ut(this.e,this.lat1,t),e=Math.sin(this.lat2),h=Math.cos(this.lat2),a=ot(this.e,e,h),h=ut(this.e,this.lat2,e),e=ut(this.e,this.lat0,Math.sin(this.lat0)),Math.abs(this.lat1-this.lat2)>W?this.ns=Math.log(s/a)/Math.log(i/h):this.ns=t,isNaN(this.ns)&&(this.ns=t),this.f0=s/(this.ns*Math.pow(i,this.ns)),this.rh=this.a*this.f0*Math.pow(e,this.ns),this.title||(this.title="Lambert Conformal Conic"))},forward:function(t){var s=t.x,i=t.y;Math.abs(2*Math.abs(i)-Math.PI)<=W&&(i=lt(i)*(D-2*W));var a,h=Math.abs(Math.abs(i)-D);if(W<h)a=ut(this.e,i,Math.sin(i)),a=this.a*this.f0*Math.pow(a,this.ns);else{if(i*this.ns<=0)return null;a=0}s=this.ns*dt(s-this.long0);return t.x=this.k0*(a*Math.sin(s))+this.x0,t.y=this.k0*(this.rh-a*Math.cos(s))+this.y0,t},inverse:function(t){var s,i,a=(t.x-this.x0)/this.k0,h=this.rh-(t.y-this.y0)/this.k0,e=0<this.ns?(s=Math.sqrt(a*a+h*h),1):(s=-Math.sqrt(a*a+h*h),-1),n=0;if(0!==s&&(n=Math.atan2(e*a,e*h)),0!==s||0<this.ns){if(e=1/this.ns,i=Math.pow(s/(this.a*this.f0),e),-9999===(i=ct(this.e,i)))return null}else i=-D;return n=dt(n/this.ns+this.long0),t.x=n,t.y=i,t},names:["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_1SP","Lambert_Conformal_Conic_2SP","lcc","Lambert Conic Conformal (1SP)","Lambert Conic Conformal (2SP)"]},ds={init:function(){this.a=6377397.155,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.4334234309119251),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq},forward:function(t){var s=t.x,i=t.y,a=dt(s-this.long0),s=Math.pow((1+this.e*Math.sin(i))/(1-this.e*Math.sin(i)),this.alfa*this.e/2),i=2*(Math.atan(this.k*Math.pow(Math.tan(i/2+this.s45),this.alfa)/s)-this.s45),s=-a*this.alfa,a=Math.asin(Math.cos(this.ad)*Math.sin(i)+Math.sin(this.ad)*Math.cos(i)*Math.cos(s)),s=Math.asin(Math.cos(i)*Math.sin(s)/Math.cos(a)),s=this.n*s,a=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(a/2+this.s45),this.n);return t.y=a*Math.cos(s),t.x=a*Math.sin(s),this.czech||(t.y*=-1,t.x*=-1),t},inverse:function(t){var s,i,a=t.x;t.x=t.y,t.y=a,this.czech||(t.y*=-1,t.x*=-1),i=Math.sqrt(t.x*t.x+t.y*t.y),a=Math.atan2(t.y,t.x)/Math.sin(this.s0),i=2*(Math.atan(Math.pow(this.ro0/i,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),s=Math.asin(Math.cos(this.ad)*Math.sin(i)-Math.sin(this.ad)*Math.cos(i)*Math.cos(a)),a=Math.asin(Math.cos(i)*Math.sin(a)/Math.cos(s)),t.x=this.long0-a/this.alfa;for(var h=s,e=0,n=0;t.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(s/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(h))/(1-this.e*Math.sin(h)),this.e/2))-this.s45),Math.abs(h-t.y)<1e-10&&(e=1),h=t.y,n+=1,0===e&&n<15;);return 15<=n?null:t},names:["Krovak","krovak"]},ps={init:function(){this.sphere||(this.e0=Ht(this.es),this.e1=Jt(this.es),this.e2=Kt(this.es),this.e3=Vt(this.es),this.ml0=this.a*Xt(this.e0,this.e1,this.e2,this.e3,this.lat0))},forward:function(t){var s,i,a,h,e,n,r=t.x,o=t.y,r=dt(r-this.long0);return n=this.sphere?(e=this.a*Math.asin(Math.cos(o)*Math.sin(r)),this.a*(Math.atan2(Math.tan(o),Math.cos(r))-this.lat0)):(s=Math.sin(o),i=Math.cos(o),a=Zt(this.a,this.e,s),h=Math.tan(o)*Math.tan(o),e=a*(r=r*Math.cos(o))*(1-(n=r*r)*h*(1/6-(8-h+8*(r=this.es*i*i/(1-this.es)))*n/120)),this.a*Xt(this.e0,this.e1,this.e2,this.e3,o)-this.ml0+a*s/i*n*(.5+(5-h+6*r)*n/24)),t.x=e+this.x0,t.y=n+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var s=t.x/this.a,i=t.y/this.a;if(this.sphere)var a=i+this.lat0,h=Math.asin(Math.sin(a)*Math.cos(s)),e=Math.atan2(Math.tan(s),Math.cos(a));else{var n=this.ml0/this.a+i,r=$t(n,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(r)-D)<=W)return t.x=this.long0,t.y=D,i<0&&(t.y*=-1),t;var o=Zt(this.a,this.e,Math.sin(r)),a=o*o*o/this.a/this.a*(1-this.es),n=Math.pow(Math.tan(r),2),i=s*this.a/o,s=i*i;h=r-o*Math.tan(r)/a*i*i*(.5-(1+3*n)*i*i/24),e=i*(1-s*(n/3+(1+3*n)*n*s/15))/Math.cos(r)}return t.x=dt(e+this.long0),t.y=Yt(h),t},names:["Cassini","Cassini_Soldner","cass"]},ms={init:function(){var t,s,i,a=Math.abs(this.lat0);if(Math.abs(a-D)<W?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(a)<W?this.mode=this.EQUIT:this.mode=this.OBLIQ,0<this.es)switch(this.qp=ts(this.e,1),this.mmf=.5/(1-this.es),this.apa=(s=this.es,(i=[])[0]=.3333333333333333*s,i[0]+=.17222222222222222*(a=s*s),i[1]=.06388888888888888*a,i[0]+=.10257936507936508*(a*=s),i[1]+=.0664021164021164*a,i[2]=.016415012942191543*a,i),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=ts(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))},forward:function(t){var s,i,a,h,e,n,r,o,l,u,c=t.x,M=t.y,c=dt(c-this.long0);if(this.sphere){if(e=Math.sin(M),u=Math.cos(M),a=Math.cos(c),this.mode===this.OBLIQ||this.mode===this.EQUIT){if((i=this.mode===this.EQUIT?1+u*a:1+this.sinph0*e+this.cosph0*u*a)<=W)return null;s=(i=Math.sqrt(2/i))*u*Math.sin(c),i*=this.mode===this.EQUIT?e:this.cosph0*e-this.sinph0*u*a}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(a=-a),Math.abs(M+this.lat0)<W)return null;i=J-.5*M,s=(i=2*(this.mode===this.S_POLE?Math.cos(i):Math.sin(i)))*Math.sin(c),i*=a}}else{switch(l=o=r=0,a=Math.cos(c),h=Math.sin(c),e=Math.sin(M),n=ts(this.e,e),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(r=n/this.qp,o=Math.sqrt(1-r*r)),this.mode){case this.OBLIQ:l=1+this.sinb1*r+this.cosb1*o*a;break;case this.EQUIT:l=1+o*a;break;case this.N_POLE:l=D+M,n=this.qp-n;break;case this.S_POLE:l=M-D,n=this.qp+n}if(Math.abs(l)<W)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:l=Math.sqrt(2/l),i=this.mode===this.OBLIQ?this.ymf*l*(this.cosb1*r-this.sinb1*o*a):(l=Math.sqrt(2/(1+o*a)))*r*this.ymf,s=this.xmf*l*o*h;break;case this.N_POLE:case this.S_POLE:0<=n?(s=(l=Math.sqrt(n))*h,i=a*(this.mode===this.S_POLE?l:-l)):s=i=0}}return t.x=this.a*s+this.x0,t.y=this.a*i+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var s,i,a,h,e,n,r,o=t.x/this.a,l=t.y/this.a;if(this.sphere){var u=0,c=0,M=Math.sqrt(o*o+l*l);if(1<(i=.5*M))return null;switch(i=2*Math.asin(i),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(c=Math.sin(i),u=Math.cos(i)),this.mode){case this.EQUIT:i=Math.abs(M)<=W?0:Math.asin(l*c/M),o*=c,l=u*M;break;case this.OBLIQ:i=Math.abs(M)<=W?this.lat0:Math.asin(u*this.sinph0+l*c*this.cosph0/M),o*=c*this.cosph0,l=(u-Math.sin(i)*this.sinph0)*M;break;case this.N_POLE:l=-l,i=D-i;break;case this.S_POLE:i-=D}s=0!==l||this.mode!==this.EQUIT&&this.mode!==this.OBLIQ?Math.atan2(o,l):0}else{if(r=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(o/=this.dd,l*=this.dd,(h=Math.sqrt(o*o+l*l))<W)return t.x=this.long0,t.y=this.lat0,t;a=2*Math.asin(.5*h/this.rq),e=Math.cos(a),o*=a=Math.sin(a),l=this.mode===this.OBLIQ?(r=e*this.sinb1+l*a*this.cosb1/h,n=this.qp*r,h*this.cosb1*e-l*this.sinb1*a):(n=this.qp*(r=l*a/h),h*e)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(!(n=o*o+(l=this.mode===this.N_POLE?-l:l)*l))return t.x=this.long0,t.y=this.lat0,t;r=1-n/this.qp,this.mode===this.S_POLE&&(r=-r)}s=Math.atan2(o,l),e=Math.asin(r),n=this.apa,r=e+e,i=e+n[0]*Math.sin(r)+n[1]*Math.sin(r+r)+n[2]*Math.sin(r+r+r)}return t.x=dt(this.long0+s),t.y=i,t},names:["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"],S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4},ys={init:function(){Math.abs(this.lat1+this.lat2)<W||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=ot(this.e3,this.sin_po,this.cos_po),this.qs1=ts(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=ot(this.e3,this.sin_po,this.cos_po),this.qs2=ts(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=ts(this.e3,this.sin_po,this.cos_po),Math.abs(this.lat1-this.lat2)>W?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)},forward:function(t){var s=t.x,i=t.y;this.sin_phi=Math.sin(i),this.cos_phi=Math.cos(i);var a=ts(this.e3,this.sin_phi,this.cos_phi),i=this.a*Math.sqrt(this.c-this.ns0*a)/this.ns0,a=this.ns0*dt(s-this.long0),s=i*Math.sin(a)+this.x0,a=this.rh-i*Math.cos(a)+this.y0;return t.x=s,t.y=a,t},inverse:function(t){var s,i,a,h;return t.x-=this.x0,t.y=this.rh-t.y+this.y0,i=0<=this.ns0?(s=Math.sqrt(t.x*t.x+t.y*t.y),1):(s=-Math.sqrt(t.x*t.x+t.y*t.y),-1),(a=0)!==s&&(a=Math.atan2(i*t.x,i*t.y)),i=s*this.ns0/this.a,h=this.sphere?Math.asin((this.c-i*i)/(2*this.ns0)):(h=(this.c-i*i)/this.ns0,this.phi1z(this.e3,h)),a=dt(a/this.ns0+this.long0),t.x=a,t.y=h,t},names:["Albers_Conic_Equal_Area","Albers","aea"],phi1z:function(t,s){var i,a,h,e=ss(.5*s);if(t<W)return e;for(var n=t*t,r=1;r<=25;r++)if(e+=h=.5*(a=1-(h=t*(i=Math.sin(e)))*h)*a/Math.cos(e)*(s/(1-n)-i/a+.5/t*Math.log((1-h)/(1+h))),Math.abs(h)<=1e-7)return e;return null}},_s={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1},forward:function(t){var s,i=t.x,a=t.y,h=dt(i-this.long0),e=Math.sin(a),n=Math.cos(a),i=Math.cos(h),i=0<(a=this.sin_p14*e+this.cos_p14*n*i)||Math.abs(a)<=W?(s=this.x0+ +this.a*n*Math.sin(h)/a,this.y0+ +this.a*(this.cos_p14*e-this.sin_p14*n*i)/a):(s=this.x0+this.infinity_dist*n*Math.sin(h),this.y0+this.infinity_dist*(this.cos_p14*e-this.sin_p14*n*i));return t.x=s,t.y=i,t},inverse:function(t){var s,i,a,h;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,a=(s=Math.sqrt(t.x*t.x+t.y*t.y))?(h=Math.atan2(s,this.rc),a=Math.sin(h),i=Math.cos(h),h=ss(i*this.sin_p14+t.y*a*this.cos_p14/s),a=Math.atan2(t.x*a,s*this.cos_p14*i-t.y*this.sin_p14*a),dt(this.long0+a)):(h=this.phic0,0),t.x=a,t.y=h,t},names:["gnom"]},gs={init:function(){this.sphere||(this.k0=ot(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))},forward:function(t){var s,i,a=t.x,h=t.y,a=dt(a-this.long0);return i=this.sphere?(s=this.x0+this.a*a*Math.cos(this.lat_ts),this.y0+this.a*Math.sin(h)/Math.cos(this.lat_ts)):(i=ts(this.e,Math.sin(h)),s=this.x0+this.a*this.k0*a,this.y0+this.a*i*.5/this.k0),t.x=s,t.y=i,t},inverse:function(t){var s,i;return t.x-=this.x0,t.y-=this.y0,this.sphere?(s=dt(this.long0+t.x/this.a/Math.cos(this.lat_ts)),i=Math.asin(t.y/this.a*Math.cos(this.lat_ts))):(i=function(t,s){var i=1-(1-t*t)/(2*t)*Math.log((1-t)/(1+t));if(Math.abs(Math.abs(s)-i)<1e-6)return s<0?-1*D:D;for(var a,h,e,n=Math.asin(.5*s),r=0;r<30;r++)if(a=Math.sin(n),h=Math.cos(n),e=t*a,n+=e=Math.pow(1-e*e,2)/(2*h)*(s/(1-t*t)-a/(1-e*e)+.5/t*Math.log((1-e)/(1+e))),Math.abs(e)<=1e-10)return n;return NaN}(this.e,2*t.y*this.k0/this.a),s=dt(this.long0+t.x/(this.a*this.k0))),t.x=s,t.y=i,t},names:["cea"]},xs={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)},forward:function(t){var s=t.x,i=t.y,s=dt(s-this.long0),i=Yt(i-this.lat0);return t.x=this.x0+this.a*s*this.rc,t.y=this.y0+this.a*i,t},inverse:function(t){var s=t.x,i=t.y;return t.x=dt(this.long0+(s-this.x0)/(this.a*this.rc)),t.y=Yt(this.lat0+(i-this.y0)/this.a),t},names:["Equirectangular","Equidistant_Cylindrical","eqc"]},bs={init:function(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Ht(this.es),this.e1=Jt(this.es),this.e2=Kt(this.es),this.e3=Vt(this.es),this.ml0=this.a*Xt(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(t){var s,i=t.x,a=t.y,h=dt(i-this.long0),i=h*Math.sin(a);return i=this.sphere?Math.abs(a)<=W?(s=this.a*h,-1*this.a*this.lat0):(s=this.a*Math.sin(i)/Math.tan(a),this.a*(Yt(a-this.lat0)+(1-Math.cos(i))/Math.tan(a))):Math.abs(a)<=W?(s=this.a*h,-1*this.ml0):(s=(h=Zt(this.a,this.e,Math.sin(a))/Math.tan(a))*Math.sin(i),this.a*Xt(this.e0,this.e1,this.e2,this.e3,a)-this.ml0+h*(1-Math.cos(i))),t.x=s+this.x0,t.y=i+this.y0,t},inverse:function(t){var s,i,a,h,e,n,r=t.x-this.x0,o=t.y-this.y0;if(this.sphere)if(Math.abs(o+this.a*this.lat0)<=W)s=dt(r/this.a+this.long0),i=0;else{for(var l,u=this.lat0+o/this.a,c=r*r/this.a/this.a+u*u,M=u,f=20;f;--f)if(M+=a=-1*(u*(M*(l=Math.tan(M))+1)-M-.5*(M*M+c)*l)/((M-u)/l-1),Math.abs(a)<=W){i=M;break}s=dt(this.long0+Math.asin(r*Math.tan(M)/this.a)/Math.sin(i))}else if(Math.abs(o+this.ml0)<=W)i=0,s=dt(this.long0+r/this.a);else{for(u=(this.ml0+o)/this.a,c=r*r/this.a/this.a+u*u,M=u,f=20;f;--f)if(n=this.e*Math.sin(M),h=Math.sqrt(1-n*n)*Math.tan(M),e=this.a*Xt(this.e0,this.e1,this.e2,this.e3,M),n=this.e0-2*this.e1*Math.cos(2*M)+4*this.e2*Math.cos(4*M)-6*this.e3*Math.cos(6*M),M-=a=(u*(h*(e=e/this.a)+1)-e-.5*h*(e*e+c))/(this.es*Math.sin(2*M)*(e*e+c-2*u*e)/(4*h)+(u-e)*(h*n-2/Math.sin(2*M))-n),Math.abs(a)<=W){i=M;break}h=Math.sqrt(1-this.es*Math.pow(Math.sin(i),2))*Math.tan(i),s=dt(this.long0+Math.asin(r*h/this.a)/Math.sin(i))}return t.x=s,t.y=i,t},names:["Polyconic","poly"]},vs={init:function(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013},forward:function(t){for(var s=t.x,i=t.y-this.lat0,s=s-this.long0,a=i/T*1e-5,s=s,h=1,e=0,n=1;n<=10;n++)e+=this.A[n]*(h*=a);var r,o=e,l=s,u=1,c=0,M=0,f=0;for(n=1;n<=6;n++)r=c*o+u*l,M=M+this.B_re[n]*(u=u*o-c*l)-this.B_im[n]*(c=r),f=f+this.B_im[n]*u+this.B_re[n]*c;return t.x=f*this.a+this.x0,t.y=M*this.a+this.y0,t},inverse:function(t){var s,i=t.x,a=t.y,i=i-this.x0,h=(a-this.y0)/this.a,e=i/this.a,n=1,r=0,o=0,l=0;for(m=1;m<=6;m++)s=r*h+n*e,o=o+this.C_re[m]*(n=n*h-r*e)-this.C_im[m]*(r=s),l=l+this.C_im[m]*n+this.C_re[m]*r;for(var u=0;u<this.iterations;u++){for(var c,M=o,f=l,d=h,p=e,m=2;m<=6;m++)c=f*o+M*l,M=M*o-f*l,f=c,d+=(m-1)*(this.B_re[m]*M-this.B_im[m]*f),p+=(m-1)*(this.B_im[m]*M+this.B_re[m]*f);var M=1,f=0,y=this.B_re[1],_=this.B_im[1];for(m=2;m<=6;m++)c=f*o+M*l,M=M*o-f*l,f=c,y+=m*(this.B_re[m]*M-this.B_im[m]*f),_+=m*(this.B_im[m]*M+this.B_re[m]*f);var g=y*y+_*_,o=(d*y+p*_)/g,l=(p*y-d*_)/g}var x=o,a=l,b=1,v=0;for(m=1;m<=9;m++)v+=this.D[m]*(b*=x);i=this.lat0+v*T*1e5,a=this.long0+a;return t.x=a,t.y=i,t},names:["New_Zealand_Map_Grid","nzmg"]},ws={init:function(){},forward:function(t){var s=t.x,i=t.y,s=dt(s-this.long0),s=this.x0+this.a*s,i=this.y0+this.a*Math.log(Math.tan(Math.PI/4+i/2.5))*1.25;return t.x=s,t.y=i,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var s=dt(this.long0+t.x/this.a),i=2.5*(Math.atan(Math.exp(.8*t.y/this.a))-Math.PI/4);return t.x=s,t.y=i,t},names:["Miller_Cylindrical","mill"]},Ns={init:function(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=Rt(this.es)},forward:function(t){var s=t.x,i=t.y,s=dt(s-this.long0);if(this.sphere){if(this.m)for(var a=this.n*Math.sin(i),h=20;h;--h){var e=(this.m*i+Math.sin(i)-a)/(this.m+Math.cos(i));if(i-=e,Math.abs(e)<W)break}else i=1!==this.n?Math.asin(this.n*Math.sin(i)):i;l=this.a*this.C_x*s*(this.m+Math.cos(i)),o=this.a*this.C_y*i}else var n=Math.sin(i),r=Math.cos(i),o=this.a*zt(i,n,r,this.en),l=this.a*s*r/Math.sqrt(1-this.es*n*n);return t.x=l,t.y=o,t},inverse:function(t){var s,i,a,h;return t.x-=this.x0,a=t.x/this.a,t.y-=this.y0,s=t.y/this.a,this.sphere?(s/=this.C_y,a/=this.C_x*(this.m+Math.cos(s)),this.m?s=ss((this.m*s+Math.sin(s))/this.n):1!==this.n&&(s=ss(Math.sin(s)/this.n)),a=dt(a+this.long0),s=Yt(s)):(s=Bt(t.y/this.a,this.es,this.en),(h=Math.abs(s))<D?(h=Math.sin(s),i=this.long0+t.x*Math.sqrt(1-this.es*h*h)/(this.a*Math.cos(s)),a=dt(i)):h-W<D&&(a=this.long0)),t.x=a,t.y=s,t},names:["Sinusoidal","sinu"]},Cs={init:function(){},forward:function(t){for(var s=t.x,i=t.y,s=dt(s-this.long0),a=i,h=Math.PI*Math.sin(i);;){var e=-(a+Math.sin(a)-h)/(1+Math.cos(a));if(a+=e,Math.abs(e)<W)break}a/=2,Math.PI/2-Math.abs(i)<W&&(s=0);i=.900316316158*this.a*s*Math.cos(a)+this.x0,s=1.4142135623731*this.a*Math.sin(a)+this.y0;return t.x=i,t.y=s,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0,a=t.y/(1.4142135623731*this.a),.999999999999<Math.abs(a)&&(a=.999999999999);var s=Math.asin(a),i=dt(this.long0+t.x/(.900316316158*this.a*Math.cos(s)));(i=i<-Math.PI?-Math.PI:i)>Math.PI&&(i=Math.PI),a=(2*s+Math.sin(2*s))/Math.PI,1<Math.abs(a)&&(a=1);var a=Math.asin(a);return t.x=i,t.y=a,t},names:["Mollweide","moll"]},Ss={init:function(){Math.abs(this.lat1+this.lat2)<W||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Ht(this.es),this.e1=Jt(this.es),this.e2=Kt(this.es),this.e3=Vt(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=ot(this.e,this.sinphi,this.cosphi),this.ml1=Xt(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<W?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=ot(this.e,this.sinphi,this.cosphi),this.ml2=Xt(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=Xt(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))},forward:function(t){var s=t.x,i=t.y;i=this.sphere?this.a*(this.g-i):(a=Xt(this.e0,this.e1,this.e2,this.e3,i),this.a*(this.g-a));var a=this.ns*dt(s-this.long0),s=this.x0+i*Math.sin(a),a=this.y0+this.rh-i*Math.cos(a);return t.x=s,t.y=a,t},inverse:function(t){t.x-=this.x0,t.y=this.rh-t.y+this.y0;var s=0<=this.ns?(a=Math.sqrt(t.x*t.x+t.y*t.y),1):(a=-Math.sqrt(t.x*t.x+t.y*t.y),-1),i=0;if(0!==a&&(i=Math.atan2(s*t.x,s*t.y)),this.sphere)return e=dt(this.long0+i/this.ns),h=Yt(this.g-a/this.a),t.x=e,t.y=h,t;var a=this.g-a/this.a,h=$t(a,this.e0,this.e1,this.e2,this.e3),e=dt(this.long0+i/this.ns);return t.x=e,t.y=h,t},names:["Equidistant_Conic","eqdc"]},Ps={init:function(){this.R=this.a},forward:function(t){var s=t.x,i=t.y,a=dt(s-this.long0);Math.abs(i)<=W&&(l=this.x0+this.R*a,u=this.y0);var h=ss(2*Math.abs(i/Math.PI));(Math.abs(a)<=W||Math.abs(Math.abs(i)-D)<=W)&&(l=this.x0,u=0<=i?this.y0+Math.PI*this.R*Math.tan(.5*h):this.y0+Math.PI*this.R*-Math.tan(.5*h));var e=.5*Math.abs(Math.PI/a-a/Math.PI),n=e*e,r=Math.sin(h),o=Math.cos(h),s=o/(r+o-1),h=s*(2/r-1),o=h*h,r=Math.PI*this.R*(e*(s-o)+Math.sqrt(n*(s-o)*(s-o)-(o+n)*(s*s-o)))/(o+n),l=this.x0+(r=a<0?-r:r),s=n+s,r=Math.PI*this.R*(h*s-e*Math.sqrt((o+n)*(1+n)-s*s))/(o+n),u=0<=i?this.y0+r:this.y0-r;return t.x=l,t.y=u,t},inverse:function(t){var s,i,a,h,e,n,r;return t.x-=this.x0,t.y-=this.y0,r=Math.PI*this.R,a=(s=t.x/r)*s+(i=t.y/r)*i,r=3*(i*i/(e=-2*(n=-Math.abs(i)*(1+a))+1+2*i*i+a*a)+(2*(h=n-2*i*i+s*s)*h*h/e/e/e-9*n*h/e/e)/27)/(n=(n-h*h/3/e)/e)/(n=2*Math.sqrt(-n/3)),1<Math.abs(r)&&(r=0<=r?1:-1),r=Math.acos(r)/3,e=0<=t.y?(-n*Math.cos(r+Math.PI/3)-h/3/e)*Math.PI:-(-n*Math.cos(r+Math.PI/3)-h/3/e)*Math.PI,s=Math.abs(s)<W?this.long0:dt(this.long0+Math.PI*(a-1+Math.sqrt(1+2*(s*s-i*i)+a*a))/2/s),t.x=s,t.y=e,t},names:["Van_der_Grinten_I","VanDerGrinten","vandg"]},Es={init:function(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)},forward:function(t){var s,i,a,h,e,n,r=t.x,o=t.y,l=Math.sin(t.y),u=Math.cos(t.y),c=dt(r-this.long0);return this.sphere?Math.abs(this.sin_p12-1)<=W?(t.x=this.x0+this.a*(D-o)*Math.sin(c),t.y=this.y0-this.a*(D-o)*Math.cos(c)):Math.abs(this.sin_p12+1)<=W?(t.x=this.x0+this.a*(D+o)*Math.sin(c),t.y=this.y0+this.a*(D+o)*Math.cos(c)):(e=this.sin_p12*l+this.cos_p12*u*Math.cos(c),h=(a=Math.acos(e))?a/Math.sin(a):1,t.x=this.x0+this.a*h*u*Math.sin(c),t.y=this.y0+this.a*h*(this.cos_p12*l-this.sin_p12*u*Math.cos(c))):(s=Ht(this.es),r=Jt(this.es),e=Kt(this.es),h=Vt(this.es),Math.abs(this.sin_p12-1)<=W?(i=this.a*Xt(s,r,e,h,D),n=this.a*Xt(s,r,e,h,o),t.x=this.x0+(i-n)*Math.sin(c),t.y=this.y0-(i-n)*Math.cos(c)):Math.abs(this.sin_p12+1)<=W?(i=this.a*Xt(s,r,e,h,D),n=this.a*Xt(s,r,e,h,o),t.x=this.x0+(i+n)*Math.sin(c),t.y=this.y0+(i+n)*Math.cos(c)):(o=l/u,i=Zt(this.a,this.e,this.sin_p12),n=Zt(this.a,this.e,l),l=Math.atan((1-this.es)*o+this.es*i*this.sin_p12/(n*u)),n=0===(o=Math.atan2(Math.sin(c),this.cos_p12*Math.tan(l)-this.sin_p12*Math.cos(c)))?Math.asin(this.cos_p12*Math.sin(l)-this.sin_p12*Math.cos(l)):Math.abs(Math.abs(o)-Math.PI)<=W?-Math.asin(this.cos_p12*Math.sin(l)-this.sin_p12*Math.cos(l)):Math.asin(Math.sin(c)*Math.cos(l)/Math.sin(o)),u=this.e*this.sin_p12/Math.sqrt(1-this.es),c=this.e*this.cos_p12*Math.cos(o)/Math.sqrt(1-this.es),t.x=this.x0+(a=i*n*(1-(l=n*n)*(i=c*c)*(1-i)/6+(l=l*n)/8*(c=u*c)*(1-2*i)+(l=l*n)/120*(i*(4-7*i)-3*u*u*(1-7*i))-l*n/48*c))*Math.sin(o),t.y=this.y0+a*Math.cos(o))),t},inverse:function(t){var s,i,a,h,e,n,r,o;return t.x-=this.x0,t.y-=this.y0,this.sphere?(s=Math.sqrt(t.x*t.x+t.y*t.y))>2*D*this.a?void 0:(r=s/this.a,o=Math.sin(r),n=Math.cos(r),i=this.long0,Math.abs(s)<=W?a=this.lat0:(a=ss(n*this.sin_p12+t.y*o*this.cos_p12/s),e=Math.abs(this.lat0)-D,i=dt(Math.abs(e)<=W?0<=this.lat0?this.long0+Math.atan2(t.x,-t.y):this.long0-Math.atan2(-t.x,t.y):this.long0+Math.atan2(t.x*o,s*this.cos_p12*n-t.y*this.sin_p12*o))),t.x=i,t.y=a,t):(r=Ht(this.es),e=Jt(this.es),n=Kt(this.es),o=Vt(this.es),Math.abs(this.sin_p12-1)<=W?(h=this.a*Xt(r,e,n,o,D),s=Math.sqrt(t.x*t.x+t.y*t.y),a=$t((h-s)/this.a,r,e,n,o),i=dt(this.long0+Math.atan2(t.x,-1*t.y))):Math.abs(this.sin_p12+1)<=W?(h=this.a*Xt(r,e,n,o,D),s=Math.sqrt(t.x*t.x+t.y*t.y),a=$t((s-h)/this.a,r,e,n,o),i=dt(this.long0+Math.atan2(t.x,t.y))):(s=Math.sqrt(t.x*t.x+t.y*t.y),h=Math.atan2(t.x,t.y),r=Zt(this.a,this.e,this.sin_p12),e=Math.cos(h),o=-(n=this.e*this.cos_p12*e)*n/(1-this.es),n=3*this.es*(1-o)*this.sin_p12*this.cos_p12*e/(1-this.es),r=1-o*(o=(r=s/r)-o*(1+o)*Math.pow(r,3)/6-n*(1+3*o)*Math.pow(r,4)/24)*o/2-r*o*o*o/6,e=Math.asin(this.sin_p12*Math.cos(o)+this.cos_p12*Math.sin(o)*e),i=dt(this.long0+Math.asin(Math.sin(h)*Math.sin(o)/Math.cos(e))),o=Math.sin(e),a=Math.atan2((o-this.es*r*this.sin_p12)*Math.tan(e),o*(1-this.es))),t.x=i,t.y=a,t)},names:["Azimuthal_Equidistant","aeqd"]},ks={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)},forward:function(t){var s,i,a=t.x,h=t.y,e=dt(a-this.long0),n=Math.sin(h),r=Math.cos(h),a=Math.cos(e);return(0<(h=this.sin_p14*n+this.cos_p14*r*a)||Math.abs(h)<=W)&&(s=+this.a*r*Math.sin(e),i=this.y0+ +this.a*(this.cos_p14*n-this.sin_p14*r*a)),t.x=s,t.y=i,t},inverse:function(t){var s,i,a,h,e,n;return t.x-=this.x0,t.y-=this.y0,s=Math.sqrt(t.x*t.x+t.y*t.y),h=ss(s/this.a),i=Math.sin(h),a=Math.cos(h),e=this.long0,Math.abs(s)<=W?n=this.lat0:(n=ss(a*this.sin_p14+t.y*i*this.cos_p14/s),h=Math.abs(this.lat0)-D,e=Math.abs(h)<=W?dt(0<=this.lat0?this.long0+Math.atan2(t.x,-t.y):this.long0-Math.atan2(-t.x,t.y)):dt(this.long0+Math.atan2(t.x*i,s*this.cos_p14*a-t.y*this.sin_p14*i))),t.x=e,t.y=n,t},names:["ortho"]},Is=1,qs=2,As=3,Os=4,js=5,Gs=6,Ls=1,Rs=2,zs=3,Bs=4,Ts={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=D-J/2?this.face=js:this.lat0<=-(D-J/2)?this.face=Gs:Math.abs(this.long0)<=J?this.face=Is:Math.abs(this.long0)<=D+J?this.face=0<this.long0?qs:Os:this.face=As,0!==this.es&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)},forward:function(t){var s,i,a,h,e,n,r,o={x:0,y:0},l={value:0};return t.x-=this.long0,r=0!==this.es?Math.atan(this.one_minus_f_squared*Math.tan(t.y)):t.y,s=t.x,this.face===js?(i=D-r,a=J<=s&&s<=D+J?(l.value=Ls,s-D):D+J<s||s<=-(D+J)?(l.value=Rs,0<s?s-V:s+V):-(D+J)<s&&s<=-J?(l.value=zs,s+D):(l.value=Bs,s)):this.face===Gs?(i=D+r,a=J<=s&&s<=D+J?(l.value=Ls,-s+D):s<J&&-J<=s?(l.value=Rs,-s):s<-J&&-(D+J)<=s?(l.value=zs,-s-D):(l.value=Bs,0<s?V-s:-s-V)):(this.face===qs?s=j(s,+D):this.face===As?s=j(s,+V):this.face===Os&&(s=j(s,-D)),e=Math.sin(r),n=Math.cos(r),r=Math.sin(s),h=n*Math.cos(s),r=n*r,e=e,this.face===Is?a=O(i=Math.acos(h),e,r,l):this.face===qs?a=O(i=Math.acos(r),e,-h,l):this.face===As?a=O(i=Math.acos(-h),e,-r,l):this.face===Os?a=O(i=Math.acos(-r),e,h,l):(i=a=0,l.value=Ls)),h=Math.atan(12/V*(a+Math.acos(Math.sin(a)*Math.cos(J))-D)),a=Math.sqrt((1-Math.cos(i))/(Math.cos(h)*Math.cos(h))/(1-Math.cos(Math.atan(1/Math.cos(a))))),l.value===Rs?h+=D:l.value===zs?h+=V:l.value===Bs&&(h+=1.5*V),o.x=a*Math.cos(h),o.y=a*Math.sin(h),o.x=o.x*this.a+this.x0,o.y=o.y*this.a+this.y0,t.x=o.x,t.y=o.y,t},inverse:function(t){var s,i,a,h,e,n,r,o={lam:0,phi:0},l={value:0};return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,i=Math.atan(Math.sqrt(t.x*t.x+t.y*t.y)),s=Math.atan2(t.y,t.x),0<=t.x&&t.x>=Math.abs(t.y)?l.value=Ls:0<=t.y&&t.y>=Math.abs(t.x)?(l.value=Rs,s-=D):t.x<0&&-t.x>=Math.abs(t.y)?(l.value=zs,s=s<0?s+V:s-V):(l.value=Bs,s+=D),e=V/12*Math.tan(s),h=Math.sin(e)/(Math.cos(e)-1/Math.sqrt(2)),h=Math.atan(h),(i=1-(s=Math.cos(s))*s*(i=Math.tan(i))*i*(1-Math.cos(Math.atan(1/Math.cos(h)))))<-1?i=-1:1<i&&(i=1),this.face===js?(a=Math.acos(i),o.phi=D-a,l.value===Ls?o.lam=h+D:l.value===Rs?o.lam=h<0?h+V:h-V:l.value===zs?o.lam=h-D:o.lam=h):this.face===Gs?(a=Math.acos(i),o.phi=a-D,l.value===Ls?o.lam=-h+D:l.value===Rs?o.lam=-h:l.value===zs?o.lam=-h-D:o.lam=h<0?-h-V:V-h):(e=(r=i)*r,n=1<=(e+=(h=1<=e?0:Math.sqrt(1-e)*Math.sin(h))*h)?0:Math.sqrt(1-e),l.value===Rs?(e=n,n=-h,h=e):l.value===zs?(n=-n,h=-h):l.value===Bs&&(e=n,n=h,h=-e),this.face===qs?(e=r,r=-n,n=e):this.face===As?(r=-r,n=-n):this.face===Os&&(e=r,r=n,n=-e),o.phi=Math.acos(-h)-D,o.lam=Math.atan2(n,r),this.face===qs?o.lam=j(o.lam,-D):this.face===As?o.lam=j(o.lam,-V):this.face===Os&&(o.lam=j(o.lam,+D))),0!==this.es&&(n=o.phi<0?1:0,r=Math.tan(o.phi),r=this.b/Math.sqrt(r*r+this.one_minus_f_squared),o.phi=Math.atan(Math.sqrt(this.a*this.a-r*r)/(this.one_minus_f*r)),n&&(o.phi=-o.phi)),o.lam+=this.long0,t.x=o.lam,t.y=o.phi,t},names:["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"]},Ds=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-9.86701e-7],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,1.8736e-8],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,9.34959e-7],[.7986,-.00755338,-500009e-10,9.35324e-7],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],Fs=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-1.26793e-9,4.22642e-10],[.124,.0124,5.07171e-9,-1.60604e-9],[.186,.0123999,-1.90189e-8,6.00152e-9],[.248,.0124002,7.10039e-8,-2.24e-8],[.31,.0123992,-2.64997e-7,8.35986e-8],[.372,.0124029,9.88983e-7,-3.11994e-7],[.434,.0123893,-369093e-11,-4.35621e-7],[.4958,.0123198,-102252e-10,-3.45523e-7],[.5571,.0121916,-154081e-10,-5.82288e-7],[.6176,.0119938,-241424e-10,-5.25327e-7],[.6769,.011713,-320223e-10,-5.16405e-7],[.7346,.0113541,-397684e-10,-6.09052e-7],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-1.40374e-9],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Us=H/5,Qs=1/Us,Ws={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"},forward:function(t){var s=dt(t.x-this.long0),i=Math.abs(t.y),a=Math.floor(i*Us);a<0?a=0:18<=a&&(a=17);i={x:is(Ds[a],i=H*(i-Qs*a))*s,y:is(Fs[a],i)};return t.y<0&&(i.y=-i.y),i.x=i.x*this.a*.8487+this.x0,i.y=i.y*this.a*1.3523+this.y0,i},inverse:function(t){var s={x:(t.x-this.x0)/(.8487*this.a),y:Math.abs(t.y-this.y0)/(1.3523*this.a)};if(1<=s.y)s.x/=Ds[18][0],s.y=t.y<0?-D:D;else{var i=Math.floor(18*s.y);for(i<0?i=0:18<=i&&(i=17);;)if(Fs[i][0]>s.y)--i;else{if(!(Fs[i+1][0]<=s.y))break;++i}var a=Fs[i],h=function(t,s,i,a){for(var h=s;a;--a){var e=t(h);if(h-=e,Math.abs(e)<i)break}return h}(function(t){return(is(a,t)-s.y)/(a[1]+t*(2*a[2]+3*t*a[3]))},h=5*(s.y-a[0])/(Fs[i+1][0]-a[0]),W,100);s.x/=is(Ds[i],h),s.y=(5*i+h)*X,t.y<0&&(s.y=-s.y)}return s.x=dt(s.x+this.long0),s},names:["Robinson","robin"]},Xs={init:function(){this.name="geocent"},forward:function(t){return M(t,this.es,this.a)},inverse:function(t){return f(t,this.es,this.a,this.b)},names:["Geocentric","geocentric","geocent","Geocent"]},Hs=0,Js=1,Ks=2,Vs=3,Zs={h:{def:1e5,num:!0},azi:{def:0,num:!0,degrees:!0},tilt:{def:0,num:!0,degrees:!0},long0:{def:0,num:!0},lat0:{def:0,num:!0}},Ys={init:function(){if(Object.keys(Zs).forEach(function(t){if(void 0===this[t])this[t]=Zs[t].def;else{if(Zs[t].num&&isNaN(this[t]))throw new Error("Invalid parameter value, must be numeric "+t+" = "+this[t]);Zs[t].num&&(this[t]=parseFloat(this[t]))}Zs[t].degrees&&(this[t]=this[t]*X)}.bind(this)),Math.abs(Math.abs(this.lat0)-D)<W?this.mode=this.lat0<0?Js:Hs:Math.abs(this.lat0)<W?this.mode=Ks:(this.mode=Vs,this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0)),this.pn1=this.h/this.a,this.pn1<=0||1e10<this.pn1)throw new Error("Invalid height");this.p=1+this.pn1,this.rp=1/this.p,this.h1=1/this.pn1,this.pfact=(this.p+1)*this.h1,this.es=0;var t=this.tilt,s=this.azi;this.cg=Math.cos(s),this.sg=Math.sin(s),this.cw=Math.cos(t),this.sw=Math.sin(t)},forward:function(t){t.x-=this.long0;var s,i,a,h,e=Math.sin(t.y),n=Math.cos(t.y),r=Math.cos(t.x);switch(this.mode){case Vs:i=this.sinph0*e+this.cosph0*n*r;break;case Ks:i=n*r;break;case Js:i=-e;break;case Hs:i=e}switch(s=(i=this.pn1/(this.p-i))*n*Math.sin(t.x),this.mode){case Vs:i*=this.cosph0*e-this.sinph0*n*r;break;case Ks:i*=e;break;case Hs:i*=-n*r;break;case Js:i*=n*r}return h=1/((a=i*this.cg+s*this.sg)*this.sw*this.h1+this.cw),s=(s*this.cg-i*this.sg)*this.cw*h,i=a*h,t.x=s*this.a,t.y=i*this.a,t},inverse:function(t){t.x/=this.a,t.y/=this.a;var s={x:t.x,y:t.y},i=1/(this.pn1-t.y*this.sw),a=this.pn1*t.x*i,i=this.pn1*t.y*this.cw*i;t.x=a*this.cg+i*this.sg,t.y=i*this.cg-a*this.sg;var h=Dt(t.x,t.y);if(Math.abs(h)<W)s.x=0,s.y=t.y;else{var e,n=1-h*h*this.pfact;switch(n=(this.p-Math.sqrt(n))/(this.pn1/h+h/this.pn1),e=Math.sqrt(1-n*n),this.mode){case Vs:s.y=Math.asin(e*this.sinph0+t.y*n*this.cosph0/h),t.y=(e-this.sinph0*Math.sin(s.y))*h,t.x*=n*this.cosph0;break;case Ks:s.y=Math.asin(t.y*n/h),t.y=e*h,t.x*=n;break;case Hs:s.y=Math.asin(e),t.y=-t.y;break;case Js:s.y=-Math.asin(e)}s.x=Math.atan2(t.x,t.y)}return t.x=s.x+this.long0,t.y=s.y,t},names:["Tilted_Perspective","tpers"]},_t={init:function(){if(this.flip_axis="x"===this.sweep?1:0,this.h=Number(this.h),this.radius_g_1=this.h/this.a,this.radius_g_1<=0||1e10<this.radius_g_1)throw new Error;var t,s;this.radius_g=1+this.radius_g_1,this.C=this.radius_g*this.radius_g-1,0!==this.es?(s=1/(t=1-this.es),this.radius_p=Math.sqrt(t),this.radius_p2=t,this.radius_p_inv2=s,this.shape="ellipse"):(this.radius_p=1,this.radius_p2=1,this.radius_p_inv2=1,this.shape="sphere"),this.title||(this.title="Geostationary Satellite View")},forward:function(t){var s=t.x,i=t.y;if(s-=this.long0,"ellipse"===this.shape){var i=Math.atan(this.radius_p2*Math.tan(i)),a=this.radius_p/Dt(this.radius_p*Math.cos(i),Math.sin(i)),h=a*Math.cos(s)*Math.cos(i),e=a*Math.sin(s)*Math.cos(i),n=a*Math.sin(i);if((this.radius_g-h)*h-e*e-n*n*this.radius_p_inv2<0)return t.x=Number.NaN,t.y=Number.NaN,t;a=this.radius_g-h,this.flip_axis?(t.x=this.radius_g_1*Math.atan(e/Dt(n,a)),t.y=this.radius_g_1*Math.atan(n/a)):(t.x=this.radius_g_1*Math.atan(e/a),t.y=this.radius_g_1*Math.atan(n/Dt(e,a)))}else"sphere"===this.shape&&(a=Math.cos(i),h=Math.cos(s)*a,e=Math.sin(s)*a,n=Math.sin(i),a=this.radius_g-h,this.flip_axis?(t.x=this.radius_g_1*Math.atan(e/Dt(n,a)),t.y=this.radius_g_1*Math.atan(n/a)):(t.x=this.radius_g_1*Math.atan(e/a),t.y=this.radius_g_1*Math.atan(n/Dt(e,a))));return t.x=t.x*this.a,t.y=t.y*this.a,t},inverse:function(t){var s,i=-1,a=0,h=0;if(t.x=t.x/this.a,t.y=t.y/this.a,"ellipse"===this.shape){this.flip_axis?(h=Math.tan(t.y/this.radius_g_1),a=Math.tan(t.x/this.radius_g_1)*Dt(1,h)):(a=Math.tan(t.x/this.radius_g_1),h=Math.tan(t.y/this.radius_g_1)*Dt(1,a));var e,n=h/this.radius_p,r=a*a+n*n+i*i;if((s=(e=2*this.radius_g*i)*e-4*r*this.C)<0)return t.x=Number.NaN,t.y=Number.NaN,t;n=(-e-Math.sqrt(s))/(2*r),i=this.radius_g+n*i,a*=n,h*=n,t.x=Math.atan2(a,i),t.y=Math.atan(h*Math.cos(t.x)/i),t.y=Math.atan(this.radius_p_inv2*Math.tan(t.y))}else if("sphere"===this.shape){if(this.flip_axis?(h=Math.tan(t.y/this.radius_g_1),a=Math.tan(t.x/this.radius_g_1)*Math.sqrt(1+h*h)):(a=Math.tan(t.x/this.radius_g_1),h=Math.tan(t.y/this.radius_g_1)*Math.sqrt(1+a*a)),(s=(e=2*this.radius_g*i)*e-4*(r=a*a+h*h+i*i)*this.C)<0)return t.x=Number.NaN,t.y=Number.NaN,t;n=(-e-Math.sqrt(s))/(2*r),i=this.radius_g+n*i,a*=n,h*=n,t.x=Math.atan2(a,i),t.y=Math.atan(h*Math.cos(t.x)/i)}return t.x=t.x+this.long0,t},names:["Geostationary Satellite View","Geostationary_Satellite","geos"]};return N.defaultDatum="WGS84",N.Proj=y,N.WGS84=new N.Proj("WGS84"),N.Point=A,N.toPoint=Ct,N.defs=o,N.nadgrid=function(t,s){var i,a=new DataView(s),h=11!==(i=a).getInt32(8,!1)&&(11!==i.getInt32(8,!0)&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian"),!0),s=(s=h,{nFields:(i=a).getInt32(8,s),nSubgridFields:i.getInt32(24,s),nSubgrids:i.getInt32(40,s),shiftType:u(i,56,64).trim(),fromSemiMajorAxis:i.getFloat64(120,s),fromSemiMinorAxis:i.getFloat64(136,s),toSemiMajorAxis:i.getFloat64(152,s),toSemiMinorAxis:i.getFloat64(168,s)});1<s.nSubgrids&&console.log("Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored");h={header:s,subgrids:c(a,s,h)};return vt[t]=h},N.transform=b,N.mgrs=Lt,N.version="2.8.0",(Lt=N).Proj.projections.add(hs),Lt.Proj.projections.add(es),Lt.Proj.projections.add(ns),Lt.Proj.projections.add(os),Lt.Proj.projections.add(ls),Lt.Proj.projections.add(us),Lt.Proj.projections.add(Ms),Lt.Proj.projections.add(fs),Lt.Proj.projections.add(ds),Lt.Proj.projections.add(ps),Lt.Proj.projections.add(ms),Lt.Proj.projections.add(ys),Lt.Proj.projections.add(_s),Lt.Proj.projections.add(gs),Lt.Proj.projections.add(xs),Lt.Proj.projections.add(bs),Lt.Proj.projections.add(vs),Lt.Proj.projections.add(ws),Lt.Proj.projections.add(Ns),Lt.Proj.projections.add(Cs),Lt.Proj.projections.add(Ss),Lt.Proj.projections.add(Ps),Lt.Proj.projections.add(Es),Lt.Proj.projections.add(ks),Lt.Proj.projections.add(Ts),Lt.Proj.projections.add(Ws),Lt.Proj.projections.add(Xs),Lt.Proj.projections.add(Ys),Lt.Proj.projections.add(_t),N});