/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;
import org.openide.util.NbBundle;

class JFRDumpAction
extends MultiDataSourceAction<DataSource> {
    private Set<Application> lastSelectedApplications = new HashSet<Application>();
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JFRDumpAction.this.updateState(ActionUtils.getSelectedDataSources());
        }
    };
    private static JFRDumpAction INSTANCE;

    public static synchronized JFRDumpAction instance() {
        if (INSTANCE == null) {
            INSTANCE = new JFRDumpAction();
        }
        return INSTANCE;
    }

    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        for (DataSource dataSource : dataSources) {
            boolean tagged;
            if (!(dataSource instanceof Application)) continue;
            Application application = (Application)dataSource;
            boolean bl = tagged = (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
            if (application.isLocalApplication()) {
                JFRSnapshotSupport.takeJfrDump(application, false, !tagged);
                continue;
            }
            JFRSnapshotSupport.takeRemoteJfrDump(application, null, !tagged);
        }
    }

    protected boolean isEnabled(Set<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                Application application = (Application)dataSource;
                this.lastSelectedApplications.add(application);
                application.addPropertyChangeListener("prop_state", this.stateListener);
                if (application.getState() != 1) {
                    return false;
                }
                if (!(application.isLocalApplication() ? !JFRSnapshotSupport.supportsJfrDump(application) : !JFRSnapshotSupport.supportsRemoteJfrDump(application))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected void updateState(Set<DataSource> dataSources) {
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.removePropertyChangeListener("prop_state", this.stateListener);
            }
        }
        this.lastSelectedApplications.clear();
        super.updateState(dataSources);
    }

    private JFRDumpAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(JFRDumpAction.class, (String)"MSG_JFR_Dump"));
        this.putValue("ShortDescription", NbBundle.getMessage(JFRDumpAction.class, (String)"LBL_JFR_Dump"));
    }
}

