/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.locks.ReentrantLock;

public class CopyOnWriteArrayIdentityList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient E[] arr;
    private final transient ReentrantLock lock = new ReentrantLock();

    public CopyOnWriteArrayIdentityList() {
    }

    public CopyOnWriteArrayIdentityList(Collection<? extends E> c) {
        this(c.toArray());
    }

    public CopyOnWriteArrayIdentityList(E[] array) {
        int size = array.length;
        E[] data = this.newElementArray(size);
        System.arraycopy(array, 0, data, 0, size);
        this.arr = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        this.lock.lock();
        try {
            E[] old = this.getData();
            int size = old.length;
            E[] data = this.newElementArray(size + 1);
            System.arraycopy(old, 0, data, 0, size);
            data[size] = e;
            this.setData(data);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E e) {
        this.lock.lock();
        try {
            E[] old = this.getData();
            int size = old.length;
            CopyOnWriteArrayIdentityList.checkIndexInclusive(index, size);
            E[] data = this.newElementArray(size + 1);
            System.arraycopy(old, 0, data, 0, index);
            data[index] = e;
            if (size > index) {
                System.arraycopy(old, index, data, index + 1, size - index);
            }
            this.setData(data);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        int ssize = c.size();
        this.lock.lock();
        try {
            int size = this.size();
            E[] old = this.getData();
            int nSize = size + ssize;
            E[] data = this.newElementArray(nSize);
            System.arraycopy(old, 0, data, 0, size);
            while (it.hasNext()) {
                data[size++] = it.next();
            }
            this.setData(data);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        int ssize = c.size();
        this.lock.lock();
        try {
            int size = this.size();
            CopyOnWriteArrayIdentityList.checkIndexInclusive(index, size);
            E[] old = this.getData();
            int nSize = size + ssize;
            E[] data = this.newElementArray(nSize);
            System.arraycopy(old, 0, data, 0, index);
            int i = index;
            while (it.hasNext()) {
                data[i++] = it.next();
            }
            if (size > index) {
                System.arraycopy(old, index, data, index + ssize, size - index);
            }
            this.setData(data);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        if (c.size() == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            E[] old = this.getData();
            int size = old.length;
            E[] toAdd = this.newElementArray(c.size());
            int i = 0;
            for (E o : c) {
                if (this.indexOf(o) >= 0) continue;
                toAdd[i++] = o;
            }
            E[] data = this.newElementArray(size + i);
            System.arraycopy(old, 0, data, 0, size);
            System.arraycopy(toAdd, 0, data, size, i);
            this.setData(data);
            int n = i;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(E e) {
        this.lock.lock();
        try {
            E[] old = this.getData();
            int size = old.length;
            if (size != 0 && this.indexOf(e) >= 0) {
                boolean bl = false;
                return bl;
            }
            E[] data = this.newElementArray(size + 1);
            System.arraycopy(old, 0, data, 0, size);
            data[size] = e;
            this.setData(data);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.setData(this.newElementArray(0));
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object clone() {
        try {
            CopyOnWriteArrayIdentityList thisClone = (CopyOnWriteArrayIdentityList)super.clone();
            thisClone.setData(this.getData());
            return thisClone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("CloneNotSupportedException is not expected here");
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.containsAll(c, data, 0, data.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        ListIterator it = l.listIterator();
        ListIterator<E> ourIt = this.listIterator();
        while (it.hasNext()) {
            Object anotherListElem;
            if (!ourIt.hasNext()) {
                return false;
            }
            Object thisListElem = it.next();
            if (thisListElem == (anotherListElem = ourIt.next())) continue;
            return false;
        }
        return !ourIt.hasNext();
    }

    @Override
    public E get(int index) {
        E[] data = this.getData();
        return data[index];
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int indexOf(E e, int index) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.indexOf(e, data, index, data.length - index);
    }

    @Override
    public int indexOf(Object o) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.indexOf(o, data, 0, data.length);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIteratorImpl(this.getData(), 0);
    }

    public int lastIndexOf(E e, int index) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.lastIndexOf(e, data, 0, index);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.lastIndexOf(o, data, 0, data.length);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorImpl(this.getData(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] data = this.getData();
        CopyOnWriteArrayIdentityList.checkIndexInclusive(index, data.length);
        return new ListIteratorImpl(data, index);
    }

    @Override
    public E remove(int index) {
        return this.removeRange(index, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            int index = this.indexOf(o);
            if (index == -1) {
                boolean bl = false;
                return bl;
            }
            this.remove(index);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean bl = this.removeAll(c, 0, this.getData().length) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.retainAll(c, 0, this.getData().length) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E e) {
        this.lock.lock();
        try {
            int size = this.size();
            CopyOnWriteArrayIdentityList.checkIndexExlusive(index, size);
            E[] data = this.newElementArray(size);
            E[] oldArr = this.getData();
            System.arraycopy(oldArr, 0, data, 0, size);
            E old = data[index];
            data[index] = e;
            this.setData(data);
            E e2 = old;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.getData().length;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.toArray(data, 0, data.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] data = this.getData();
        return CopyOnWriteArrayIdentityList.toArray(a, data, 0, data.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (E o : this) {
            sb.append(o);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        return sb.toString();
    }

    private final E[] newElementArray(int size) {
        return new Object[size];
    }

    private final void setData(E[] data) {
        this.arr = data;
    }

    final E[] getData() {
        if (this.arr == null) {
            return this.newElementArray(0);
        }
        return this.arr;
    }

    final int removeAll(Collection c, int start, int size) {
        int ssize = c.size();
        if (ssize == 0) {
            return 0;
        }
        E[] old = this.getData();
        int arrsize = old.length;
        if (arrsize == 0) {
            return 0;
        }
        Object[] data = new Object[size];
        int j = 0;
        for (int i = start; i < start + size; ++i) {
            if (c.contains(old[i])) continue;
            data[j++] = old[i];
        }
        if (j != size) {
            E[] result = this.newElementArray(arrsize - (size - j));
            System.arraycopy(old, 0, result, 0, start);
            System.arraycopy(data, 0, result, start, j);
            System.arraycopy(old, start + size, result, start + j, arrsize - (start + size));
            this.setData(result);
            return size - j;
        }
        return 0;
    }

    int retainAll(Collection c, int start, int size) {
        E[] old = this.getData();
        if (size == 0) {
            return 0;
        }
        if (c.size() == 0) {
            E[] data;
            if (size == old.length) {
                data = this.newElementArray(0);
            } else {
                data = this.newElementArray(old.length - size);
                System.arraycopy(old, 0, data, 0, start);
                System.arraycopy(old, start + size, data, start, old.length - start - size);
            }
            this.setData(data);
            return size;
        }
        Object[] temp = new Object[size];
        int pos = 0;
        for (int i = start; i < start + size; ++i) {
            if (!c.contains(old[i])) continue;
            temp[pos++] = old[i];
        }
        if (pos == size) {
            return 0;
        }
        E[] data = this.newElementArray(pos + old.length - size);
        System.arraycopy(old, 0, data, 0, start);
        System.arraycopy(temp, 0, data, start, pos);
        System.arraycopy(old, start + size, data, start + pos, old.length - start - size);
        this.setData(data);
        return size - pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    E removeRange(int start, int size) {
        this.lock.lock();
        try {
            int sizeArr = this.size();
            CopyOnWriteArrayIdentityList.checkIndexExlusive(start, sizeArr);
            CopyOnWriteArrayIdentityList.checkIndexInclusive(start + size, sizeArr);
            E[] data = this.newElementArray(sizeArr - size);
            E[] oldArr = this.getData();
            System.arraycopy(oldArr, 0, data, 0, start);
            E old = oldArr[start];
            if (sizeArr > start + size) {
                System.arraycopy(oldArr, start + size, data, start, sizeArr - (start + size));
            }
            this.setData(data);
            E e = old;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    static Object[] toArray(Object[] data, int start, int size) {
        Object[] result = new Object[size];
        System.arraycopy(data, start, result, 0, size);
        return result;
    }

    static Object[] toArray(Object[] to, Object[] data, int start, int size) {
        int l = data.length;
        if (to.length < l) {
            to = (Object[])Array.newInstance(to.getClass().getComponentType(), l);
        } else if (to.length > l) {
            to[l] = null;
        }
        System.arraycopy(data, start, to, 0, size);
        return to;
    }

    static final boolean containsAll(Collection c, Object[] data, int start, int size) {
        if (size == 0) {
            return false;
        }
        for (Object next : c) {
            if (CopyOnWriteArrayIdentityList.indexOf(next, data, start, size) >= 0) continue;
            return false;
        }
        return true;
    }

    static final int lastIndexOf(Object o, Object[] data, int start, int size) {
        if (size == 0) {
            return -1;
        }
        for (int i = start + size - 1; i > start - 1; --i) {
            if (data[i] != o) continue;
            return i;
        }
        return -1;
    }

    static final int indexOf(Object o, Object[] data, int start, int size) {
        if (size == 0) {
            return -1;
        }
        for (int i = start; i < start + size; ++i) {
            if (data[i] != o) continue;
            return i;
        }
        return -1;
    }

    static final void checkIndexInclusive(int index, int size) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException("Index is " + index + ", size is " + size);
        }
    }

    static final void checkIndexExlusive(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index is " + index + ", size is " + size);
        }
    }

    final E[] getArray() {
        return this.arr;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        E[] back = this.getData();
        int size = back.length;
        oos.defaultWriteObject();
        oos.writeInt(size);
        for (E aBack : back) {
            oos.writeObject(aBack);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int length = ois.readInt();
        if (length == 0) {
            this.setData(this.newElementArray(0));
        } else {
            E[] back = this.newElementArray(length);
            for (int i = 0; i < back.length; ++i) {
                back[i] = ois.readObject();
            }
            this.setData(back);
        }
    }

    static class SubList
    implements List {
        private final CopyOnWriteArrayIdentityList list;
        private volatile SubListReadData read;
        private final int start;

        public SubList(CopyOnWriteArrayIdentityList list, int fromIdx, int toIdx) {
            this.list = list;
            E[] data = list.getData();
            int size = toIdx - fromIdx;
            CopyOnWriteArrayIdentityList.checkIndexExlusive(fromIdx, data.length);
            CopyOnWriteArrayIdentityList.checkIndexInclusive(toIdx, data.length);
            this.read = new SubListReadData(size, list.getData());
            this.start = fromIdx;
        }

        private void checkModifications() {
            if (this.read.data != this.list.getData()) {
                throw new ConcurrentModificationException();
            }
        }

        public ListIterator listIterator(int startIdx) {
            return new SubListIterator(startIdx, this.read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object obj) {
            this.list.lock.lock();
            try {
                CopyOnWriteArrayIdentityList.checkIndexExlusive(index, this.read.size);
                this.checkModifications();
                Object result = this.list.set(index + this.start, obj);
                this.read = new SubListReadData(this.read.size, this.list.getData());
                Object object = result;
                return object;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        public Object get(int index) {
            SubListReadData data = this.read;
            if (data.data != this.list.getData()) {
                this.list.lock.lock();
                try {
                    data = this.read;
                    if (data.data != this.list.getData()) {
                        throw new ConcurrentModificationException();
                    }
                }
                finally {
                    this.list.lock.unlock();
                }
            }
            CopyOnWriteArrayIdentityList.checkIndexExlusive(index, data.size);
            return data.data[index + this.start];
        }

        @Override
        public int size() {
            return this.read.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            this.list.lock.lock();
            try {
                CopyOnWriteArrayIdentityList.checkIndexExlusive(index, this.read.size);
                this.checkModifications();
                Object obj = this.list.remove(index + this.start);
                this.read = new SubListReadData(this.read.size - 1, this.list.getData());
                Object e = obj;
                return e;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        public void add(int index, Object object) {
            this.list.lock.lock();
            try {
                CopyOnWriteArrayIdentityList.checkIndexInclusive(index, this.read.size);
                this.checkModifications();
                this.list.add(index + this.start, object);
                this.read = new SubListReadData(this.read.size + 1, this.list.getData());
            }
            finally {
                this.list.lock.unlock();
            }
        }

        @Override
        public boolean add(Object o) {
            this.list.lock.lock();
            try {
                this.checkModifications();
                this.list.add(this.start + this.read.size, o);
                this.read = new SubListReadData(this.read.size + 1, this.list.getData());
                boolean bl = true;
                return bl;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection c) {
            this.list.lock.lock();
            try {
                this.checkModifications();
                int d = this.list.size();
                this.list.addAll(this.start + this.read.size, c);
                this.read = new SubListReadData(this.read.size + (this.list.size() - d), this.list.getData());
                boolean bl = true;
                return bl;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        @Override
        public void clear() {
            this.list.lock.lock();
            try {
                this.checkModifications();
                this.list.removeRange(this.start, this.read.size);
                this.read = new SubListReadData(0, this.list.getData());
            }
            finally {
                this.list.lock.unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public boolean containsAll(Collection c) {
            SubListReadData b = this.read;
            return CopyOnWriteArrayIdentityList.containsAll(c, b.data, this.start, b.size);
        }

        @Override
        public int indexOf(Object o) {
            SubListReadData b = this.read;
            int ind = CopyOnWriteArrayIdentityList.indexOf(o, b.data, this.start, b.size) - this.start;
            return ind < 0 ? -1 : ind;
        }

        @Override
        public boolean isEmpty() {
            return this.read.size == 0;
        }

        @Override
        public Iterator iterator() {
            return new SubListIterator(0, this.read);
        }

        @Override
        public int lastIndexOf(Object o) {
            SubListReadData b = this.read;
            int ind = CopyOnWriteArrayIdentityList.lastIndexOf(o, b.data, this.start, b.size) - this.start;
            return ind < 0 ? -1 : ind;
        }

        public ListIterator listIterator() {
            return new SubListIterator(0, this.read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            this.list.lock.lock();
            try {
                boolean result;
                this.checkModifications();
                int i = this.indexOf(o);
                if (i == -1) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = result = this.list.remove(i + this.start) != null;
                if (result) {
                    this.read = new SubListReadData(this.read.size - 1, this.list.getData());
                }
                boolean bl2 = result;
                return bl2;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection c) {
            this.list.lock.lock();
            try {
                this.checkModifications();
                int removed = this.list.removeAll(c, this.start, this.read.size);
                if (removed > 0) {
                    this.read = new SubListReadData(this.read.size - removed, this.list.getData());
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.list.lock.unlock();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection c) {
            this.list.lock.lock();
            try {
                this.checkModifications();
                int removed = this.list.retainAll(c, this.start, this.read.size);
                if (removed > 0) {
                    this.read = new SubListReadData(this.read.size - removed, this.list.getData());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        public List subList(int fromIndex, int toIndex) {
            return new SubList(this.list, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public Object[] toArray() {
            SubListReadData r = this.read;
            return CopyOnWriteArrayIdentityList.toArray(r.data, this.start, r.size);
        }

        @Override
        public Object[] toArray(Object[] a) {
            SubListReadData r = this.read;
            return CopyOnWriteArrayIdentityList.toArray(a, r.data, this.start, r.size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection collection) {
            this.list.lock.lock();
            try {
                CopyOnWriteArrayIdentityList.checkIndexInclusive(index, this.read.size);
                this.checkModifications();
                int d = this.list.size();
                boolean rt = this.list.addAll(index + this.start, collection);
                this.read = new SubListReadData(this.read.size + this.list.size() - d, this.list.getData());
                boolean bl = rt;
                return bl;
            }
            finally {
                this.list.lock.unlock();
            }
        }

        private class SubListIterator
        extends ListIteratorImpl {
            private final SubListReadData dataR;

            private SubListIterator(int index, SubListReadData d) {
                super(d.data, index + SubList.this.start);
                this.dataR = d;
            }

            @Override
            public int nextIndex() {
                return super.nextIndex() - SubList.this.start;
            }

            @Override
            public int previousIndex() {
                return super.previousIndex() - SubList.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < this.dataR.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() > -1;
            }
        }
    }

    static final class SubListReadData {
        final int size;
        final Object[] data;

        SubListReadData(int size, Object[] data) {
            this.size = size;
            this.data = data;
        }
    }

    private static class ListIteratorImpl
    implements ListIterator {
        private final Object[] arr;
        private int current;
        private final int size;

        final int size() {
            return this.size;
        }

        public ListIteratorImpl(Object[] data, int current) {
            this.current = current;
            this.arr = data;
            this.size = data.length;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("Unsupported operation add");
        }

        @Override
        public boolean hasNext() {
            return this.current < this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.current > 0;
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return this.arr[this.current++];
            }
            throw new NoSuchElementException("pos is " + this.current + ", size is " + this.size);
        }

        @Override
        public int nextIndex() {
            return this.current;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.arr[--this.current];
            }
            throw new NoSuchElementException("pos is " + (this.current - 1) + ", size is " + this.size);
        }

        @Override
        public int previousIndex() {
            return this.current - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported operation remove");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("Unsupported operation set");
        }
    }
}

