/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.util.AbstractAlgorithmParametersSpiImpl;

public final class DigestPasswordAlgorithmParametersSpiImpl
extends AbstractAlgorithmParametersSpiImpl<DigestPasswordAlgorithmSpec> {
    protected Class<DigestPasswordAlgorithmSpec> getParameterType() {
        return DigestPasswordAlgorithmSpec.class;
    }

    protected void engineEncode(ASN1Encoder encoder, DigestPasswordAlgorithmSpec parameterSpec) {
        encoder.startSequence();
        encoder.encodeOctetString(parameterSpec.getUsername());
        encoder.encodeOctetString(parameterSpec.getRealm());
        encoder.endSequence();
    }

    protected DigestPasswordAlgorithmSpec engineDecode(ASN1Decoder decoder) {
        decoder.startSequence();
        String username = decoder.decodeOctetStringAsString();
        String realm = decoder.decodeOctetStringAsString();
        decoder.endSequence();
        return new DigestPasswordAlgorithmSpec(username, realm);
    }
}

