/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.xml.XmlElement;
import icons.MavenIcons;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;
import org.jetbrains.idea.maven.navigator.structure.MavenGoalNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.PluginNode;

class PluginGoalNode
extends MavenGoalNode {
    private final String myUnqualifiedGoal;

    PluginGoalNode(MavenProjectsStructure structure, PluginNode parent, String goal, String unqualifiedGoal, String displayName) {
        super(structure, parent, goal, displayName);
        this.getTemplatePresentation().setIcon(MavenIcons.PluginGoal);
        this.myUnqualifiedGoal = unqualifiedGoal;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        PluginNode pluginNode = (PluginNode)this.getParent();
        MavenDomPluginModel pluginModel = MavenPluginDomUtil.getMavenPluginModel(this.myProject, pluginNode.getPlugin().getGroupId(), pluginNode.getPlugin().getArtifactId(), pluginNode.getPlugin().getVersion());
        if (pluginModel == null) {
            return null;
        }
        for (MavenDomMojo mojo : pluginModel.getMojos().getMojos()) {
            final XmlElement xmlElement = mojo.getGoal().getXmlElement();
            if (!(xmlElement instanceof Navigatable) || !Objects.equals(this.myUnqualifiedGoal, mojo.getGoal().getStringValue())) continue;
            return new NavigatableAdapter(){

                public void navigate(boolean requestFocus) {
                    ((Navigatable)xmlElement).navigate(requestFocus);
                }
            };
        }
        return null;
    }
}

