/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.api.AllocationSizeMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithOptionalUnits;
import com.intellij.profiler.ui.JBRunnerClosableTabs;
import com.intellij.profiler.ui.LazyPanel;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.treetable.MouseAwareTreeCellRendererPanel;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiTree;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitorWithComparator;
import com.intellij.profiler.ultimate.hprof.ui.ActionsKt;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewComponentTab;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel;
import com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanelKt;
import com.intellij.profiler.ultimate.hprof.ui.OnePercentProgressIndicator;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.RetainedObject;
import com.intellij.profiler.ultimate.hprof.ui.ReverseReferencePanel;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanel;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelElement;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u00072\u00020\b:\u0002@AB]\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u0012\u001a\b\u0002\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0014\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010J\u001e\u0010(\u001a\u00020&2\b\b\u0001\u0010)\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+J\u0006\u0010,\u001a\u00020&J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f00J\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u00102\b\u00104\u001a\u0004\u0018\u00010\u001fH\u0002J\n\u00105\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u00106\u001a\u00020\u000eH\u0017J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u000208H\u0016J\f\u0010:\u001a\u00020&*\u00020\bH\u0002J\b\u0010;\u001a\u00020&H\u0016J\b\u0010<\u001a\u00020&H\u0016J\u0010\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020?H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00100\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewComponentTab$Closable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "view", "Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;", "tabName", "", "objects", "", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "classToObject", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/hprof/ui/MemoryViewTopLevelComponent;Ljava/lang/String;Ljava/util/List;Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;Lkotlin/jvm/functions/Function1;)V", "getObjects", "()Ljava/util/List;", "getSnapshot", "()Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "table", "Lcom/intellij/ui/components/JBTreeTable;", "cache", "Ljava/util/WeakHashMap;", "", "Lcom/intellij/profiler/ultimate/hprof/ui/TextFragment;", "emptyText", "Lcom/intellij/util/ui/StatusText;", "getEmptyText", "()Lcom/intellij/util/ui/StatusText;", "addResults", "", "list", "addTrailingLink", "text", "action", "Lkotlin/Function0;", "removeTrailingLink", "count", "", "elements", "", "Null", "Ljava/lang/Object;", "createTextFragments", "value", "getSelectedValue", "getTabName", "createRightComponent", "Ljavax/swing/JComponent;", "createCenterComponent", "cancelIfDisposed", "onClose", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "Listener", "MyLink", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nObjectViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectViewPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,602:1\n1563#2:603\n1634#2,3:604\n*S KotlinDebug\n*F\n+ 1 ObjectViewPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel\n*L\n177#1:603\n177#1:604,3\n*E\n"})
public final class ObjectViewPanel<T extends MuiType, I extends MuiInstance>
extends BorderLayoutPanel
implements MemoryViewComponentTab.Closable,
UiDataProvider,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MemoryViewTopLevelComponent view;
    @NotNull
    private final String tabName;
    @NotNull
    private final List<?> objects;
    @NotNull
    private final MuiSnapshot<T, I> snapshot;
    @NotNull
    private final JBTreeTable table;
    @NotNull
    private final WeakHashMap<Object, List<TextFragment>> cache;
    @NotNull
    private final Object Null;

    public ObjectViewPanel(@NotNull Project project, @NotNull MemoryViewTopLevelComponent view, @Nls @NotNull String tabName, @NotNull List<?> objects, @NotNull MuiSnapshot<T, I> snapshot, @NotNull Function1<? super MuiType, ? extends List<? extends MuiInstance>> classToObject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter(classToObject, (String)"classToObject");
        this.project = project;
        this.view = view;
        this.tabName = tabName;
        this.objects = objects;
        this.snapshot = snapshot;
        this.table = new JBTreeTable((TreeTableModel)new ObjectTreeTableModel(this.snapshot, this.objects, classToObject));
        this.cache = new WeakHashMap();
        int columnPreferredWidth = this.view.getFontMetrics(this.view.getFont()).stringWidth("999,999,999,999");
        this.table.setColumnProportion(Math.min(Math.max((float)columnPreferredWidth / ((float)this.view.getWidth() / 2.0f), 0.1f), 0.4f));
        this.table.getTree().putClientProperty((Object)DefaultTreeUI.LARGE_MODEL_ALLOWED, (Object)true);
        this.table.getTree().setLargeModel(true);
        this.table.getTable().setFocusable(false);
        this.table.getTable().getEmptyText().clear();
        ProfilerUIUtilsKt.applyDefaultBackground((JBTreeTable)this.table);
        Tree tree2 = this.table.getTree();
        this.table.getTree().setCellRenderer((TreeCellRenderer)new MouseAwareTreeCellRendererPanel(tree2){
            private final SimpleColoredComponent coloredComponent;
            private final ActionLink actionLink;
            private final ActionLink[] highlighters;
            {
                super((JTree)$super_call_param$1);
                this.coloredComponent = new SimpleColoredComponent();
                this.actionLink = new ActionLink();
                ActionLink[] actionLinkArray = new ActionLink[]{this.actionLink};
                this.highlighters = actionLinkArray;
                this.setLayout((LayoutManager)new HorizontalLayout(0, 0, 2, null));
                this.add((Component)this.coloredComponent);
                this.add((Component)this.actionLink);
            }

            public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                boolean selectedAndFocused;
                Color color;
                this.coloredComponent.clear();
                this.actionLink.setText("");
                if (selected) {
                    color = UIUtil.getTableSelectionBackground((boolean)hasFocus);
                } else {
                    JTree jTree = tree2;
                    color = jTree != null ? jTree.getBackground() : null;
                }
                this.setBackground(color);
                boolean bl = selectedAndFocused = selected && table.hasFocus();
                if (value instanceof ObjectTreeTableModel.Wrapper && ((ObjectTreeTableModel.Wrapper)value).getValue() instanceof MyLink) {
                    this.actionLink.setText(((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getText());
                    this.actionLink.setForeground(!((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getActive() && !selectedAndFocused ? UIUtil.getLabelDisabledForeground() : (selectedAndFocused ? UIUtil.getTableForeground((boolean)selected, (boolean)hasFocus) : JBUI.CurrentTheme.Link.Foreground.ENABLED));
                    this.actionLink.getModel().setRollover(this.getHighlightedComponent() == this.actionLink && this.getHighlightedRow() == row);
                } else {
                    try {
                        Iterable $this$forEach$iv = this.createTextFragments(value);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Color fg;
                            TextFragment it = (TextFragment)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)UIUtil.getTreeSelectionForeground((boolean)selectedAndFocused), (String)"getTreeSelectionForeground(...)");
                            this.coloredComponent.append(it.getText(), selectedAndFocused ? new SimpleTextAttributes(it.getAttributes().getStyle(), fg) : it.getAttributes());
                        }
                        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((JComponent)table.getTree()), (SimpleColoredComponent)this.coloredComponent, (boolean)false, (boolean)selected);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return (Component)((Object)this);
            }

            protected ActionLink[] getHighlightables() {
                return this.highlighters;
            }

            public boolean isHighlightEnabled(int row, Object value) {
                return value instanceof ObjectTreeTableModel.Wrapper && ((ObjectTreeTableModel.Wrapper)value).getValue() instanceof MyLink && ((MyLink)((ObjectTreeTableModel.Wrapper)value).getValue()).getActive();
            }

            protected void mouseClicked(MouseEvent event) {
                Object object = this.getHighlightedValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel.Wrapper");
                Object object2 = ((ObjectTreeTableModel.Wrapper)object).getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel.MyLink");
                MyLink $this$mouseClicked_u24lambda_u242 = (MyLink)object2;
                boolean bl = false;
                boolean bl2 = $this$mouseClicked_u24lambda_u242.getActive();
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl3 = false;
                    String string = "Disabled link clicked";
                    throw new AssertionError((Object)string);
                }
                $this$mouseClicked_u24lambda_u242.setActive(false);
                $this$mouseClicked_u24lambda_u242.getAction().invoke();
            }
        });
        this.table.getTable().setDefaultRenderer(Long.TYPE, (TableCellRenderer)new DefaultTableCellRenderer(){
            private final ValueMetricPrinter metricPrinter = (ValueMetricPrinter)new ValueMetricPrinterWithOptionalUnits((ValueMetricPrinter)ValueMetricPrinter.Default.INSTANCE);
            {
                this.setHorizontalAlignment(4);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color color;
                Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                if (isSelected) {
                    color = UIUtil.getTableSelectionBackground((boolean)table.hasFocus());
                } else {
                    JTable jTable = table2;
                    color = jTable != null ? jTable.getBackground() : null;
                }
                component.setBackground(color);
                component.setForeground(value instanceof Long && ((Number)value).longValue() < 0L ? NamedColorUtil.getInactiveTextColor() : UIUtil.getTableForeground((boolean)isSelected, (boolean)table.hasFocus()));
                Intrinsics.checkNotNull((Object)component);
                return component;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void setValue(Object value) {
                Object object;
                3 v0;
                block5: {
                    block4: {
                        void it;
                        v0 = this;
                        Object $this$asSafely$iv = value;
                        boolean $i$f$asSafely = false;
                        Object object2 = $this$asSafely$iv;
                        if (!(object2 instanceof Long)) {
                            object2 = null;
                        }
                        if ((object = (Long)object2) == null) break block4;
                        long l = ((Number)object).longValue();
                        3 var7_5 = v0;
                        boolean bl = false;
                        String string = it < 0L ? UltimateProfilerBundleKt.profilerMessage("hprof.object.view.na", new Object[0]) : this.metricPrinter.print((ValueMetric)AllocationSizeMetric.INSTANCE, (long)it);
                        v0 = var7_5;
                        object = string;
                        if (string != null) break block5;
                    }
                    object = "";
                }
                v0.setText((String)object);
            }
        });
        TreeSpeedSearch.installOn((JTree)((JTree)this.table.getTree()), (boolean)false, arg_0 -> ObjectViewPanel._init_$lambda$2(arg_0 -> ObjectViewPanel._init_$lambda$1(this, arg_0), arg_0));
        Tree tree3 = this.table.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree3, (String)"getTree(...)");
        ActionsKt.installActions(tree3, this.view, this.snapshot, (Function1<? super TreePath, ? extends Object>)((Function1)ObjectViewPanel::_init_$lambda$3));
        this.addToCenter((Component)this.table);
        Disposer.register((Disposable)this.view, (Disposable)this);
        this.Null = new Object();
    }

    public /* synthetic */ ObjectViewPanel(Project project, MemoryViewTopLevelComponent memoryViewTopLevelComponent, String string, List list, MuiSnapshot muiSnapshot, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = ObjectViewPanel::_init_$lambda$0;
        }
        this(project, memoryViewTopLevelComponent, string, list, muiSnapshot, (Function1<? super MuiType, ? extends List<? extends MuiInstance>>)function1);
    }

    @NotNull
    public final List<?> getObjects() {
        return this.objects;
    }

    @NotNull
    public final MuiSnapshot<T, I> getSnapshot() {
        return this.snapshot;
    }

    @NotNull
    public final StatusText getEmptyText() {
        StatusText statusText = this.table.getTree().getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        return statusText;
    }

    public final void addResults(@NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        TreeTableModel treeTableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        ObjectTreeTableModel model2 = (ObjectTreeTableModel)treeTableModel;
        boolean isEmptyModel = model2.getSize() == 0;
        model2.addAll(list);
        if (isEmptyModel) {
            this.table.getTree().expandPath(new TreePath(this.table.getModel().getRoot()));
            this.table.getTree().setSelectionRow(0);
        }
    }

    public final void addTrailingLink(@Nls @NotNull String text, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.removeTrailingLink();
        this.addResults(CollectionsKt.listOf((Object)new MyLink(text, action)));
    }

    public final void removeTrailingLink() {
        TreeTableModel treeTableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        ObjectTreeTableModel model2 = (ObjectTreeTableModel)treeTableModel;
        model2.removeLastIf((Function1<Object, Boolean>)((Function1)ObjectViewPanel::removeTrailingLink$lambda$4));
    }

    public final int count() {
        TreeTableModel treeTableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        return ((ObjectTreeTableModel)treeTableModel).getSize();
    }

    @NotNull
    public final Iterator<Object> elements() {
        TreeTableModel treeTableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)treeTableModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.ui.ObjectTreeTableModel");
        ObjectTreeTableModel model2 = (ObjectTreeTableModel)treeTableModel;
        return new Iterator<Object>(model2){
            private final Iterator<ObjectTreeTableModel.Wrapper> delegate;
            {
                this.delegate = $model.getObjects().iterator();
            }

            public final Iterator<ObjectTreeTableModel.Wrapper> getDelegate() {
                return this.delegate;
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                return this.delegate.next().getValue();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private final List<TextFragment> createTextFragments(Object value) {
        Object object = value instanceof ObjectTreeTableModel.Wrapper ? ((ObjectTreeTableModel.Wrapper)value).getValue() : value;
        if (object == null) {
            object = this.Null;
        }
        Object v = object;
        List list = this.cache.computeIfAbsent(v, arg_0 -> ObjectViewPanel.createTextFragments$lambda$5(v, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        return list;
    }

    private final MuiInstance getSelectedValue() {
        MuiInstance muiInstance;
        Object object = this.table.getTree().getSelectionPath();
        if (object != null && (object = ((TreePath)object).getLastPathComponent()) != null) {
            Object it = object;
            boolean bl = false;
            muiInstance = ActionsKt.getMuiInstanceOrNull(ObjectViewPanelKt.access$tryUnwrapOrSelf(it));
        } else {
            muiInstance = null;
        }
        return muiInstance;
    }

    @Override
    @Nls
    @NotNull
    public String getTabName() {
        return this.tabName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JComponent createRightComponent() {
        void $this$createRightComponent_u24lambda_u2419;
        LazyPanel $this$createRightComponent_u24lambda_u2416;
        LazyPanel $this$createRightComponent_u24lambda_u2412;
        LazyPanel $this$createRightComponent_u24lambda_u2410;
        LazyPanel $this$createRightComponent_u24lambda_u248;
        LazyPanel lazyPanel2;
        JBRunnerClosableTabs tabs = new JBRunnerClosableTabs(this.project, (Disposable)this.view);
        boolean autoload = this.snapshot.isAutoload();
        LazyPanel lazyPanel3 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.shortest.paths", new Object[0]), false, autoload, false, arg_0 -> ObjectViewPanel.createRightComponent$lambda$7(this, arg_0), 20, null);
        JBRunnerClosableTabs jBRunnerClosableTabs = tabs;
        boolean bl = false;
        $this$createRightComponent_u24lambda_u248.setEnabled(false);
        this.table.getTree().getSelectionModel().addTreeSelectionListener(new Listener($this$createRightComponent_u24lambda_u248));
        Disposer.register((Disposable)this.view, (Disposable)((Disposable)$this$createRightComponent_u24lambda_u248));
        JComponent jComponent = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.shortest.paths", new Object[0])));
        $this$createRightComponent_u24lambda_u248 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.references", new Object[0]), false, autoload, false, arg_0 -> ObjectViewPanel.createRightComponent$lambda$9(this, arg_0), 20, null);
        jBRunnerClosableTabs = tabs;
        boolean bl2 = false;
        $this$createRightComponent_u24lambda_u2410.setEnabled(false);
        this.table.getTree().getSelectionModel().addTreeSelectionListener(new Listener($this$createRightComponent_u24lambda_u2410));
        Disposer.register((Disposable)this.view, (Disposable)((Disposable)$this$createRightComponent_u24lambda_u2410));
        JComponent jComponent2 = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent2).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.references", new Object[0])));
        $this$createRightComponent_u24lambda_u2410 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.dominators", new Object[0]), false, autoload, false, arg_0 -> ObjectViewPanel.createRightComponent$lambda$11(this, arg_0), 20, null);
        jBRunnerClosableTabs = tabs;
        boolean bl3 = false;
        $this$createRightComponent_u24lambda_u2412.setEnabled(false);
        this.table.getTree().getSelectionModel().addTreeSelectionListener(new Listener($this$createRightComponent_u24lambda_u2412));
        Disposer.register((Disposable)this.view, (Disposable)((Disposable)$this$createRightComponent_u24lambda_u2412));
        JComponent jComponent3 = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent3).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.dominators", new Object[0])));
        $this$createRightComponent_u24lambda_u2412 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.retained.objects", new Object[0]), false, autoload, false, arg_0 -> ObjectViewPanel.createRightComponent$lambda$15(this, arg_0), 20, null);
        jBRunnerClosableTabs = tabs;
        boolean bl4 = false;
        $this$createRightComponent_u24lambda_u2416.setEnabled(false);
        this.table.getTree().getSelectionModel().addTreeSelectionListener(new Listener($this$createRightComponent_u24lambda_u2416));
        Disposer.register((Disposable)this.view, (Disposable)((Disposable)$this$createRightComponent_u24lambda_u2416));
        JComponent jComponent4 = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent4).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.retained.objects", new Object[0])));
        $this$createRightComponent_u24lambda_u2416 = lazyPanel2 = new LazyPanel(this.project, UltimateProfilerBundleKt.profilerMessage("hprof.action.open.retained.objects", new Object[0]), false, autoload, false, arg_0 -> ObjectViewPanel.createRightComponent$lambda$18(this, arg_0), 20, null);
        jBRunnerClosableTabs = tabs;
        boolean bl5 = false;
        $this$createRightComponent_u24lambda_u2419.setEnabled(false);
        this.table.getTree().getSelectionModel().addTreeSelectionListener(new Listener((LazyPanel<?>)$this$createRightComponent_u24lambda_u2419));
        Disposer.register((Disposable)this.view, (Disposable)((Disposable)$this$createRightComponent_u24lambda_u2419));
        JComponent jComponent5 = (JComponent)lazyPanel2;
        jBRunnerClosableTabs.addTab(new TabInfo(jComponent5).setText(UltimateProfilerBundleKt.profilerMessage("hprof.tab.retained.dominators", new Object[0])));
        return (JComponent)tabs;
    }

    @Override
    @NotNull
    public JComponent createCenterComponent() {
        return (JComponent)((Object)this);
    }

    private final void cancelIfDisposed(Disposable $this$cancelIfDisposed) throws ProcessCanceledException {
        if (Disposer.isDisposed((Disposable)$this$cancelIfDisposed)) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void onClose() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.removeAll();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)new TextCopyProvider(this){
            final /* synthetic */ ObjectViewPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            /*
             * WARNING - void declaration
             */
            public Collection<String> getTextLinesToCopy() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                StringBuilder stringBuilder;
                TreePath treePath = ObjectViewPanel.access$getTable$p(this.this$0).getTree().getSelectionPath();
                if (treePath == null) {
                    return null;
                }
                TreePath selectionPath = treePath;
                Object value = selectionPath.getLastPathComponent();
                List fragments = ObjectViewPanel.access$createTextFragments(this.this$0, value);
                if (fragments.isEmpty()) {
                    return null;
                }
                StringBuilder $this$getTextLinesToCopy_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Iterable iterable = fragments;
                StringBuilder stringBuilder2 = $this$getTextLinesToCopy_u24lambda_u240;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    TextFragment textFragment = (TextFragment)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.getText());
                }
                stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
                boolean includeAddress = Registry.Companion.is("idea.profiler.hprof.show.objectAddress", false);
                if (!includeAddress) {
                    Object v = ObjectViewPanelKt.access$tryUnwrapOrSelf(value);
                    if (v instanceof MuiInstance) {
                        $this$getTextLinesToCopy_u24lambda_u240.append(" 0x" + Long.toHexString(((MuiInstance)v).getId()));
                    } else if (v instanceof MuiType) {
                        $this$getTextLinesToCopy_u24lambda_u240.append(" 0x" + Long.toHexString(((MuiType)v).getId()));
                    }
                }
                return CollectionsKt.listOf((Object)stringBuilder.toString());
            }
        });
    }

    private static final List _init_$lambda$0(MuiType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final String _init_$lambda$1(ObjectViewPanel this$0, TreePath it) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.createTextFragments(it.getLastPathComponent());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TextFragment textFragment = (TextFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getText());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Object _init_$lambda$3(TreePath it) {
        TreePath treePath = it;
        return ObjectViewPanelKt.access$tryUnwrapOrSelf(treePath != null ? treePath.getLastPathComponent() : null);
    }

    private static final boolean removeTrailingLink$lambda$4(Object it) {
        return it instanceof MyLink;
    }

    private static final List createTextFragments$lambda$5(Object $v, ObjectViewPanel this$0, Object it) {
        return RenderUtilsKt.createTextFragments($v, this$0.snapshot);
    }

    private static final ReverseReferencePanel.ShortestPaths createRightComponent$lambda$7(ObjectViewPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MuiSnapshot muiSnapshot = this$0.snapshot;
        MuiInstance muiInstance = this$0.getSelectedValue();
        Intrinsics.checkNotNull((Object)muiInstance);
        MuiTree paths = muiSnapshot.getShortestPaths(muiInstance.getId(), indicator);
        this$0.cancelIfDisposed(this$0);
        return new ReverseReferencePanel.ShortestPaths(this$0.view, this$0.snapshot, paths, this$0);
    }

    private static final ReverseReferencePanel.Simple createRightComponent$lambda$9(ObjectViewPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MuiInstance muiInstance = this$0.getSelectedValue();
        if (muiInstance == null) {
            throw new IllegalStateException("selected null value");
        }
        this$0.snapshot.getReverseReferences(muiInstance.getId(), 1000, indicator);
        this$0.cancelIfDisposed(this$0);
        return new ReverseReferencePanel.Simple(this$0.view, this$0.snapshot, this$0.getSelectedValue(), this$0);
    }

    private static final ReverseReferencePanel.Dominators createRightComponent$lambda$11(ObjectViewPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MuiInstance muiInstance = this$0.getSelectedValue();
        if (muiInstance == null) {
            throw new IllegalStateException("selected null value");
        }
        this$0.snapshot.getDominator(muiInstance.getId(), indicator);
        this$0.cancelIfDisposed(this$0);
        return new ReverseReferencePanel.Dominators(this$0.view, this$0.snapshot, this$0.getSelectedValue(), this$0);
    }

    private static final void createRightComponent$lambda$15$lambda$14(ObjectViewPanel this$0, ProgressIndicator d, double d2) {
        if (Disposer.isDisposed((Disposable)this$0)) {
            throw new ProcessCanceledException();
        }
        d.checkCanceled();
    }

    private static final createRightComponent.7.panel.1 createRightComponent$lambda$15(ObjectViewPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MuiInstance muiInstance = this$0.getSelectedValue();
        if (muiInstance == null) {
            throw new IllegalStateException("selected null value");
        }
        MuiInstance selectedValue = muiInstance;
        long selected = selectedValue.getId();
        MuiVisitorWithComparator visitor2 = new MuiVisitorWithComparator(0, 100000, ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MuiInstance p0 = (MuiInstance)a;
                boolean bl = false;
                Comparable comparable = p0.getRetainedSize();
                p0 = (MuiInstance)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)p0.getRetainedSize());
            }
        }).reversed(), 1, null);
        indicator.setIndeterminate(false);
        this$0.snapshot.getFlatRetained(selected, (ProgressIndicator)new OnePercentProgressIndicator(indicator, (arg_0, arg_1) -> ObjectViewPanel.createRightComponent$lambda$15$lambda$14(this$0, arg_0, arg_1)), visitor2);
        List objects = visitor2.getResult();
        Intrinsics.checkNotNull(objects, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<I of com.intellij.profiler.ultimate.hprof.ui.ObjectViewPanel>");
        Object i = this$0.snapshot.getInstanceById(selected);
        if (i == null) {
            throw new IllegalStateException(("Cannot get object with id " + selected + " from the snapshot").toString());
        }
        TypeIntrinsics.asMutableList(objects).add(i);
        Project project = this$0.project;
        SunburstPanel panel2 = new SunburstPanel<T, I>(objects, selected, this$0, project){
            final /* synthetic */ List<I> $objects;
            final /* synthetic */ long $selected;
            final /* synthetic */ ObjectViewPanel<T, I> this$0;
            {
                this.$objects = $objects;
                this.$selected = $selected;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public SunburstPanelModel doCalculate(MuiSnapshot<T, I> dump) {
                void $this$forEach$iv;
                void $this$associateByTo$iv$iv;
                Object object;
                Object object2;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(dump, (String)"dump");
                Iterable $this$map$iv = this.$objects;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    object2 = (MuiInstance)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(new RetainedObject((MuiInstance)p0));
                }
                Object $this$associateBy$iv = (List)destination$iv$iv;
                boolean $i$f$associateBy22 = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (E element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    RetainedObject bl = (RetainedObject)element$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl2 = false;
                    object.put(it.getInstance().getId(), element$iv$iv);
                }
                Map map = destination$iv$iv2;
                $this$associateBy$iv = map;
                long $i$f$associateBy22 = this.$selected;
                ObjectViewPanel<T, I> objectViewPanel = this.this$0;
                boolean $i$f$forEach = false;
                for (Map.Entry<K, V> element$iv : $this$forEach$iv.entrySet()) {
                    RetainedObject parent;
                    object2 = element$iv;
                    boolean bl = false;
                    long k = ((Number)object2.getKey()).longValue();
                    RetainedObject v = (RetainedObject)object2.getValue();
                    if ($i$f$associateBy22 == k) continue;
                    Long l = objectViewPanel.getSnapshot().getDominator(k, null);
                    Intrinsics.checkNotNull((Object)l);
                    long d = l;
                    if ((RetainedObject)map.get(d) == null) {
                        throw new IllegalStateException(("Cannot find object with id " + d).toString());
                    }
                    v.setParent(parent);
                    parent.getChildren().add(v);
                }
                Comparator<T> comparator2 = ((Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        SunburstPanelElement p0 = (SunburstPanelElement)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(p0.getSize());
                        p0 = (SunburstPanelElement)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getSize()));
                    }
                }).reversed();
                Iterable $this$forEach$iv2 = map.values();
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv2) {
                    RetainedObject it = (RetainedObject)element$iv;
                    boolean bl = false;
                    List<SunburstPanelElement> list = it.getChildren();
                    Intrinsics.checkNotNull(comparator2);
                    CollectionsKt.sortWith(list, comparator2);
                }
                return new SunburstPanelModel((SunburstPanelElement)map.get(this.$selected));
            }

            protected List<AnAction> createPopupActions(SunburstPanelElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof RetainedObject)) {
                    return super.createPopupActions(element);
                }
                return CollectionsKt.listOf((Object)DumbAwareAction.create((String)UltimateProfilerBundleKt.profilerMessage("hprof.action.open.new.tab", new Object[0]), arg_0 -> createRightComponent.7.panel.1.createPopupActions$lambda$5(arg_0 -> createRightComponent.7.panel.1.createPopupActions$lambda$4(element, this.this$0, this, arg_0), arg_0)));
            }

            private static final Unit createPopupActions$lambda$4(SunburstPanelElement $element, ObjectViewPanel this$0, createRightComponent.7.panel.1 this$1, AnActionEvent it) {
                MuiInstance instance = ((RetainedObject)$element).getInstance();
                String string = instance.getType().getShortName();
                String string2 = "0x%x";
                Object[] objectArray = new Object[]{instance.getId()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                String tabName = string + " " + string3;
                ObjectViewPanel.access$getView$p(this$0).addTab(new ObjectViewPanel<T, I>(this$1.getProject(), ObjectViewPanel.access$getView$p(this$0), tabName, CollectionsKt.listOf((Object)instance), this$0.getSnapshot(), null, 32, null));
                return Unit.INSTANCE;
            }

            private static final void createPopupActions$lambda$5(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
        panel2.updateDiagram(this$0.snapshot);
        return panel2;
    }

    private static final void createRightComponent$lambda$18$lambda$17(ObjectViewPanel this$0, ProgressIndicator d, double d2) {
        if (Disposer.isDisposed((Disposable)this$0)) {
            throw new ProcessCanceledException();
        }
        d.checkCanceled();
    }

    private static final ReverseReferencePanel.Retained createRightComponent$lambda$18(ObjectViewPanel this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setIndeterminate(false);
        this$0.snapshot.doCalculateRetainedSize((ProgressIndicator)new OnePercentProgressIndicator(indicator, (arg_0, arg_1) -> ObjectViewPanel.createRightComponent$lambda$18$lambda$17(this$0, arg_0, arg_1)));
        this$0.cancelIfDisposed(this$0);
        return new ReverseReferencePanel.Retained(this$0.view, this$0.snapshot, this$0.getSelectedValue(), this$0);
    }

    public static final /* synthetic */ MemoryViewTopLevelComponent access$getView$p(ObjectViewPanel $this) {
        return $this.view;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel$Listener;", "Ljavax/swing/event/TreeSelectionListener;", "lazyPanel", "Lcom/intellij/profiler/ui/LazyPanel;", "<init>", "(Lcom/intellij/profiler/ui/LazyPanel;)V", "getLazyPanel", "()Lcom/intellij/profiler/ui/LazyPanel;", "valueChanged", "", "e", "Ljavax/swing/event/TreeSelectionEvent;", "intellij.profiler.ultimate"})
    private static final class Listener
    implements TreeSelectionListener {
        @NotNull
        private final LazyPanel<?> lazyPanel;

        public Listener(@NotNull LazyPanel<?> lazyPanel2) {
            Intrinsics.checkNotNullParameter(lazyPanel2, (String)"lazyPanel");
            this.lazyPanel = lazyPanel2;
        }

        @NotNull
        public final LazyPanel<?> getLazyPanel() {
            return this.lazyPanel;
        }

        @Override
        public void valueChanged(@Nullable TreeSelectionEvent e) {
            MuiInstance muiInstance;
            Object object = e;
            if (object != null && (object = ((TreeSelectionEvent)object).getPath()) != null && (object = ((TreePath)object).getLastPathComponent()) != null) {
                Object it = object;
                boolean bl = false;
                muiInstance = ActionsKt.getMuiInstanceOrNull(ObjectViewPanelKt.access$tryUnwrapOrSelf(it));
            } else {
                muiInstance = null;
            }
            MuiInstance value = muiInstance;
            this.lazyPanel.clear();
            this.lazyPanel.setEnabled(value != null);
            if (this.lazyPanel.isAutoloadEnable()) {
                this.lazyPanel.loadLater(false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/ObjectViewPanel$MyLink;", "", "text", "", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "getAction", "()Lkotlin/jvm/functions/Function0;", "active", "", "getActive", "()Z", "setActive", "(Z)V", "intellij.profiler.ultimate"})
    private static final class MyLink {
        @NotNull
        private final String text;
        @NotNull
        private final Function0<Unit> action;
        private boolean active;

        public MyLink(@Nls @NotNull String text, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.text = text;
            this.action = action;
            this.active = true;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public final boolean getActive() {
            return this.active;
        }

        public final void setActive(boolean bl) {
            this.active = bl;
        }
    }
}

