/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeOption;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitMerge
extends GitMergeAction {
    GitMerge() {
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.message((String)"merge.action.name", (Object[])new Object[0]);
        if (string == null) {
            GitMerge.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitMergeDialog dialog;
        if (project == null) {
            GitMerge.$$$reportNull$$$0(1);
        }
        if (gitRoots == null) {
            GitMerge.$$$reportNull$$$0(2);
        }
        if (defaultRoot == null) {
            GitMerge.$$$reportNull$$$0(3);
        }
        if (!(dialog = new GitMergeDialog(project, defaultRoot, gitRoots)).showAndGet()) {
            return null;
        }
        return new GitMergeAction.DialogState(dialog.getSelectedRoot(), GitBundle.message((String)"merging.title", (Object[])new Object[]{dialog.getSelectedRoot().getPath()}), this.getHandlerProvider(project, dialog), dialog.getSelectedBranch(), dialog.shouldCommitAfterMerge(), ContainerUtil.map(dialog.getSelectedOptions(), option -> option.getOption()));
    }

    @Override
    protected String getNotificationErrorDisplayId() {
        return "git.merge.failed";
    }

    @NotNull
    Supplier<GitLineHandler> getHandlerProvider(Project project, GitMergeDialog dialog) {
        VirtualFile root = dialog.getSelectedRoot();
        Set<GitMergeOption> selectedOptions = dialog.getSelectedOptions();
        String commitMsg = dialog.getCommitMessage().trim();
        GitBranch selectedBranch = dialog.getSelectedBranch();
        Supplier<GitLineHandler> supplier = () -> {
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE);
            for (GitMergeOption option : selectedOptions) {
                if (option == GitMergeOption.COMMIT_MESSAGE) {
                    if (commitMsg.isEmpty()) continue;
                    h.addParameters(option.getOption(), commitMsg);
                    continue;
                }
                h.addParameters(option.getOption());
            }
            h.addParameters(selectedBranch.getName());
            return h;
        };
        if (supplier == null) {
            GitMerge.$$$reportNull$$$0(4);
        }
        return supplier;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitMerge.$$$reportNull$$$0(5);
        }
        super.update(e);
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project != null && !GitUtil.getRepositoriesInStates(project, Repository.State.MERGING).isEmpty()) {
            presentation.setEnabledAndVisible(false);
        } else if (project != null && GitUtil.getRepositoriesInStates(project, Repository.State.NORMAL, Repository.State.DETACHED).isEmpty()) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
        } else {
            presentation.setEnabledAndVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitMerge";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitMerge";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "displayDialog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

