/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.FreezableAttributeContainer;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultVariant
implements ConfigurationVariantInternal {
    private final String name;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final DisplayName displayName;
    private final FreezableAttributeContainer attributes;
    private final PublishArtifactSet artifacts;
    private Factory<List<PublishArtifact>> lazyArtifacts;
    @Nullable
    private String description;

    public DefaultVariant(Describable parentDisplayName, String name, AttributeContainerInternal parentAttributes, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, FileCollectionFactory fileCollectionFactory, AttributesFactory attributesFactory, DomainObjectCollectionFactory domainObjectCollectionFactory, TaskDependencyFactory taskDependencyFactory) {
        this.name = name;
        this.artifactNotationParser = artifactNotationParser;
        this.displayName = Describables.of((Object)parentDisplayName, (Object)"variant", (Object)name);
        this.attributes = new FreezableAttributeContainer(attributesFactory.mutable(parentAttributes), (Describable)this.displayName);
        this.artifacts = new DefaultPublishArtifactSet((Describable)this.displayName, (DomainObjectSet<PublishArtifact>)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class), fileCollectionFactory, taskDependencyFactory);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public String getName() {
        return this.name;
    }

    public DisplayName getDisplayName() {
        return this.displayName;
    }

    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        if (this.lazyArtifacts != null) {
            this.artifacts.addAll((Collection)this.lazyArtifacts.create());
            this.lazyArtifacts = null;
        }
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add((Object)((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    public void artifactsProvider(Factory<List<PublishArtifact>> artifacts) {
        this.lazyArtifacts = artifacts;
    }

    public void preventFurtherMutation() {
        this.attributes.freeze();
    }
}

