/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.diff.Delta;

public abstract class AbstractInputStreamAssert<SELF extends AbstractInputStreamAssert<SELF, ACTUAL>, ACTUAL extends InputStream>
extends AbstractAssert<SELF, ACTUAL> {
    private final Diff diff = new Diff();
    private final BinaryDiff binaryDiff = new BinaryDiff();

    protected AbstractInputStreamAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @CheckReturnValue
    public AbstractStringAssert<?> asString(Charset charset) {
        this.isNotNull();
        return Assertions.assertThat(this.asString((InputStream)this.actual, charset));
    }

    private String asString(InputStream actual, Charset charset) {
        Objects.requireNonNull(charset, ShouldNotBeNull.shouldNotBeNull("charset")::create);
        return AbstractInputStreamAssert.wrapWithMarkAndReset(actual, () -> new String(AbstractInputStreamAssert.readAllBytes(actual), charset));
    }

    private static byte[] readAllBytes(InputStream is) {
        try {
            int length;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((length = is.read(data)) != -1) {
                os.write(data, 0, length);
            }
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public SELF hasContentEqualTo(InputStream expected) {
        return this.hasSameContentAs(expected);
    }

    public SELF hasSameContentAs(InputStream expected) {
        this.isNotNull();
        this.assertHasSameContentAs(expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertHasSameContentAs(InputStream expected) {
        Objects.requireNonNull(expected, ShouldNotBeNull.shouldNotBeNull("expected")::create);
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> AbstractInputStreamAssert.wrapWithMarkAndReset(expected, () -> {
            try {
                List<Delta<String>> diffs = this.diff.diff((InputStream)this.actual, expected);
                if (!diffs.isEmpty()) {
                    throw this.assertionError(ShouldHaveSameContent.shouldHaveSameContent((InputStream)this.actual, expected, diffs));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    public SELF isEmpty() {
        this.isNotNull();
        this.assertIsEmpty();
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertIsEmpty() {
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> {
            try {
                if (((InputStream)this.actual).read() != -1) {
                    throw this.assertionError(ShouldBeEmpty.shouldBeEmpty(this.actual));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        this.assertIsNotEmpty();
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertIsNotEmpty() {
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> {
            try {
                if (((InputStream)this.actual).read() == -1) {
                    throw this.assertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public SELF hasContent(String expected) {
        this.isNotNull();
        this.assertHasContent(expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertHasContent(String expected) {
        Objects.requireNonNull(expected, ShouldNotBeNull.shouldNotBeNull("expected")::create);
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> {
            try {
                List<Delta<String>> diffs = this.diff.diff((InputStream)this.actual, expected);
                if (!diffs.isEmpty()) {
                    throw this.assertionError(ShouldHaveSameContent.shouldHaveSameContent((InputStream)this.actual, expected, diffs));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public SELF hasBinaryContent(byte[] expected) {
        this.isNotNull();
        this.assertHasBinaryContent(expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertHasBinaryContent(byte[] expected) {
        Objects.requireNonNull(expected, ShouldNotBeNull.shouldNotBeNull("expected")::create);
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> {
            try {
                BinaryDiffResult result = this.binaryDiff.diff((InputStream)this.actual, expected);
                if (!result.hasNoDiff()) {
                    throw this.assertionError(ShouldHaveBinaryContent.shouldHaveBinaryContent((InputStream)this.actual, result));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public SELF hasDigest(MessageDigest algorithm, byte[] expected) {
        this.isNotNull();
        this.assertHasDigest(algorithm, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest algorithm, String digest) {
        this.isNotNull();
        this.assertHasDigest(algorithm, Digests.fromHex(digest));
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, byte[] expected) {
        this.isNotNull();
        this.assertHasDigest(algorithm, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, String digest) {
        this.isNotNull();
        this.assertHasDigest(algorithm, digest);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertHasDigest(String algorithm, String digest) {
        Objects.requireNonNull(digest, ShouldNotBeNull.shouldNotBeNull("digest")::create);
        this.assertHasDigest(algorithm, Digests.fromHex(digest));
    }

    private void assertHasDigest(String algorithm, byte[] digest) {
        Objects.requireNonNull(algorithm, ShouldNotBeNull.shouldNotBeNull("algorithm")::create);
        try {
            this.assertHasDigest(MessageDigest.getInstance(algorithm), digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void assertHasDigest(MessageDigest algorithm, byte[] digest) {
        Objects.requireNonNull(algorithm, ShouldNotBeNull.shouldNotBeNull("algorithm")::create);
        Objects.requireNonNull(digest, ShouldNotBeNull.shouldNotBeNull("digest")::create);
        AbstractInputStreamAssert.wrapWithMarkAndReset((InputStream)this.actual, () -> {
            try {
                DigestDiff diff = Digests.digestDiff((InputStream)this.actual, algorithm, digest);
                if (diff.digestsDiffer()) {
                    throw this.assertionError(ShouldHaveDigest.shouldHaveDigest((InputStream)this.actual, diff));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void wrapWithMarkAndReset(InputStream inputStream, Runnable runnable) {
        AbstractInputStreamAssert.wrapWithMarkAndReset(inputStream, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T wrapWithMarkAndReset(InputStream inputStream, Supplier<T> callable) {
        if (!inputStream.markSupported()) {
            return callable.get();
        }
        inputStream.mark(Integer.MAX_VALUE);
        T t = callable.get();
        return t;
        finally {
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
        }
    }
}

