/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment.timesheet;

import com.projectlibre1.datatype.Rate;
import com.projectlibre1.field.CanBeDirty;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.functor.IntervalConsumer;
import com.projectlibre1.graphic.configuration.HasCssStyle;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.AssignmentSpecificFields;
import com.projectlibre1.pm.assignment.TimeDistributedFields;
import com.projectlibre1.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.pm.scheduling.ScheduleInterval;
import com.projectlibre1.pm.task.HasNotes;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.MathUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TimesheetAssignment
implements Schedule,
AssignmentSpecificFields,
TimeDistributedFields,
UpdatesFromTimesheet,
HasCssStyle,
CanBeDirty,
Comparable,
HasNotes {
    Assignment assignment;
    String taskName;
    String projectName;
    long projectUniqueId;
    long taskUniqueId;
    long resourceUniqueId;
    boolean alreadyTimesheet = false;
    Collection parentsNames = null;
    transient boolean dirty = false;
    transient String description;
    private String notes;

    public final boolean isAlreadyTimesheet() {
        return this.alreadyTimesheet;
    }

    public final void setAlreadyTimesheet(boolean bl) {
        this.alreadyTimesheet = bl;
    }

    public final long getResourceUniqueId() {
        return this.resourceUniqueId;
    }

    public final long getTaskUniqueId() {
        return this.taskUniqueId;
    }

    public final Assignment getAssignment() {
        return this.assignment;
    }

    public final void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    public TimesheetAssignment(String string, String string2, long l, long l2, long l3, Assignment assignment, String string3) {
        this.projectName = string;
        this.taskName = string2;
        this.projectUniqueId = l;
        this.taskUniqueId = l2;
        this.resourceUniqueId = l3;
        this.assignment = assignment;
        this.notes = string3;
    }

    @Override
    public long getDuration() {
        return this.assignment.getDuration();
    }

    @Override
    public long getEnd() {
        return this.assignment.getEnd();
    }

    @Override
    public long getStart() {
        return this.assignment.getStart();
    }

    @Override
    public long getActualDuration() {
        return this.assignment.getActualDuration();
    }

    @Override
    public long getActualFinish() {
        return this.assignment.getActualFinish();
    }

    @Override
    public long getActualStart() {
        return this.assignment.getActualStart();
    }

    @Override
    public double getPercentComplete() {
        return this.assignment.getPercentComplete();
    }

    @Override
    public long getRemainingDuration() {
        return this.assignment.getRemainingDuration();
    }

    @Override
    public long getResume() {
        return this.assignment.getResume();
    }

    @Override
    public long getStop() {
        return this.assignment.getStop();
    }

    @Override
    public final String getProjectName() {
        return this.projectName;
    }

    public final void setProjectName(String string) {
        this.projectName = string;
    }

    @Override
    public final String getTaskName() {
        return this.taskName;
    }

    public final void setTaskName(String string) {
        this.taskName = string;
    }

    public TimesheetAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public int getWorkContourType() {
        return this.assignment.getWorkContourType();
    }

    @Override
    public void setWorkContourType(int n) {
    }

    @Override
    public long getResourceAvailability() {
        return this.assignment.getResourceAvailability();
    }

    @Override
    public String getTaskId() {
        return "" + this.taskUniqueId;
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    public String getResourceId() {
        return "" + this.resourceUniqueId;
    }

    @Override
    public Rate getRate() {
        return this.assignment.getRate();
    }

    @Override
    public void setRate(Rate rate) {
        this.assignment.setRate(rate);
    }

    @Override
    public double getCost(FieldContext fieldContext) {
        return this.assignment.getCost();
    }

    @Override
    public long getWork(FieldContext fieldContext) {
        return this.assignment.getWork(fieldContext);
    }

    @Override
    public void setWork(long l, FieldContext fieldContext) {
        this.assignment.setWork(l, fieldContext);
    }

    @Override
    public boolean isReadOnlyWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getActualCost(FieldContext fieldContext) {
        return this.assignment.getActualCost(fieldContext);
    }

    @Override
    public long getActualWork(FieldContext fieldContext) {
        return this.assignment.getActualWork(fieldContext);
    }

    @Override
    public void setActualWork(long l, FieldContext fieldContext) {
        this.assignment.setActualWork(l, fieldContext);
    }

    @Override
    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public long getRemainingWork(FieldContext fieldContext) {
        return this.assignment.getRemainingWork(fieldContext);
    }

    @Override
    public void setRemainingWork(long l, FieldContext fieldContext) {
        this.assignment.setRemainingWork(l, fieldContext);
    }

    @Override
    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getBaselineCost(int n, FieldContext fieldContext) {
        return this.assignment.getBaselineCost(n, fieldContext);
    }

    @Override
    public long getBaselineWork(int n, FieldContext fieldContext) {
        return this.assignment.getBaselineWork(n, fieldContext);
    }

    @Override
    public boolean fieldHideCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getFixedCost(FieldContext fieldContext) {
        return this.assignment.getFixedCost(fieldContext);
    }

    @Override
    public void setFixedCost(double d, FieldContext fieldContext) {
        this.assignment.setFixedCost(d, fieldContext);
    }

    @Override
    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getActualFixedCost(FieldContext fieldContext) {
        return this.assignment.getActualFixedCost(fieldContext);
    }

    @Override
    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getRemainingCost(FieldContext fieldContext) {
        return this.assignment.getRemainingCost(fieldContext);
    }

    @Override
    public void setActualStart(long l) {
        this.assignment.setActualStart(l);
    }

    @Override
    public void setActualFinish(long l) {
        this.assignment.setActualFinish(l);
    }

    @Override
    public void setActualDuration(long l) {
        this.assignment.setActualDuration(l);
    }

    @Override
    public void setRemainingDuration(long l) {
        this.assignment.setRemainingDuration(l);
    }

    @Override
    public void setPercentComplete(double d) {
        this.assignment.setPercentComplete(d);
    }

    @Override
    public void setDuration(long l) {
        this.assignment.setDuration(l);
    }

    @Override
    public long getElapsedDuration() {
        return this.assignment.getElapsedDuration();
    }

    @Override
    public long getDependencyStart() {
        return this.assignment.getDependencyStart();
    }

    @Override
    public void setDependencyStart(long l) {
        this.assignment.setDependencyStart(l);
    }

    @Override
    public void setResume(long l) {
        this.assignment.setResume(l);
    }

    @Override
    public void setStop(long l) {
        this.assignment.setStop(l);
    }

    @Override
    public void clearDuration() {
        this.assignment.clearDuration();
    }

    @Override
    public void moveRemainingToDate(long l) {
        this.assignment.moveRemainingToDate(l);
    }

    @Override
    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
        this.assignment.moveInterval(object, l, l2, scheduleInterval, bl);
    }

    @Override
    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        this.assignment.consumeIntervals(intervalConsumer);
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        return this.assignment.getEffectiveWorkCalendar();
    }

    @Override
    public void split(Object object, long l, long l2) {
        this.assignment.split(object, l, l2);
    }

    @Override
    public boolean isJustModified() {
        return this.assignment.isJustModified();
    }

    @Override
    public void setStart(long l) {
        this.assignment.setStart(l);
    }

    @Override
    public void setEnd(long l) {
        this.assignment.setEnd(l);
    }

    @Override
    public boolean isComplete() {
        return this.assignment.isComplete();
    }

    @Override
    public void setComplete(boolean bl) {
        this.assignment.setComplete(bl);
    }

    @Override
    public Project getProject() {
        return this.assignment.getOwningProject();
    }

    @Override
    public long getTimesheetFinish() {
        return this.assignment.getTimesheetFinish();
    }

    @Override
    public long getTimesheetStart() {
        return this.assignment.getTimesheetStart();
    }

    @Override
    public long getLastTimesheetUpdate() {
        return this.assignment.getLastTimesheetUpdate();
    }

    @Override
    public boolean applyTimesheet(Collection collection, long l) {
        return false;
    }

    @Override
    public boolean isPendingTimesheetUpdate() {
        return this.assignment.isPendingTimesheetUpdate();
    }

    @Override
    public int getTimesheetStatus() {
        return this.assignment.getTimesheetStatus();
    }

    @Override
    public String getTimesheetStatusName() {
        return this.assignment.getTimesheetStatusName();
    }

    @Override
    public String getCssStyleClass() {
        return this.getTimesheetStatusName();
    }

    public void setHierarchy(Collection collection) {
        this.parentsNames = collection;
    }

    @Override
    public Collection getHierarchy() {
        return this.parentsNames;
    }

    public boolean isIntegratedOrComplete() {
        if (this.getTimesheetStatus() == 3) {
            return true;
        }
        if (this.getTimesheetStatus() == 2) {
            return false;
        }
        return this.isComplete();
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public long getCachedStart() {
        Date date = this.assignment.getCachedStart();
        if (date == null) {
            return 0L;
        }
        date = DateTime.fromGmt(date);
        return date.getTime();
    }

    public long getCachedEnd() {
        Date date = this.assignment.getCachedEnd();
        if (date == null) {
            return 0L;
        }
        return DateTime.gmt(date);
    }

    public int compareTo(Object object) {
        return MathUtils.signum(this.getCachedStart() - ((TimesheetAssignment)object).getCachedStart());
    }

    public long getReadOnlyDuration() {
        return this.getDuration();
    }

    @Override
    public final long getEarliestStop() {
        return this.assignment.getEarliestStop();
    }

    @Override
    public final long getCompletedThrough() {
        return this.assignment.getCompletedThrough();
    }

    @Override
    public void setCompletedThrough(long l) {
        this.assignment.setCompletedThrough(l);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public String toExternalId() {
        return this.taskUniqueId + "/" + this.resourceUniqueId;
    }

    @Override
    public Object backupDetail() {
        return null;
    }

    @Override
    public void restoreDetail(Object object, Object object2, boolean bl) {
    }

    public long getProjectUniqueId() {
        return this.projectUniqueId;
    }

    public void setProjectUniqueId(long l) {
        this.projectUniqueId = l;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String string) {
        this.notes = string;
    }
}

