/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.UnknownI2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.OutboundMessageDistributor;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;

class OutboundTunnelEndpoint {
    private final RouterContext _context;
    private final Log _log;
    private final HopConfig _config;
    private final HopProcessor _processor;
    private final FragmentHandler _handler;
    private final OutboundMessageDistributor _outDistributor;

    public OutboundTunnelEndpoint(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundTunnelEndpoint.class);
        this._config = config;
        this._processor = processor;
        this._handler = new FragmentHandler(ctx, new DefragmentedHandler(), false);
        this._outDistributor = new OutboundMessageDistributor(ctx, 200);
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        Hash h;
        this._config.incrementProcessedMessages();
        byte[] data = msg.getData();
        boolean ok = this._processor.process(data, 0, data.length, recvFrom);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV, dropping at OBEP " + this._config);
            }
            return;
        }
        ok = this._handler.receiveTunnelMessage(data, 0, data.length);
        if (!ok && (h = this._config.getReceiveFrom()) != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Blaming " + h + " 50%");
            }
            this._context.profileManager().tunnelFailed(h, 50);
        }
    }

    public String toString() {
        return "OBEP " + this._config.getReceiveTunnelId();
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        @Override
        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (toRouter == null) {
                if (OutboundTunnelEndpoint.this._log.shouldLog(30)) {
                    OutboundTunnelEndpoint.this._log.warn("Dropping msg at OBEP with unsupported delivery instruction type LOCAL");
                }
                return;
            }
            int type = msg.getType();
            if (type == 1) {
                DatabaseStoreMessage dsm;
                DatabaseEntry entry;
                if (msg instanceof UnknownI2NPMessage) {
                    try {
                        UnknownI2NPMessage umsg = (UnknownI2NPMessage)msg;
                        msg = umsg.convert();
                    }
                    catch (I2NPMessageException ime) {
                        if (OutboundTunnelEndpoint.this._log.shouldLog(30)) {
                            OutboundTunnelEndpoint.this._log.warn("Unable to convert to std. msg. class at zero-hop IBGW", ime);
                        }
                        return;
                    }
                }
                if ((entry = (dsm = (DatabaseStoreMessage)msg).getEntry()).getType() == 0) {
                    long now = OutboundTunnelEndpoint.this._context.clock().now();
                    long date = entry.getDate();
                    if (date < now - 3600000L) {
                        if (OutboundTunnelEndpoint.this._log.shouldWarn()) {
                            OutboundTunnelEndpoint.this._log.warn("Dropping DSM of old RI at OBEP, direct? " + (toTunnel == null) + " to router: " + toRouter.toBase64() + " key: " + dsm.getKey().toBase64());
                        }
                        return;
                    }
                    if (date > now + 120000L) {
                        if (OutboundTunnelEndpoint.this._log.shouldWarn()) {
                            OutboundTunnelEndpoint.this._log.warn("Dropping DSM of future RI at OBEP, direct? " + (toTunnel == null) + " to router: " + toRouter.toBase64() + " key: " + dsm.getKey().toBase64());
                        }
                        return;
                    }
                }
            }
            if (OutboundTunnelEndpoint.this._log.shouldLog(10)) {
                OutboundTunnelEndpoint.this._log.debug("outbound tunnel " + OutboundTunnelEndpoint.this._config + " received a full message: " + msg + " to be forwarded on to " + toRouter.toBase64().substring(0, 4) + (toTunnel != null ? ":" + toTunnel.getTunnelId() : ""));
            }
            int size = msg.getMessageSize();
            boolean toUs = OutboundTunnelEndpoint.this._context.routerHash().equals(toRouter);
            if (!toUs && OutboundTunnelEndpoint.this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.OBEP, type, size)) {
                return;
            }
            OutboundTunnelEndpoint.this._outDistributor.distribute(msg, toRouter, toTunnel);
        }
    }
}

