/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.plugin.software.internal.ModelDefault;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;

public class DefaultSoftwareTypeImplementation<T>
implements SoftwareTypeImplementation<T> {
    private final String softwareType;
    private final Class<? extends T> modelPublicType;
    private final Class<? extends Plugin<Project>> pluginClass;
    private final Class<? extends Plugin<Settings>> registeringPluginClass;
    private final List<ModelDefault<?>> defaults = new ArrayList();

    public DefaultSoftwareTypeImplementation(String softwareType, Class<? extends T> modelPublicType, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass) {
        this.softwareType = softwareType;
        this.modelPublicType = modelPublicType;
        this.pluginClass = pluginClass;
        this.registeringPluginClass = registeringPluginClass;
    }

    public String getSoftwareType() {
        return this.softwareType;
    }

    public Class<? extends T> getModelPublicType() {
        return this.modelPublicType;
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return this.pluginClass;
    }

    public Class<? extends Plugin<Settings>> getRegisteringPluginClass() {
        return this.registeringPluginClass;
    }

    public void addModelDefault(ModelDefault<?> modelDefault) {
        this.defaults.add(modelDefault);
    }

    public <V extends ModelDefault.Visitor<?>> void visitModelDefaults(Class<? extends ModelDefault<V>> type, V visitor) {
        this.defaults.stream().filter(type::isInstance).map(type::cast).forEach(modelDefault -> modelDefault.visit(visitor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultSoftwareTypeImplementation that = (DefaultSoftwareTypeImplementation)o;
        return Objects.equals(this.softwareType, that.softwareType) && Objects.equals(this.modelPublicType, that.modelPublicType) && Objects.equals(this.pluginClass, that.pluginClass);
    }

    public int hashCode() {
        return Objects.hash(this.softwareType, this.modelPublicType, this.pluginClass);
    }
}

