/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionContainer;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public class OptionGroup
extends AbstractOption<OptionGroup>
implements OptionContainer {
    private static final Logger logger = Logger.getLogger(OptionGroup.class.getName());
    public static final String TAG = "optionGroup";
    private final List<Option> options = new ArrayList<Option>();
    private final Map<String, Option> optionMap = new HashMap<String, Option>();
    private boolean editable = true;
    private boolean visible = true;
    private static final String EDITABLE_TAG = "editable";
    private static final String VISIBLE_TAG = "visible";

    public OptionGroup(String id) {
        super(id);
    }

    public OptionGroup(Specification specification) {
        super(specification);
    }

    public OptionGroup(String id, Specification specification) {
        super(id, specification);
    }

    public OptionGroup(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getName() {
        return Messages.getName(this.getId());
    }

    public String getShortDescription() {
        return Messages.getShortDescription(this.getId());
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String id) {
        return this.optionMap.get(id);
    }

    public boolean hasOptionGroup() {
        return CollectionUtils.any(this.options, o -> o instanceof OptionGroup);
    }

    public void add(Option option) {
        String id = option.getId();
        if (this.optionMap.containsKey(id)) {
            for (int index = 0; index < this.options.size(); ++index) {
                if (!id.equals(this.options.get(index).getId())) continue;
                this.options.remove(index);
                this.options.add(index, option);
                break;
            }
        } else {
            this.options.add(option);
        }
        this.optionMap.put(id, option);
        if (option instanceof OptionGroup) {
            OptionGroup group = (OptionGroup)option;
            group.setEditable(this.editable && group.isEditable());
            this.addOptionGroup(group);
        }
    }

    public boolean merge(Option option, LogBuilder lb) {
        if (option == null) {
            return false;
        }
        String id = option.getId();
        OptionGroup etc = null;
        if (option instanceof OptionGroup) {
            OptionGroup optionGroup = (OptionGroup)option;
            boolean result = true;
            for (Option o : optionGroup.getOptions()) {
                if (o.getId().startsWith("net.sf.freecol.client.gui.panel.")) {
                    if (etc == null) {
                        etc = this.getOptionGroup("clientOptions.etc");
                    }
                    etc.add(o);
                    lb.add(o.getId(), " moved to ", "clientOptions.etc", ".\n");
                    continue;
                }
                result = result && this.merge(o, lb);
            }
            if (result) {
                optionGroup.setEditable(this.editable && optionGroup.isEditable());
            }
            lb.add(id, " group merged contents into ", this.getId(), ".\n");
            return result;
        }
        if (!this.optionMap.containsKey(id)) {
            lb.add(id, " unknown/ignored.\n");
            return false;
        }
        for (int index = 0; index < this.options.size(); ++index) {
            Option o = this.options.get(index);
            if (id.equals(o.getId())) {
                this.options.remove(index);
                this.options.add(index, option);
                this.optionMap.put(id, option);
                lb.add(id, " merged into ", this.getId(), ": ", option.toString() + ".\n");
                return true;
            }
            if (!(o instanceof OptionGroup)) continue;
            OptionGroup og = (OptionGroup)o;
            if (!og.optionMap.containsKey(id) || !og.merge(option, lb)) continue;
            this.optionMap.put(id, option);
            return true;
        }
        lb.add(id, " registered but not found!\n");
        return false;
    }

    private void addOptionGroup(OptionGroup group) {
        for (Option option : group.getOptions()) {
            this.optionMap.put(option.getId(), option);
            if (!(option instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)option);
        }
    }

    public Option remove(String id) {
        Option op = this.optionMap.remove(id);
        this.options.remove(op);
        if (op != null) {
            this.options.stream().filter(o -> o instanceof OptionGroup).map(o -> (OptionGroup)o).forEach(og -> og.remove(id));
        }
        return op;
    }

    public void removeAll() {
        this.options.clear();
        this.optionMap.clear();
    }

    protected boolean load(FreeColXMLReader xr) throws XMLStreamException {
        if (xr == null) {
            return false;
        }
        xr.nextTag();
        this.readFromXML(xr);
        return true;
    }

    public boolean load(File file) {
        if (file == null) {
            return false;
        }
        boolean ret = false;
        try (FreeColXMLReader xr = new FreeColXMLReader(file);){
            ret = this.load(xr);
        }
        catch (IOException | XMLStreamException xse) {
            logger.log(Level.WARNING, "Load OptionGroup(" + this.getId() + ") from file " + file.getPath() + " crashed", xse);
            return false;
        }
        logger.info("Load OptionGroup(" + this.getId() + ") from " + file.getPath() + (ret ? " succeeded" : " failed"));
        return ret;
    }

    public static OptionGroup loadOptionGroup(File file, String optionId, Specification spec) {
        OptionGroup ret = new OptionGroup(spec);
        if (ret.load(file)) {
            if (!optionId.equals(ret.getId())) {
                Option op = ret.getOption(optionId);
                ret = op instanceof OptionGroup ? (OptionGroup)op : null;
            }
        } else {
            ret = null;
        }
        return ret;
    }

    @Override
    public <T extends Option> boolean hasOption(String id, Class<T> returnClass) {
        if (id == null) {
            return false;
        }
        Option val = this.optionMap.get(id);
        return val == null ? false : returnClass.isAssignableFrom(val.getClass());
    }

    @Override
    public <T extends Option> T getOption(String id, Class<T> returnClass) {
        if (id == null) {
            throw new RuntimeException("Null id: " + this);
        }
        if (!this.optionMap.containsKey(id)) {
            throw new RuntimeException("Missing option: " + id);
        }
        try {
            return (T)((Option)returnClass.cast(this.optionMap.get(id)));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Not a " + returnClass.getName() + ": " + id, cce);
        }
    }

    @Override
    public OptionGroup cloneOption() {
        OptionGroup result = new OptionGroup(this.getId(), this.getSpecification());
        result.editable = this.editable;
        result.setValues(this);
        result.options.addAll(this.options);
        result.optionMap.putAll(this.optionMap);
        return result;
    }

    @Override
    public OptionGroup getValue() {
        return this;
    }

    @Override
    public void setValue(OptionGroup value) {
        if (value != null) {
            for (Option other : value.getOptions()) {
                Option mine = this.getOption(other.getId());
                if (mine == null) continue;
                mine.setValue(other.getValue());
            }
        }
    }

    @Override
    public void setValue(String valueString, String defaultValueString) {
    }

    @Override
    public void generateChoices() {
        for (Option o : this.options) {
            if (o instanceof OptionGroup) {
                ((OptionGroup)o).generateChoices();
                continue;
            }
            if (!(o instanceof AbstractOption)) continue;
            ((AbstractOption)o).generateChoices();
        }
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    public boolean save(File file) {
        boolean ret = false;
        try {
            ret = this.save(file, null, true);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Save OptionGroup(" + this.getId() + ") to " + file.getPath() + " crashed", e);
            return false;
        }
        logger.info("Save OptionGroup(" + this.getId() + ") to " + file.getPath() + (ret ? " succeeded" : " failed"));
        return ret;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(EDITABLE_TAG, this.editable);
        xw.writeAttribute(VISIBLE_TAG, this.visible);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Option o : this.options) {
            o.toXML(xw);
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.editable = xr.getAttribute(EDITABLE_TAG, true);
        this.visible = xr.getAttribute(VISIBLE_TAG, true);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        for (Option option : this.getOptions()) {
            this.optionMap.put(option.getId(), option);
            if (!(option instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)option);
        }
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String optionId = xr.readId();
        Option option = this.getOption(optionId);
        if (option == null) {
            AbstractOption abstractOption = this.readOption(xr);
            if (abstractOption != null) {
                this.add(abstractOption);
                abstractOption.setGroup(this.getId());
            }
        } else {
            option.readFromXML(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getId()).append(" <");
        for (Option o : this.getOptions()) {
            sb.append(' ').append(o.toString());
        }
        sb.append(" >]");
        return sb.toString();
    }
}

