/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Set;

final class BooleanValue {
    private String value = "false";
    private boolean booleanValue;

    private BooleanValue(boolean bl) {
        this.booleanValue = bl;
        this.value = bl ? "true" : "false";
    }

    public String union(Set<String> set) {
        for (String string : set) {
            if (!"true".equals(string)) continue;
            return "true";
        }
        return "false";
    }

    public void setValue(String string) {
        this.value = string;
        this.booleanValue = Boolean.valueOf(string);
    }

    public final String getValue() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.booleanValue;
    }

    public static BooleanValue valueOf(String string) {
        if ("true".equals(string)) {
            return new BooleanValue(true);
        }
        if ("false".equals(string)) {
            return new BooleanValue(false);
        }
        throw new InternalError("Unknown default value for settings '" + string + "'");
    }
}

