/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public class LabourData {
    private static final LocationData.Getter UNITS_IN_EUROPE_GETTER = new LocationData.Getter(){

        @Override
        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsInEurope;
        }
    };
    private static final LocationData.Getter UNITS_AT_SEA_GETTER = new LocationData.Getter(){

        @Override
        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsAtSea;
        }
    };
    private static final LocationData.Getter UNITS_ON_LAND_GETTER = new LocationData.Getter(){

        @Override
        public LocationData getLocationData(UnitData unitData) {
            return unitData.unitsOnLand;
        }
    };
    private final Map<GoodsType, UnitData> experts = new LinkedHashMap<GoodsType, UnitData>();
    private final Map<String, UnitData> unitDataMap = new LinkedHashMap<String, UnitData>();
    private final UnitData summary = new UnitData(null);
    private UnitData missionary;
    private UnitData pioneer;
    private UnitData soldier;
    private UnitData scout;

    public LabourData(FreeColClient client) {
        Specification spec = client.getGame().getSpecification();
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (!unitType.isAvailableTo(client.getMyPlayer())) continue;
            GoodsType production = unitType.getExpertProduction();
            if (production != null) {
                this.experts.put(production, this.getUnitData(unitType));
            }
            if (unitType.hasAbility("model.ability.expertPioneer")) {
                this.pioneer = this.getUnitData(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.expertSoldier")) {
                this.soldier = this.getUnitData(unitType);
                continue;
            }
            if (unitType.hasAbility("model.ability.expertScout")) {
                this.scout = this.getUnitData(unitType);
                continue;
            }
            if (!unitType.hasAbility("model.ability.expertMissionary")) continue;
            this.missionary = this.getUnitData(unitType);
        }
        this.gatherData(client.getMyPlayer());
    }

    private void gatherData(Player player) {
        List<UnitType> labourTypes = LabourData.getLabourTypes(player);
        for (Unit unit : CollectionUtils.transform(player.getUnits(), u -> labourTypes.contains(u.getType()))) {
            Location location = unit.getLocation();
            UnitData data = this.getUnitData(unit.getType());
            if (location instanceof WorkLocation) {
                this.incrementColonyCount(location.getColony(), unit, data);
                continue;
            }
            if (location instanceof Europe) {
                this.incrementOutsideWorker(data, unit, UNITS_IN_EUROPE_GETTER);
                continue;
            }
            if (location instanceof Tile && ((Tile)location).hasSettlement()) {
                this.incrementColonyCount((Colony)location.getSettlement(), unit, data);
                continue;
            }
            if (location instanceof Unit) {
                this.incrementOutsideWorker(data, unit, UNITS_AT_SEA_GETTER);
                continue;
            }
            this.incrementOutsideWorker(data, unit, UNITS_ON_LAND_GETTER);
        }
        this.summarize();
        for (UnitData unitData : this.unitDataMap.values()) {
            LocationData total = unitData.getTotal();
            GoodsType expertProduction = unitData.getUnitType().getExpertProduction();
            if (expertProduction == null) continue;
            for (Colony c : player.getColonyList()) {
                int net = c.getNetProductionOf(expertProduction);
                if (unitData.details.containsKey(c)) {
                    unitData.getLocationData((Colony)c).netProduction = net;
                }
                total.netProduction += net;
            }
        }
    }

    public static List<UnitType> getLabourTypes(Player player) {
        return CollectionUtils.transform(player.getSpecification().getUnitTypeList(), ut -> ut.hasSkill() && ut.isAvailableTo(player));
    }

    private void summarize() {
        for (UnitData unitData : this.unitDataMap.values()) {
            this.summarize(unitData, UNITS_IN_EUROPE_GETTER);
            this.summarize(unitData, UNITS_AT_SEA_GETTER);
            this.summarize(unitData, UNITS_ON_LAND_GETTER);
            for (Colony colony : unitData.details.keySet()) {
                this.summarize(unitData, new ColonyLocationDataGetter(colony));
            }
        }
    }

    private void summarize(UnitData data, LocationData.Getter getter) {
        LocationData unitLocation = getter.getLocationData(data);
        LocationData summaryLocation = getter.getLocationData(this.summary);
        data.total.add(unitLocation);
        summaryLocation.add(unitLocation);
        this.summary.total.add(unitLocation);
    }

    private void incrementOutsideWorker(UnitData unitData, Unit unit, LocationData.Getter getter) {
        UnitData workingAs = null;
        if (unit.isArmed()) {
            workingAs = this.soldier;
        } else if (unit.hasAbility("model.ability.establishMission")) {
            workingAs = this.missionary;
        } else if (unit.hasAbility("model.ability.improveTerrain")) {
            workingAs = this.pioneer;
        } else if (unit.hasAbility("model.ability.speakWithChief")) {
            workingAs = this.scout;
        }
        if (workingAs == null) {
            ++getter.getLocationData((UnitData)unitData).notWorking;
        } else {
            this.incrementOutsideWorker(unitData, unit, workingAs, getter);
        }
    }

    private void incrementOutsideWorker(UnitData expert, Unit unit, UnitData workingAs, LocationData.Getter getter) {
        if (unit.getType() == workingAs.unitType) {
            ++getter.getLocationData((UnitData)expert).workingProfessionals.colonists;
        } else {
            ++getter.getLocationData((UnitData)expert).workingAmateurs;
            ++getter.getLocationData((UnitData)workingAs).otherWorkingAmateurs.colonists;
        }
    }

    private void incrementColonyCount(Colony colony, Unit unit, UnitData unitData) {
        GoodsType currentlyWorking;
        if (!unit.isInColony()) {
            this.incrementOutsideWorker(unitData, unit, new ColonyLocationDataGetter(colony));
            return;
        }
        WorkLocation wl = unit.getWorkLocation();
        LocationData colonyData = unitData.getLocationData(colony);
        Unit teacher = unit.getTeacher();
        if (teacher != null) {
            ++colonyData.students;
            UnitData learning = this.getUnitData(unit.getTeachingType(teacher));
            learning.getLocationData(colony).addOtherStudent(unitData.getUnitName());
        }
        if (wl.canTeach()) {
            ++colonyData.teachers;
        }
        int production = (currentlyWorking = unit.getWorkType()) == null ? 0 : wl.getProductionOf(unit, currentlyWorking);
        UnitData workingAs = this.experts.get(currentlyWorking);
        if (workingAs != null) {
            if (workingAs.getUnitType() == unit.getType()) {
                colonyData.getWorkingProfessionals().addProduction(production);
            } else {
                ++colonyData.workingAmateurs;
                workingAs.getLocationData((Colony)colony).otherWorkingAmateurs.addProduction(production);
            }
        }
    }

    public final UnitData getUnitData(UnitType unitType) {
        UnitData data = this.unitDataMap.get(unitType.getId());
        if (data == null) {
            data = new UnitData(unitType);
            this.unitDataMap.put(unitType.getId(), data);
        }
        return data;
    }

    public UnitData getSummary() {
        return this.summary;
    }

    public static class UnitData {
        private final UnitType unitType;
        private boolean summary = false;
        private final Map<Colony, LocationData> details = new LinkedHashMap<Colony, LocationData>();
        private final LocationData total = new LocationData(this, true);
        private final LocationData unitsAtSea = new LocationData(this);
        private final LocationData unitsOnLand = new LocationData(this);
        private final LocationData unitsInEurope = new LocationData(this);

        public UnitData(UnitType unitType) {
            this.unitType = unitType;
            if (unitType == null) {
                this.summary = true;
            }
        }

        private LocationData getLocationData(Colony colony) {
            LocationData colonyData = this.details.get(colony);
            if (colonyData == null) {
                colonyData = new LocationData(this);
                this.details.put(colony, colonyData);
            }
            return colonyData;
        }

        public String getUnitName() {
            return this.isSummary() ? null : Messages.getName(this.unitType);
        }

        public boolean hasDetails() {
            return this.getTotal().getRowCount() > 0;
        }

        public int getUnitSummaryRowCount() {
            return Math.max(1, this.getTotal().getRowCount());
        }

        public UnitType getUnitType() {
            return this.unitType;
        }

        public LocationData getTotal() {
            return this.total;
        }

        public LocationData getUnitsAtSea() {
            return this.unitsAtSea;
        }

        public LocationData getUnitsOnLand() {
            return this.unitsOnLand;
        }

        public LocationData getUnitsInEurope() {
            return this.unitsInEurope;
        }

        public Map<Colony, LocationData> getDetails() {
            return this.details;
        }

        public boolean isSummary() {
            return this.summary;
        }

        public boolean showProduction() {
            return !this.summary && this.unitType.getExpertProduction() != null;
        }

        public boolean showNetProduction() {
            return this.showProduction() && this.unitType.getExpertProduction().isStorable();
        }

        public GoodsType getExpertProduction() {
            if (this.summary) {
                return null;
            }
            return this.getUnitType().getExpertProduction();
        }
    }

    public static class LocationData {
        private final UnitData unitData;
        private final boolean isTotal;
        private final ProductionData workingProfessionals = new ProductionData();
        private int workingAmateurs;
        private final ProductionData otherWorkingAmateurs = new ProductionData();
        private int netProduction;
        private int teachers;
        private int otherStudents;
        private String otherStudentsName;
        private int students;
        private int notWorking;

        public LocationData(UnitData unitData) {
            this(unitData, false);
        }

        public LocationData(UnitData unitData, boolean total) {
            this.unitData = unitData;
            this.isTotal = total;
        }

        public int getOtherStudents() {
            return this.otherStudents;
        }

        public String getOtherStudentsName() {
            return this.otherStudentsName;
        }

        public void addOtherStudent(String name) {
            ++this.otherStudents;
            this.otherStudentsName = name;
        }

        public ProductionData getWorkingProfessionals() {
            return this.workingProfessionals;
        }

        public ProductionData getOtherWorkingAmateurs() {
            return this.otherWorkingAmateurs;
        }

        public int getNetProduction() {
            return this.netProduction;
        }

        public int getTotalColonists() {
            return this.workingAmateurs + this.workingProfessionals.getColonists() + this.notWorking + this.teachers + this.otherStudents - this.students;
        }

        public int getTotalProduction() {
            return this.workingProfessionals.getProduction() + this.otherWorkingAmateurs.getProduction();
        }

        public int getRowCount() {
            boolean isSummary = this.getUnitData().isSummary();
            int rows = 0;
            if (this.workingProfessionals.getColonists() > 0) {
                ++rows;
            }
            if (this.workingAmateurs > 0) {
                ++rows;
            }
            if (!isSummary && this.otherWorkingAmateurs.getColonists() > 0) {
                ++rows;
            }
            if (this.teachers > 0) {
                ++rows;
            }
            if (this.students > 0) {
                ++rows;
            }
            if (!isSummary && this.otherStudents > 0) {
                ++rows;
            }
            if (this.notWorking > 0) {
                ++rows;
            }
            return rows;
        }

        public boolean isTraining() {
            return this.teachers > 0 || this.students > 0 || this.otherStudents > 0;
        }

        public int getWorkingAmateurs() {
            return this.workingAmateurs;
        }

        public int getTeachers() {
            return this.teachers;
        }

        public int getStudents() {
            return this.students;
        }

        public int getNotWorking() {
            return this.notWorking;
        }

        public UnitData getUnitData() {
            return this.unitData;
        }

        public boolean isTotal() {
            return this.isTotal;
        }

        private void add(LocationData data) {
            this.workingProfessionals.add(data.workingProfessionals);
            this.workingAmateurs += data.workingAmateurs;
            this.otherWorkingAmateurs.add(data.otherWorkingAmateurs);
            this.teachers += data.teachers;
            this.students += data.students;
            this.otherStudents += data.otherStudents;
            this.notWorking += data.notWorking;
            if (data.otherStudents > 0) {
                this.otherStudentsName = data.otherStudentsName;
            }
        }

        public static interface Getter {
            public LocationData getLocationData(UnitData var1);
        }
    }

    public static class ProductionData {
        private int colonists;
        private int production;

        public void addProduction(int production) {
            this.colonists = this.getColonists() + 1;
            this.production = this.getProduction() + production;
        }

        public int getColonists() {
            return this.colonists;
        }

        public int getProduction() {
            return this.production;
        }

        private void add(ProductionData data) {
            this.colonists += data.colonists;
            this.production += data.production;
        }
    }

    private static class ColonyLocationDataGetter
    implements LocationData.Getter {
        private Colony colony;

        public ColonyLocationDataGetter(Colony colony) {
            this.colony = colony;
        }

        @Override
        public LocationData getLocationData(UnitData data) {
            return data.getLocationData(this.colony);
        }
    }
}

