/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.reader.zip;

import com.googlecode.d2j.util.zip.AccessBufByteArrayOutputStream;
import com.googlecode.d2j.util.zip.ZipEntry;
import com.googlecode.d2j.util.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class ZipUtil {
    public static byte[] toByteArray(InputStream is) throws IOException {
        AccessBufByteArrayOutputStream out = new AccessBufByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int c = is.read(buff);
        while (c > 0) {
            out.write(buff, 0, c);
            c = is.read(buff);
        }
        return out.getBuf();
    }

    public static byte[] readDex(File file) throws IOException {
        return ZipUtil.readDex(file.toPath());
    }

    public static byte[] readDex(Path file) throws IOException {
        return ZipUtil.readDex(Files.readAllBytes(file));
    }

    public static byte[] readDex(InputStream in) throws IOException {
        return ZipUtil.readDex(ZipUtil.toByteArray(in));
    }

    public static byte[] readDex(byte[] data) throws IOException {
        if (data.length < 3) {
            throw new IOException("File too small to be a dex/zip");
        }
        if ("dex".equals(new String(data, 0, 3, StandardCharsets.ISO_8859_1))) {
            return data;
        }
        if ("PK".equals(new String(data, 0, 2, StandardCharsets.ISO_8859_1))) {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(data);){
                ZipEntry classes = zipFile.findFirstEntry("classes.dex");
                if (classes != null) {
                    byte[] byArray = ZipUtil.toByteArray(zipFile.getInputStream(classes));
                    return byArray;
                }
                try {
                    throw new IOException("Can not find classes.dex in zip file");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        throw new IOException("the src file not a .dex or zip file");
    }
}

