/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) & ivec4(-64, 72, 88, -76)) => ivec4(-64, 72, 88, -76)
 * (ivec4(-64, 72, 88, -76) & ivec4(64, 72, 88, 76)) => ivec4(64, 72, 88, 4)
 * (ivec4(-64, 72, 88, -76) & ivec4(-24, 40, -23, 64)) => ivec4(-64, 8, 72, 0)
 * (ivec4(-64, 72, 88, -76) & ivec4(24, 40, 23, 64)) => ivec4(0, 8, 16, 0)
 * (ivec4(64, 72, 88, 76) & ivec4(-64, 72, 88, -76)) => ivec4(64, 72, 88, 4)
 * (ivec4(64, 72, 88, 76) & ivec4(64, 72, 88, 76)) => ivec4(64, 72, 88, 76)
 * (ivec4(64, 72, 88, 76) & ivec4(-24, 40, -23, 64)) => ivec4(64, 8, 72, 64)
 * (ivec4(64, 72, 88, 76) & ivec4(24, 40, 23, 64)) => ivec4(0, 8, 16, 64)
 * (ivec4(-24, 40, -23, 64) & ivec4(-64, 72, 88, -76)) => ivec4(-64, 8, 72, 0)
 * (ivec4(-24, 40, -23, 64) & ivec4(64, 72, 88, 76)) => ivec4(64, 8, 72, 64)
 * (ivec4(-24, 40, -23, 64) & ivec4(-24, 40, -23, 64)) => ivec4(-24, 40, -23, 64)
 * (ivec4(-24, 40, -23, 64) & ivec4(24, 40, 23, 64)) => ivec4(8, 40, 1, 64)
 * (ivec4(24, 40, 23, 64) & ivec4(-64, 72, 88, -76)) => ivec4(0, 8, 16, 0)
 * (ivec4(24, 40, 23, 64) & ivec4(64, 72, 88, 76)) => ivec4(0, 8, 16, 64)
 * (ivec4(24, 40, 23, 64) & ivec4(-24, 40, -23, 64)) => ivec4(8, 40, 1, 64)
 * (ivec4(24, 40, 23, 64) & ivec4(24, 40, 23, 64)) => ivec4(24, 40, 23, 64)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) & ivec4(-64, 72, 88, -76)), ivec4(-64, 72, 88, -76))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) & ivec4(64, 72, 88, 76)), ivec4(64, 72, 88, 4))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) & ivec4(-24, 40, -23, 64)), ivec4(-64, 8, 72, 0))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) & ivec4(24, 40, 23, 64)), ivec4(0, 8, 16, 0))) ? 1 : -1] array3;
  float[all(equal((ivec4(64, 72, 88, 76) & ivec4(-64, 72, 88, -76)), ivec4(64, 72, 88, 4))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) & ivec4(64, 72, 88, 76)), ivec4(64, 72, 88, 76))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) & ivec4(-24, 40, -23, 64)), ivec4(64, 8, 72, 64))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) & ivec4(24, 40, 23, 64)), ivec4(0, 8, 16, 64))) ? 1 : -1] array7;
  float[all(equal((ivec4(-24, 40, -23, 64) & ivec4(-64, 72, 88, -76)), ivec4(-64, 8, 72, 0))) ? 1 : -1] array8;
  float[all(equal((ivec4(-24, 40, -23, 64) & ivec4(64, 72, 88, 76)), ivec4(64, 8, 72, 64))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) & ivec4(-24, 40, -23, 64)), ivec4(-24, 40, -23, 64))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) & ivec4(24, 40, 23, 64)), ivec4(8, 40, 1, 64))) ? 1 : -1] array11;
  float[all(equal((ivec4(24, 40, 23, 64) & ivec4(-64, 72, 88, -76)), ivec4(0, 8, 16, 0))) ? 1 : -1] array12;
  float[all(equal((ivec4(24, 40, 23, 64) & ivec4(64, 72, 88, 76)), ivec4(0, 8, 16, 64))) ? 1 : -1] array13;
  float[all(equal((ivec4(24, 40, 23, 64) & ivec4(-24, 40, -23, 64)), ivec4(8, 40, 1, 64))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) & ivec4(24, 40, 23, 64)), ivec4(24, 40, 23, 64))) ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
