/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 * ivec4(-64, 72, 88, -76)) => ivec4(-768, 864, 1056, -912)
 * (12 * ivec4(64, 72, 88, 76)) => ivec4(768, 864, 1056, 912)
 * (12 * ivec4(-24, 40, -23, 64)) => ivec4(-288, 480, -276, 768)
 * (12 * ivec4(24, 40, 23, 64)) => ivec4(288, 480, 276, 768)
 * (-6 * ivec4(-64, 72, 88, -76)) => ivec4(384, -432, -528, 456)
 * (-6 * ivec4(64, 72, 88, 76)) => ivec4(-384, -432, -528, -456)
 * (-6 * ivec4(-24, 40, -23, 64)) => ivec4(144, -240, 138, -384)
 * (-6 * ivec4(24, 40, 23, 64)) => ivec4(-144, -240, -138, -384)
 * (76 * ivec4(-64, 72, 88, -76)) => ivec4(-4864, 5472, 6688, -5776)
 * (76 * ivec4(64, 72, 88, 76)) => ivec4(4864, 5472, 6688, 5776)
 * (76 * ivec4(-24, 40, -23, 64)) => ivec4(-1824, 3040, -1748, 4864)
 * (76 * ivec4(24, 40, 23, 64)) => ivec4(1824, 3040, 1748, 4864)
 * (-32 * ivec4(-64, 72, 88, -76)) => ivec4(2048, -2304, -2816, 2432)
 * (-32 * ivec4(64, 72, 88, 76)) => ivec4(-2048, -2304, -2816, -2432)
 * (-32 * ivec4(-24, 40, -23, 64)) => ivec4(768, -1280, 736, -2048)
 * (-32 * ivec4(24, 40, 23, 64)) => ivec4(-768, -1280, -736, -2048)
 * (0 * ivec4(-64, 72, 88, -76)) => ivec4(0, 0, 0, 0)
 * (0 * ivec4(64, 72, 88, 76)) => ivec4(0, 0, 0, 0)
 * (0 * ivec4(-24, 40, -23, 64)) => ivec4(0, 0, 0, 0)
 * (0 * ivec4(24, 40, 23, 64)) => ivec4(0, 0, 0, 0)
 */
#version 120

void main()
{
  float[all(equal((12 * ivec4(-64, 72, 88, -76)), ivec4(-768, 864, 1056, -912))) ? 1 : -1] array0;
  float[all(equal((12 * ivec4(64, 72, 88, 76)), ivec4(768, 864, 1056, 912))) ? 1 : -1] array1;
  float[all(equal((12 * ivec4(-24, 40, -23, 64)), ivec4(-288, 480, -276, 768))) ? 1 : -1] array2;
  float[all(equal((12 * ivec4(24, 40, 23, 64)), ivec4(288, 480, 276, 768))) ? 1 : -1] array3;
  float[all(equal((-6 * ivec4(-64, 72, 88, -76)), ivec4(384, -432, -528, 456))) ? 1 : -1] array4;
  float[all(equal((-6 * ivec4(64, 72, 88, 76)), ivec4(-384, -432, -528, -456))) ? 1 : -1] array5;
  float[all(equal((-6 * ivec4(-24, 40, -23, 64)), ivec4(144, -240, 138, -384))) ? 1 : -1] array6;
  float[all(equal((-6 * ivec4(24, 40, 23, 64)), ivec4(-144, -240, -138, -384))) ? 1 : -1] array7;
  float[all(equal((76 * ivec4(-64, 72, 88, -76)), ivec4(-4864, 5472, 6688, -5776))) ? 1 : -1] array8;
  float[all(equal((76 * ivec4(64, 72, 88, 76)), ivec4(4864, 5472, 6688, 5776))) ? 1 : -1] array9;
  float[all(equal((76 * ivec4(-24, 40, -23, 64)), ivec4(-1824, 3040, -1748, 4864))) ? 1 : -1] array10;
  float[all(equal((76 * ivec4(24, 40, 23, 64)), ivec4(1824, 3040, 1748, 4864))) ? 1 : -1] array11;
  float[all(equal((-32 * ivec4(-64, 72, 88, -76)), ivec4(2048, -2304, -2816, 2432))) ? 1 : -1] array12;
  float[all(equal((-32 * ivec4(64, 72, 88, 76)), ivec4(-2048, -2304, -2816, -2432))) ? 1 : -1] array13;
  float[all(equal((-32 * ivec4(-24, 40, -23, 64)), ivec4(768, -1280, 736, -2048))) ? 1 : -1] array14;
  float[all(equal((-32 * ivec4(24, 40, 23, 64)), ivec4(-768, -1280, -736, -2048))) ? 1 : -1] array15;
  float[all(equal((0 * ivec4(-64, 72, 88, -76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array16;
  float[all(equal((0 * ivec4(64, 72, 88, 76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array17;
  float[all(equal((0 * ivec4(-24, 40, -23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array18;
  float[all(equal((0 * ivec4(24, 40, 23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
