/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import java.security.Permission;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class KeyUtils {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final Algorithm drbgAlg = new Algorithm(){

        @Override
        public String getName() {
            return "KeyUtils-DRBG";
        }

        @Override
        public boolean requiresAlgorithmParameters() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    };
    private static final byte[] drbgPersonalize = Strings.toByteArray("KeyUtils Prime DRBG");

    KeyUtils() {
    }

    static BigInteger validated(DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        if (bigInteger.compareTo(TWO) < 0 || bigInteger.compareTo(dHDomainParameters.getP().subtract(TWO)) > 0) {
            throw new IllegalArgumentException("Y value is out of range");
        }
        if (dHDomainParameters.getQ() != null) {
            if (BigInteger.ONE.equals(bigInteger.modPow(dHDomainParameters.getQ(), dHDomainParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    static BigInteger validated(DSADomainParameters dSADomainParameters, BigInteger bigInteger) {
        if (dSADomainParameters != null) {
            if (TWO.compareTo(bigInteger) <= 0 && dSADomainParameters.getP().subtract(TWO).compareTo(bigInteger) >= 0 && BigInteger.ONE.equals(bigInteger.modPow(dSADomainParameters.getQ(), dSADomainParameters.getP()))) {
                return bigInteger;
            }
            throw new IllegalArgumentException("Y value does not appear to be in correct group");
        }
        return bigInteger;
    }

    static BigInteger validated(BigInteger bigInteger, BigInteger bigInteger2) {
        if ((bigInteger2.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA publicExponent is even");
        }
        return KeyUtils.validatedModulus(bigInteger);
    }

    static BigInteger validatedModulus(BigInteger bigInteger) {
        if (!AsymmetricRSAKey.isAlreadySeen(bigInteger)) {
            int n;
            int n2 = Properties.asInteger("org.bouncycastle.rsa.max_size", 15360);
            if (n2 < (n = bigInteger.bitLength())) {
                throw new IllegalArgumentException("modulus value out of range");
            }
            if ((bigInteger.intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA modulus is even");
            }
            if (!bigInteger.gcd(new BigInteger("1451887755777639901511587432083070202422614380984889313550570919659315177065956574359078912654149167643992684236991305777574330831666511589145701059710742276692757882915756220901998212975756543223550490431013061082131040808010565293748926901442915057819663730454818359472391642885328171302299245556663073719855")).equals(BigInteger.ONE)) {
                throw new IllegalArgumentException("RSA modulus has a small prime factor");
            }
            int n3 = bigInteger.bitLength() / 2;
            int n4 = n3 >= 1536 ? 3 : (n3 >= 1024 ? 4 : (n3 >= 512 ? 7 : 50));
            FipsSecureRandom fipsSecureRandom = FipsDRBG.fetchBasicDRBG(drbgAlg, FipsDRBG.SHA256, drbgPersonalize);
            Primes.MROutput mROutput = Primes.enhancedMRProbablePrimeTest(bigInteger, fipsSecureRandom, n4);
            if (!mROutput.isProvablyComposite()) {
                throw new IllegalArgumentException("RSA modulus is not composite");
            }
            if (!mROutput.isNotPrimePower()) {
                throw new IllegalArgumentException("RSA modulus is a power of a prime");
            }
        }
        return bigInteger;
    }

    static ECPoint validated(ECCurve eCCurve, ECPoint eCPoint) {
        if (eCPoint == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if ((eCPoint = ECAlgorithms.importPoint(eCCurve, eCPoint).normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Point not on curve");
        }
        return eCPoint;
    }

    static ECPoint validated(ECCurve eCCurve, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Point encoding has null value");
        }
        ECPoint eCPoint = eCCurve.decodePoint(byArray);
        if (eCPoint == null) {
            throw new IllegalArgumentException("Point has null value");
        }
        if ((eCPoint = eCPoint.normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        return eCPoint;
    }

    static boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    static X962Parameters buildCurveParameters(ECDomainParameters eCDomainParameters) {
        X962Parameters x962Parameters;
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            x962Parameters = new X962Parameters(((NamedECDomainParameters)eCDomainParameters).getID());
        } else if (eCDomainParameters instanceof ECImplicitDomainParameters) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            X9ECParameters x9ECParameters = new X9ECParameters(eCDomainParameters.getCurve(), new X9ECPoint(eCDomainParameters.getG(), false), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        return x962Parameters;
    }

    static int getOrderBitLength(ECDomainParameters eCDomainParameters) {
        return eCDomainParameters.getN().bitLength();
    }

    static boolean isDHPKCSParam(ASN1Encodable aSN1Encodable) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable);
        if (aSN1Sequence.size() == 2) {
            return true;
        }
        if (aSN1Sequence.size() > 3) {
            return false;
        }
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
        ASN1Integer aSN1Integer2 = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        return aSN1Integer.getValue().compareTo(BigInteger.valueOf(aSN1Integer2.getValue().bitLength())) <= 0;
    }

    static byte[] getEncodedInfo(ASN1Object aSN1Object) {
        try {
            return aSN1Object.getEncoded("DER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[] getEncodedSubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, aSN1Encodable.toASN1Primitive());
            return KeyUtils.getEncodedInfo(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, aSN1Encodable.toASN1Primitive());
            return KeyUtils.getEncodedInfo(privateKeyInfo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable, ASN1Set aSN1Set, byte[] byArray) {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, aSN1Encodable.toASN1Primitive(), aSN1Set, byArray);
            return KeyUtils.getEncodedInfo(privateKeyInfo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void checkDestroyed(Destroyable destroyable) {
        if (destroyable.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }

    static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    static boolean isValidPrefix(byte[] byArray, byte[] byArray2) {
        if (byArray2.length < byArray.length) {
            return !KeyUtils.isValidPrefix(byArray, byArray);
        }
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    static byte[] isValidEdDSAPublicKey(byte[] byArray) {
        if (byArray.length == 32) {
            if (!Ed25519.validatePublicKeyFull(byArray, 0)) {
                throw new IllegalArgumentException("invalid Ed25519 public key data");
            }
        } else if (byArray.length == 57) {
            if (!Ed448.validatePublicKeyFull(byArray, 0)) {
                throw new IllegalArgumentException("invalid Ed448 public key data");
            }
        } else {
            throw new IllegalArgumentException("public key data wrong length");
        }
        return byArray;
    }

    static boolean isFieldEqual(Object object, Object object2) {
        return object != null && object.equals(object2);
    }
}

