/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.CommitmentPolicy;

public class GetEncryptionMaterialsInput {
    private final Map<String, String> encryptionContext;
    private final CommitmentPolicy commitmentPolicy;
    private final AlgorithmSuiteId algorithmSuiteId;
    private final Long maxPlaintextLength;
    private final List<String> requiredEncryptionContextKeys;

    protected GetEncryptionMaterialsInput(BuilderImpl builder) {
        this.encryptionContext = builder.encryptionContext();
        this.commitmentPolicy = builder.commitmentPolicy();
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.maxPlaintextLength = builder.maxPlaintextLength();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public CommitmentPolicy commitmentPolicy() {
        return this.commitmentPolicy;
    }

    public AlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Long maxPlaintextLength() {
        return this.maxPlaintextLength;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, String> encryptionContext;
        protected CommitmentPolicy commitmentPolicy;
        protected AlgorithmSuiteId algorithmSuiteId;
        protected Long maxPlaintextLength;
        protected List<String> requiredEncryptionContextKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetEncryptionMaterialsInput model) {
            this.encryptionContext = model.encryptionContext();
            this.commitmentPolicy = model.commitmentPolicy();
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.maxPlaintextLength = model.maxPlaintextLength();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder commitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this.commitmentPolicy = commitmentPolicy;
            return this;
        }

        @Override
        public CommitmentPolicy commitmentPolicy() {
            return this.commitmentPolicy;
        }

        @Override
        public Builder algorithmSuiteId(AlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public AlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder maxPlaintextLength(Long maxPlaintextLength) {
            this.maxPlaintextLength = maxPlaintextLength;
            return this;
        }

        @Override
        public Long maxPlaintextLength() {
            return this.maxPlaintextLength;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public GetEncryptionMaterialsInput build() {
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.commitmentPolicy())) {
                throw new IllegalArgumentException("Missing value for required field `commitmentPolicy`");
            }
            return new GetEncryptionMaterialsInput(this);
        }
    }

    public static interface Builder {
        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder commitmentPolicy(CommitmentPolicy var1);

        public CommitmentPolicy commitmentPolicy();

        public Builder algorithmSuiteId(AlgorithmSuiteId var1);

        public AlgorithmSuiteId algorithmSuiteId();

        public Builder maxPlaintextLength(Long var1);

        public Long maxPlaintextLength();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public GetEncryptionMaterialsInput build();
    }
}

