/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import org.opensearch.protobufs.ScriptSort;
import org.opensearch.protobufs.ScriptSortType;
import org.opensearch.script.Script;
import org.opensearch.search.sort.ScriptSortBuilder;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.NestedSortProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.util.ProtobufEnumUtils;

public class ScriptSortProtoUtils {
    private ScriptSortProtoUtils() {
    }

    public static ScriptSortBuilder fromProto(ScriptSort scriptSort, QueryBuilderProtoConverterRegistry registry) {
        if (scriptSort == null) {
            throw new IllegalArgumentException("ScriptSort cannot be null");
        }
        if (!scriptSort.hasScript()) {
            throw new IllegalArgumentException("ScriptSort must have a script");
        }
        if (!scriptSort.hasType()) {
            throw new IllegalArgumentException("ScriptSort must have a type");
        }
        Script script = ScriptProtoUtils.parseFromProtoRequest(scriptSort.getScript());
        if (scriptSort.getType() == ScriptSortType.SCRIPT_SORT_TYPE_UNSPECIFIED) {
            throw new IllegalArgumentException("ScriptSortType must be specified");
        }
        ScriptSortBuilder.ScriptSortType type = ScriptSortBuilder.ScriptSortType.fromString((String)ProtobufEnumUtils.convertToString(scriptSort.getType()));
        ScriptSortBuilder builder = new ScriptSortBuilder(script, type);
        if (scriptSort.hasOrder()) {
            builder.order(SortOrder.fromString((String)ProtobufEnumUtils.convertToString(scriptSort.getOrder())));
        }
        if (scriptSort.hasMode()) {
            builder.sortMode(SortMode.fromString((String)ProtobufEnumUtils.convertToString(scriptSort.getMode())));
        }
        if (scriptSort.hasNested()) {
            builder.setNestedSort(NestedSortProtoUtils.fromProto(scriptSort.getNested(), registry));
        }
        return builder;
    }
}

