/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.opensearch.common.bytes.ReleasableBytesReference;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.bytes.CompositeBytesReference;
import org.opensearch.transport.Header;
import org.opensearch.transport.InboundAggregator;
import org.opensearch.transport.InboundDecoder;
import org.opensearch.transport.InboundMessage;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;

class InboundBytesHandler {
    private static final ThreadLocal<ArrayList<Object>> fragmentList = ThreadLocal.withInitial(ArrayList::new);
    private final ArrayDeque<ReleasableBytesReference> pending;
    private final InboundDecoder decoder;
    private final InboundAggregator aggregator;
    private final StatsTracker statsTracker;
    private boolean isClosed = false;

    InboundBytesHandler(ArrayDeque<ReleasableBytesReference> pending, InboundDecoder decoder, InboundAggregator aggregator, StatsTracker statsTracker) {
        this.pending = pending;
        this.decoder = decoder;
        this.aggregator = aggregator;
        this.statsTracker = statsTracker;
    }

    public void close() {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleBytes(TcpChannel channel, ReleasableBytesReference reference, BiConsumer<TcpChannel, InboundMessage> messageHandler) throws IOException {
        ArrayList<Object> fragments = fragmentList.get();
        boolean continueHandling = true;
        while (continueHandling && !this.isClosed) {
            boolean continueDecoding = true;
            while (continueDecoding && !this.pending.isEmpty()) {
                ReleasableBytesReference toDecode = this.getPendingBytes();
                try {
                    int bytesDecoded = this.decoder.decode(toDecode, fragments::add);
                    if (bytesDecoded != 0) {
                        this.releasePendingBytes(bytesDecoded);
                        if (fragments.isEmpty() || !this.endOfMessage(fragments.get(fragments.size() - 1))) continue;
                        continueDecoding = false;
                        continue;
                    }
                    continueDecoding = false;
                }
                finally {
                    if (toDecode == null) continue;
                    toDecode.close();
                }
            }
            if (fragments.isEmpty()) {
                continueHandling = false;
                continue;
            }
            try {
                this.forwardFragments(channel, fragments, messageHandler);
            }
            finally {
                for (Object fragment : fragments) {
                    if (!(fragment instanceof ReleasableBytesReference)) continue;
                    ReleasableBytesReference releasableBytesReference = (ReleasableBytesReference)fragment;
                    releasableBytesReference.close();
                }
                fragments.clear();
            }
        }
    }

    private ReleasableBytesReference getPendingBytes() {
        if (this.pending.size() == 1) {
            return this.pending.peekFirst().retain();
        }
        BytesReference[] bytesReferences = new ReleasableBytesReference[this.pending.size()];
        int index = 0;
        for (ReleasableBytesReference pendingReference : this.pending) {
            bytesReferences[index] = pendingReference.retain();
            ++index;
        }
        Releasable releasable = () -> InboundBytesHandler.lambda$getPendingBytes$0((ReleasableBytesReference[])bytesReferences);
        return new ReleasableBytesReference(CompositeBytesReference.of((BytesReference[])bytesReferences), releasable);
    }

    private void releasePendingBytes(int bytesConsumed) {
        int bytesToRelease = bytesConsumed;
        while (bytesToRelease != 0) {
            ReleasableBytesReference reference = this.pending.pollFirst();
            try {
                assert (reference != null);
                if (bytesToRelease < reference.length()) {
                    this.pending.addFirst(reference.retainedSlice(bytesToRelease, reference.length() - bytesToRelease));
                    bytesToRelease -= bytesToRelease;
                    continue;
                }
                bytesToRelease -= reference.length();
            }
            finally {
                if (reference == null) continue;
                reference.close();
            }
        }
    }

    private boolean endOfMessage(Object fragment) {
        return fragment == InboundDecoder.PING || fragment == InboundDecoder.END_CONTENT || fragment instanceof Exception;
    }

    private void forwardFragments(TcpChannel channel, ArrayList<Object> fragments, BiConsumer<TcpChannel, InboundMessage> messageHandler) throws IOException {
        for (Object fragment : fragments) {
            if (fragment instanceof Header) {
                Header header = (Header)fragment;
                assert (!this.aggregator.isAggregating());
                this.aggregator.headerReceived(header);
                continue;
            }
            if (fragment == InboundDecoder.PING) {
                assert (!this.aggregator.isAggregating());
                messageHandler.accept(channel, InboundMessage.PING);
                continue;
            }
            if (fragment == InboundDecoder.END_CONTENT) {
                assert (this.aggregator.isAggregating());
                InboundMessage aggregated = this.aggregator.finishAggregation();
                try {
                    this.statsTracker.markMessageReceived();
                    messageHandler.accept(channel, aggregated);
                    continue;
                }
                finally {
                    if (aggregated != null) {
                        aggregated.close();
                    }
                    continue;
                }
            }
            assert (this.aggregator.isAggregating());
            assert (fragment instanceof ReleasableBytesReference);
            this.aggregator.aggregate((ReleasableBytesReference)fragment);
        }
    }

    private static /* synthetic */ void lambda$getPendingBytes$0(ReleasableBytesReference[] bytesReferences) {
        Releasables.closeWhileHandlingException((Releasable[])bytesReferences);
    }
}

