/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.BaseAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

@PublicApi(since="1.0.0")
public abstract class AggregationBuilder
implements NamedWriteable,
ToXContentFragment,
BaseAggregationBuilder,
Rewriteable<AggregationBuilder> {
    protected final String name;
    protected AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder();

    protected AggregationBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        this.name = name;
    }

    protected AggregationBuilder(AggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder) {
        this.name = clone.name;
        this.factoriesBuilder = factoriesBuilder;
    }

    public String getName() {
        return this.name;
    }

    protected abstract AggregatorFactory build(QueryShardContext var1, AggregatorFactory var2) throws IOException;

    @Override
    public abstract AggregationBuilder setMetadata(Map<String, Object> var1);

    public abstract Map<String, Object> getMetadata();

    public abstract AggregationBuilder subAggregation(AggregationBuilder var1);

    public abstract AggregationBuilder subAggregation(PipelineAggregationBuilder var1);

    public Collection<AggregationBuilder> getSubAggregations() {
        return this.factoriesBuilder.getAggregatorFactories();
    }

    public Collection<PipelineAggregationBuilder> getPipelineAggregations() {
        return this.factoriesBuilder.getPipelineAggregatorFactories();
    }

    @Override
    public abstract AggregationBuilder subAggregations(AggregatorFactories.Builder var1);

    protected abstract AggregationBuilder shallowCopy(AggregatorFactories.Builder var1, Map<String, Object> var2);

    @Override
    public final AggregationBuilder rewrite(QueryRewriteContext context) throws IOException {
        AggregationBuilder rewritten = this.doRewrite(context);
        AggregatorFactories.Builder rewrittenSubAggs = this.factoriesBuilder.rewrite(context);
        if (rewritten != this) {
            return ((AggregationBuilder)rewritten.setMetadata((Map)this.getMetadata())).subAggregations(rewrittenSubAggs);
        }
        if (rewrittenSubAggs != this.factoriesBuilder) {
            return this.shallowCopy(rewrittenSubAggs, this.getMetadata());
        }
        return this;
    }

    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    public PipelineAggregator.PipelineTree buildPipelineTree() {
        return this.factoriesBuilder.buildPipelineTree();
    }

    public abstract BucketCardinality bucketCardinality();

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public static final class CommonFields
    extends ParseField.CommonFields {
        public static final ParseField VALUE_TYPE = new ParseField("value_type", new String[0]);
    }

    @PublicApi(since="1.0.0")
    public static enum BucketCardinality {
        NONE,
        ONE,
        MANY;

    }
}

