/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.normalizer;

import com.o19s.es.ltr.ranker.normalizer.Normalizer;

public class StandardFeatureNormalizer
implements Normalizer {
    private float mean;
    private float stdDeviation;

    public StandardFeatureNormalizer(float mean, float stdDeviation) {
        this.mean = mean;
        this.stdDeviation = stdDeviation;
    }

    @Override
    public float normalize(float value) {
        return (value - this.mean) / this.stdDeviation;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StandardFeatureNormalizer)) {
            return false;
        }
        StandardFeatureNormalizer that = (StandardFeatureNormalizer)other;
        if (this.mean != that.mean) {
            return false;
        }
        return this.stdDeviation == that.stdDeviation;
    }

    public int hashCode() {
        int hashCode = Float.hashCode(this.mean);
        return hashCode += 31 * Float.hashCode(this.stdDeviation);
    }
}

